/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventbus;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.swing.SwingUtilities;
import org.seamcat.eventbus.BusExceptionEvent;
import org.seamcat.eventbus.EventBus;
import org.seamcat.eventbus.EventHandler;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.eventbus.VetoEvent;
import org.seamcat.eventbus.VetoException;

public final class BasicEventBus
implements EventBus {
    private final List<HandlerInfo> handlers = new CopyOnWriteArrayList<HandlerInfo>();
    private final BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
    private final BlockingQueue<HandlerInfo> killQueue = new LinkedBlockingQueue<HandlerInfo>();
    private final ExecutorService executorService;
    private final boolean waitForHandlers;

    public BasicEventBus() {
        this(Executors.newCachedThreadPool(new ThreadFactory(){
            private final ThreadFactory delegate = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = this.delegate.newThread(r);
                t.setDaemon(true);
                return t;
            }
        }), false);
    }

    public BasicEventBus(ExecutorService executorService, boolean waitForHandlers) {
        Thread eventQueueThread = new Thread((Runnable)new EventQueueRunner(), "EventQueue Consumer Thread");
        eventQueueThread.setDaemon(true);
        eventQueueThread.start();
        Thread killQueueThread = new Thread((Runnable)new KillQueueRunner(), "KillQueue Consumer Thread");
        killQueueThread.setDaemon(true);
        killQueueThread.start();
        this.executorService = executorService;
        this.waitForHandlers = waitForHandlers;
    }

    @Override
    public void subscribe(Object subscriber) {
        Method[] methods;
        boolean subscribedAlready = false;
        for (HandlerInfo info : this.handlers) {
            Object otherSubscriber = info.getSubscriber();
            if (otherSubscriber == null) {
                try {
                    this.killQueue.put(info);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (subscriber != otherSubscriber) continue;
            subscribedAlready = true;
        }
        if (subscribedAlready) {
            return;
        }
        for (Method method : methods = subscriber.getClass().getDeclaredMethods()) {
            EventHandler eh = method.getAnnotation(EventHandler.class);
            UIEventHandler uiEh = method.getAnnotation(UIEventHandler.class);
            if (eh == null && uiEh == null) continue;
            boolean canVeto = eh == null ? uiEh.canVeto() : eh.canVeto();
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1) {
                throw new IllegalArgumentException("EventHandler methods must specify a single Object paramter.");
            }
            HandlerInfo info = new HandlerInfo(parameters[0], method, subscriber, canVeto);
            this.handlers.add(info);
        }
    }

    @Override
    public void unsubscribe(Object subscriber) {
        ArrayList<HandlerInfo> killList = new ArrayList<HandlerInfo>();
        for (HandlerInfo info : this.handlers) {
            Object obj = info.getSubscriber();
            if (obj != null && obj != subscriber) continue;
            killList.add(info);
        }
        for (HandlerInfo kill : killList) {
            this.handlers.remove(kill);
        }
    }

    @Override
    public void publish(Object event) {
        try {
            this.queue.put(event);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasPendingEvents() {
        return this.queue.size() > 0;
    }

    private void notifySubscribers(Object evt) {
        ArrayList<HandlerInfoCallable> vetoList = new ArrayList<HandlerInfoCallable>();
        final ArrayList<HandlerInfoCallable> reguList = new ArrayList<HandlerInfoCallable>();
        for (HandlerInfo handlerInfo : this.handlers) {
            if (!handlerInfo.matchesEvent(evt)) continue;
            HandlerInfoCallable handlerInfoCallable = new HandlerInfoCallable(handlerInfo, evt);
            if (handlerInfo.isVetoHandler()) {
                vetoList.add(handlerInfoCallable);
                continue;
            }
            reguList.add(handlerInfoCallable);
        }
        boolean vetoCalled = false;
        try {
            for (Future future : this.executorService.invokeAll(vetoList)) {
                if (!((Boolean)future.get()).booleanValue()) continue;
                vetoCalled = true;
            }
        }
        catch (Exception exception) {
            vetoCalled = true;
            exception.printStackTrace();
        }
        if (vetoCalled && evt instanceof VetoEvent) {
            vetoCalled = false;
        }
        if (vetoCalled) {
            return;
        }
        if (this.waitForHandlers) {
            try {
                this.executorService.invokeAll(reguList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        BasicEventBus.this.executorService.invokeAll(reguList);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private class HandlerInfoCallable
    implements Callable<Boolean> {
        private final HandlerInfo handlerInfo;
        private final Object event;

        public HandlerInfoCallable(HandlerInfo handlerInfo, Object event) {
            this.handlerInfo = handlerInfo;
            this.event = event;
        }

        @Override
        public Boolean call() {
            try {
                final Object subscriber = this.handlerInfo.getSubscriber();
                if (subscriber == null) {
                    BasicEventBus.this.killQueue.put(this.handlerInfo);
                    return false;
                }
                if (this.handlerInfo.getMethod().getAnnotation(UIEventHandler.class) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                HandlerInfoCallable.this.handlerInfo.getMethod().invoke(subscriber, HandlerInfoCallable.this.event);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                } else {
                    this.handlerInfo.getMethod().invoke(subscriber, this.event);
                }
                return false;
            }
            catch (Exception e) {
                Throwable cause = e;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (cause instanceof VetoException) {
                    BasicEventBus.this.publish(new VetoEvent(this.event));
                    return true;
                }
                BasicEventBus.this.publish(new BusExceptionEvent(this.handlerInfo, cause));
                cause.printStackTrace();
                return false;
            }
        }
    }

    private static class HandlerInfo {
        private final Class<?> eventClass;
        private final Method method;
        private final WeakReference<?> subscriber;
        private final boolean vetoHandler;

        public HandlerInfo(Class<?> eventClass, Method method, Object subscriber, boolean vetoHandler) {
            this.eventClass = eventClass;
            this.method = method;
            this.subscriber = new WeakReference<Object>(subscriber);
            this.vetoHandler = vetoHandler;
        }

        public boolean matchesEvent(Object event) {
            return event.getClass().equals(this.eventClass);
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getSubscriber() {
            return this.subscriber.get();
        }

        public boolean isVetoHandler() {
            return this.vetoHandler;
        }
    }

    private class KillQueueRunner
    implements Runnable {
        private KillQueueRunner() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    HandlerInfo info;
                    if ((info = (HandlerInfo)BasicEventBus.this.killQueue.take()).getSubscriber() != null) {
                        continue;
                    }
                    BasicEventBus.this.handlers.remove(info);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private class EventQueueRunner
    implements Runnable {
        private EventQueueRunner() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    BasicEventBus.this.notifySubscribers(BasicEventBus.this.queue.take());
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

