/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventbus;

import java.awt.Component;
import java.awt.Container;
import java.util.HashSet;
import java.util.Set;
import org.seamcat.eventbus.EventBusFactory;

public class Subscriber {
    private static Set<Component> subscriptions = new HashSet<Component>();

    public static void subscribe(Component component) {
        EventBusFactory.getEventBus().subscribe(component);
        subscriptions.add(component);
    }

    public static void unSubscribeDeep(Container container) {
        if (container == null) {
            return;
        }
        Subscriber.unSubscribe(container);
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                Subscriber.unSubscribeDeep((Container)component);
                continue;
            }
            Subscriber.unSubscribe(component);
        }
    }

    private static void unSubscribe(Component component) {
        if (subscriptions.contains(component)) {
            subscriptions.remove(component);
            EventBusFactory.getEventBus().unsubscribe(component);
        }
    }
}

