/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import java.util.List;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkSystemPlugin;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.cellular.OFDMADownLinkVictimSystemSimulation;
import org.seamcat.simulation.hybrid.HybridOFDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin;

public class DemoEPP_10_OFDMA_Internals
implements EventProcessingPlugin<Input> {
    @Override
    public void evaluate(Scenario scenario, EventResult result, Input input, Collector collector) {
        VictimResultCollector vCollector = result.getVictimResult();
        String name = scenario.getVictim().getName();
        for (int i = 0; i < vCollector.getVictims().size(); ++i) {
            collector.add(Factory.results().group("Distances", name + "_" + String.valueOf(i), "km"), vCollector.getVictims().get(i).getLinkResult().getTxRxDistance());
            if (input.externalInterferenceUnwanted()) {
                collector.add(Factory.results().group("External interference unwanted", name + "_" + String.valueOf(i), "dBm"), vCollector.getVictims().get(i).getTotalInterferenceUnwanted());
            }
            if (!input.externalInterferenceBlocking()) continue;
            collector.add(Factory.results().group("External interference blocking", name + "_" + String.valueOf(i), "dBm"), vCollector.getVictims().get(i).getTotalInterferenceBlocking());
        }
        this.handle(input.frequency(), OFDMADownLinkVictimSystemSimulation.FREQUENCY_ALL, collector, vCollector, name);
        this.handle(input.bitRateAchieved(), OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED_ALL, collector, vCollector, name);
        this.handle(input.receivedPower(), OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER_ALL, collector, vCollector, name);
        this.handle(input.SINRAchieved(), OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED_ALL, collector, vCollector, name);
        this.handle(input.currentTransmitPower(), OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER_ALL, collector, vCollector, name);
        this.handle(input.interferencePower(), OFDMADownLinkVictimSystemSimulation.INTERFERENCE_POWER_ALL, collector, vCollector, name);
        this.handle(input.interSystemInterference(), OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE_ALL, collector, vCollector, name);
        this.handle(input.baseStationBitRate(), OFDMADownLinkVictimSystemSimulation.BASE_STATION_BIT_RATE_ALL, collector, vCollector, name);
        this.handle(input.pathLoss(), OFDMADownLinkVictimSystemSimulation.PATH_LOSS_ALL, collector, vCollector, name);
        this.handle(input.effectivePathLoss(), OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS_ALL, collector, vCollector, name);
    }

    private void handle(boolean relevant, VectorDef def, Collector col, VictimResultCollector vCol, String name) {
        List<Double> vector;
        if (relevant && (vector = vCol.getSamples(def)) != null) {
            int count = 0;
            for (double v : vector) {
                VectorDef rDef = Factory.results().group(def.name().replace("(all)", ""), name + "_" + String.valueOf(count++), def.unit());
                col.add(rDef, v);
            }
        }
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
        boolean isValid;
        Scenario scenario = context.getScenario();
        SystemPlugin plugin = scenario.getVictim().getSystemPlugin();
        boolean bl = isValid = plugin instanceof HybridOFDMADownLinkPlugin || plugin instanceof HybridOFDMAUpLinkPlugin || plugin instanceof IMT2020DownLinkSystemPlugin || plugin instanceof IMT2020UpLinkSystemPlugin || plugin instanceof IMT2020DownLinkMicroSystemPlugin || plugin instanceof IMT2020UpLinkMicroSystemPlugin;
        if (!isValid) {
            validator.error("Can only be applied if victim system is an OFDMA system (UL or DL) or an IMT-2020 system (UL or DL");
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 10: OFDMA Internals", "<html>This plugin will expose internal variables from an OFDMA or an IMT-2020 victim simulation</html>");
    }

    public static interface Input {
        @Config(order=3, name="Frequency")
        public boolean frequency();

        @Config(order=5, name="Bit rate achieved")
        public boolean bitRateAchieved();

        @Config(order=6, name="Received power")
        public boolean receivedPower();

        @Config(order=7, name="SINR achieved")
        public boolean SINRAchieved();

        @Config(order=8, name="Current transmit power")
        public boolean currentTransmitPower();

        @Config(order=9, name="DL total interference power")
        public boolean interferencePower();

        @Config(order=10, name="Inter system interference")
        public boolean interSystemInterference();

        @Config(order=12, name="External interference blocking")
        public boolean externalInterferenceBlocking();

        @Config(order=13, name="External interference unwanted")
        public boolean externalInterferenceUnwanted();

        @Config(order=14, name="Base station bit rate achieved")
        public boolean baseStationBitRate();

        @Config(order=17, name="Path loss")
        public boolean pathLoss();

        @Config(order=18, name="Effective path loss")
        public boolean effectivePathLoss();
    }
}

