/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.eventprocessing.ValidateDataUI;
import org.seamcat.model.Scenario;
import org.seamcat.model.antenna.APmanufacturerDataInput;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.eventprocessing.PostProcessingTab;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class DemoEPP_13_ValidateDataAP
implements EventProcessingPlugin<Input>,
PostProcessingTab {
    @Override
    public Description description() {
        return new DescriptionImpl("Demo 13: Validate Data Antenna Gain Plugins", "");
    }

    @Override
    public void evaluate(Scenario scenario, EventResult result, Input input, Collector collector) {
        String groupSystemLink = "systemLink";
        String groupInterferenceLink = "interferenceLink";
        VictimResultCollector vResult = result.getVictimResult();
        double[] appluedByAP = this.getAnglesUsedByAP(vResult.getVictims().get(0).getLinkResult());
        double phi = appluedByAP[0];
        double theta = appluedByAP[1];
        if (phi > 90.0 && phi < 270.0) {
            theta = theta >= 0.0 ? 180.0 - theta : -180.0 - theta;
        }
        VectorDef DRSS = Factory.results().value("dRSS", "dBm");
        Double d = result.getVictimResult().get(DRSS);
        collector.add(Factory.results().group(groupSystemLink, "azimuth", "deg"), vResult.getVictims().get(0).getLinkResult().rxAntenna().getAzimuth());
        collector.add(Factory.results().group(groupSystemLink, "elevation", "deg"), vResult.getVictims().get(0).getLinkResult().rxAntenna().getElevation());
        collector.add(Factory.results().group(groupSystemLink, "tilt", "deg"), vResult.getVictims().get(0).getLinkResult().rxAntenna().getTilt());
        collector.add(Factory.results().group(groupSystemLink, "azimuthCorrected", "deg"), phi);
        collector.add(Factory.results().group(groupSystemLink, "elevationCorrected", "deg"), theta);
        collector.add(Factory.results().group(groupSystemLink, "gain", "dBi"), vResult.getVictims().get(0).getLinkResult().rxAntenna().getGain());
    }

    private double[] getAnglesUsedByAP(LinkResult linkResult) {
        double[] res = new double[2];
        double phiH = linkResult.rxAntenna().getAzimuth();
        double thetaH = linkResult.rxAntenna().getElevation();
        double tilt = linkResult.rxAntenna().getTilt();
        double theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.sinD(tilt));
        if (phiH > 180.0) {
            phiH = -360.0 + phiH;
        }
        double phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
        res[0] = phi = linkResult.rxAntenna().getAzimuth() > 180.0 ? 360.0 - phi : phi;
        res[1] = theta;
        return res;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
        Scenario scenario = context.getScenario();
        if (scenario.getVictim().getSystemPlugin() instanceof GenericSystemPlugin) {
            if (!(scenario.getVictim().getSystem().getReceiver().getAntennaGain().getModel() instanceof APmanufacturerDataInput)) {
                validator.error("The VLR must apply AntennaManufacturerData as antenna.");
            }
        } else {
            validator.error("This plugin is only applicable to Generic Systems");
        }
    }

    @Override
    public List<Class<? extends PostProcessingUI>> tabs() {
        ArrayList<Class<? extends PostProcessingUI>> tabs = new ArrayList<Class<? extends PostProcessingUI>>();
        tabs.add(ValidateDataUI.class);
        return tabs;
    }

    public static interface Input {
    }
}

