/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import java.util.List;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;

public class DemoEPP_2_developNewAlgorithm
implements EventProcessingPlugin<Input> {
    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 2: Develop a new algorithm - signals at ILR", "<html>Calculate the Received Signal Strength at the ILR: This Event <br>Processing Plugin allows to generate the received signal strength at the <br>Interfering Link Receiver with or without PC</html>");
    }

    @Override
    public void evaluate(Scenario scenario, EventResult res, Input input, Collector collector) {
        if (input.display()) {
            for (int i = 0; i < scenario.getInterferenceLinks().size(); ++i) {
                String nameDecription;
                double rResult;
                InterferenceLink link = scenario.getInterferenceLinks().get(i);
                List<InterferenceLinkResult> results = res.getInterferenceLinkResult(link);
                LinkResult interfererResult = results.get(0).getInterferingSystemLink();
                double rPowerSupplied = interfererResult.getTxPower();
                double rGainItWr = interfererResult.txAntenna().getGain();
                double rGainWrIt = interfererResult.rxAntenna().getGain();
                double rPathLossItWr = interfererResult.getTxRxPathLoss();
                double rStep = input.stepSize();
                double rPmin = input.minThreshold();
                double rRange = input.dynamicRange();
                double rPinit = rPowerSupplied + rGainItWr - rPathLossItWr + rGainWrIt;
                if (input.usePowerControl()) {
                    double rResultPowerGain = rPinit > rPmin && rPinit < rPmin + rRange ? -rStep * Math.floor((rPinit - rPmin) / rStep) : (rPinit <= rPmin ? 0.0 : -rRange);
                    rResult = rPinit + rResultPowerGain;
                    nameDecription = link.getInterferer().getName() + " - ILR signal strength with PC";
                } else {
                    rResult = rPinit;
                    nameDecription = link.getInterferer().getName() + " - ILR signal strength without PC";
                }
                collector.add(Factory.results().value(nameDecription, "dBm"), rResult);
            }
        }
    }

    public static interface Input {
        public static final double stepSize = 2.0;
        public static final double minThreshold = -103.0;
        public static final double dynamicRange = 6.0;

        @Config(order=1, name="Use power control")
        public boolean usePowerControl();

        @Config(order=2, name="Power control step size", unit="dB")
        public double stepSize();

        @Config(order=3, name="Min Threshold", unit="dBm")
        public double minThreshold();

        @Config(order=4, name="Dynamic Range", unit="dB")
        public double dynamicRange();

        @Config(order=5, name="Display the output vector")
        public boolean display();
    }
}

