/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class DemoEPP_3_developNewAlgorithm_checkTxPower
implements EventProcessingPlugin<Input> {
    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
        boolean genericISUsingPowerControl = false;
        Scenario scenario = context.getScenario();
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            genericISUsingPowerControl = link.getInterferer().getSystem().getTransmitter().isUsingPowerControl();
        }
        if (!genericISUsingPowerControl) {
            validator.error("Have at least on generic interfering system using power control");
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 3: Develop a new algorithm - compare iRSS", "<html>Compare results of computation from the plugin and directly from SEAMCAT: <br>This Event Processing Plugin allows to check the interfering Tx power by <br>extracting it (for each link) from SEAMCAT internal calculator and by comparing <br>it with the value computed by the algorithm of the plugin</html>");
    }

    @Override
    public void evaluate(Scenario scenario, EventResult res, Input input, Collector collector) {
        if (input.display()) {
            for (int i = 0; i < scenario.getInterferenceLinks().size(); ++i) {
                InterferenceLink link = scenario.getInterferenceLinks().get(i);
                if (!(link.getInterferer().getSystemPlugin() instanceof GenericSystemPlugin)) continue;
                RadioSystem is = link.getInterferer().getSystem();
                for (InterferenceLinkResult result : res.getInterferenceLinkResult(link)) {
                    String textDecription1;
                    double rResult;
                    LinkResult interfererResult = result.getInterferingSystemLink();
                    double rPowerSupplied = interfererResult.getTxPower();
                    double rGainItWr = interfererResult.txAntenna().getGain();
                    double rGainWrIt = interfererResult.rxAntenna().getGain();
                    double rPathLossItWr = interfererResult.getTxRxPathLoss();
                    double rPmin = input.minThreshold();
                    double rPinit = rPowerSupplied + rGainItWr - rPathLossItWr + rGainWrIt;
                    if (input.usePowerControl()) {
                        double rResultPowerGain = rPinit > rPmin && rPinit < rPmin + input.dynamicRange() ? -input.stepSize() * Math.floor((rPinit - rPmin) / input.stepSize()) : (rPinit <= rPmin ? 0.0 : -input.dynamicRange());
                        rResult = rPowerSupplied + rResultPowerGain;
                        textDecription1 = link.getInterferer().getName() + " - Interfering Tx power with PC";
                    } else {
                        rResult = rPowerSupplied;
                        textDecription1 = link.getInterferer().getName() + " - Interfering Tx power without PC";
                    }
                    collector.add(Factory.results().value(textDecription1, "dBm"), rResult);
                    String textDecription2 = is.getTransmitter().isUsingPowerControl() ? link.getInterferer().getName() + " - ref. (from SEAMCAT) Interfering Tx power with PC" : link.getInterferer().getName() + " - ref. (from SEAMCAT) Interfering Tx power without PC";
                    collector.add(Factory.results().value(textDecription2, "dBm"), rPowerSupplied + (Double)interfererResult.getValue(SystemPlugin.TX_POWER_CONTROL_GAIN));
                }
            }
        }
    }

    public static interface Input {
        public static final double stepSize = 2.0;
        public static final double minThreshold = -103.0;
        public static final double dynamicRange = 6.0;

        @Config(order=1, name="Use power control")
        public boolean usePowerControl();

        @Config(order=2, name="Power control step size", unit="dB")
        public double stepSize();

        @Config(order=3, name="Min Threshold", unit="dBm")
        public double minThreshold();

        @Config(order=4, name="Dynamic Range", unit="dB")
        public double dynamicRange();

        @Config(order=5, name="Display the output vector")
        public boolean display();
    }
}

