/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.eventprocessing.ValidateDataUI_Input;
import org.seamcat.eventprocessing.ituantennas.TestITUInterferenceLinkResult;
import org.seamcat.model.Scenario;
import org.seamcat.model.antenna.APmanufacturerDataInput;
import org.seamcat.model.antenna.AntennaManufacturerData;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.DataExporter;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.Service;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.eventprocessing.Panels;
import org.seamcat.model.plugin.eventprocessing.PostProcessing;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.result.Results;

public class ValidateDataUI
implements PostProcessingUI {
    private JPanel plotPanel = new JPanel(new BorderLayout());
    private JSplitPane split;
    private Panels panels;
    private double offsetAzimuth;
    private double offsetElevation;
    private double tilt;
    private double elevationCompensation;
    private ValidateDataUI_Input inputPanel;
    private JPanel infoPanel = new JPanel();
    private ArrayList<Double> angles;
    private ArrayList<Double> values;
    private ArrayList<Double> valuesHorizontalVertical;
    private ArrayList<Double> valuesHorizontalVerticalNew;
    private ArrayList<Point2D> horizontalPatternOrigin;
    private ArrayList<Point2D> verticalPatternOrigin;
    @Service
    private DataExporter dataExporter;

    public double getOffsetAzimuth() {
        return this.offsetAzimuth;
    }

    public double getOffsetElevation() {
        return this.offsetElevation;
    }

    public double getTilt() {
        return this.tilt;
    }

    public double getElevationCompensation() {
        return this.elevationCompensation;
    }

    public ValidateDataUI_Input getInputPanel() {
        return this.inputPanel;
    }

    @Override
    public String getTitle() {
        return "Show antenna gain";
    }

    @Override
    public void buildUI(Scenario scenario, JPanel canvas, Panels panels) {
        this.panels = panels;
        this.split = new JSplitPane(1);
        this.split.add(panels.get("Test configuration").getPanel());
        this.split.add(this.plotPanel);
        canvas.setLayout(new BorderLayout());
        canvas.add((Component)this.split, "Center");
        canvas.repaint();
    }

    @Override
    public PanelDefinition[] panelDefinitions() {
        return new PanelDefinition[]{new PanelDefinition<ValidateDataUI_Input>("Test configuration", ValidateDataUI_Input.class)};
    }

    @PostProcessing(order=1, name="plot pattern")
    public void plotPattern(Scenario scenario, Results results, SimulationResult simulationResult) {
        this.inputPanel = (ValidateDataUI_Input)this.panels.get("Test configuration").getModel();
        this.horizontalPatternOrigin = new ArrayList();
        this.verticalPatternOrigin = new ArrayList();
        if (!(scenario.getVictim().getSystem().getReceiver().getAntennaGain().getModel() instanceof APmanufacturerDataInput)) {
            this.popupDialog("<HtMl>The VLR must use the antenna 'AntennaManufacturerData'. ");
        } else {
            LinkResult context;
            APmanufacturerDataInput inputAP = Factory.prototype(APmanufacturerDataInput.class);
            APmanufacturerDataInput antennaCopy = (APmanufacturerDataInput)scenario.getVictim().getSystem().getReceiver().getAntennaGain().getModel();
            if (this.inputPanel.mounted() == APmanufacturerDataInput.AntennaMounted.Horizontal) {
                this.horizontalPatternOrigin.addAll(antennaCopy.horizontalPattern().getPoints());
                this.verticalPatternOrigin.addAll(antennaCopy.verticalPattern().getPoints());
            } else {
                this.horizontalPatternOrigin.addAll(antennaCopy.verticalPattern().getPoints());
                this.verticalPatternOrigin.addAll(antennaCopy.horizontalPattern().getPoints());
            }
            Factory.when(inputAP.angleRange()).thenReturn(antennaCopy.angleRange());
            Factory.when(inputAP.mounted()).thenReturn(this.inputPanel.mounted());
            Factory.when(inputAP.horizontalPattern()).thenReturn(antennaCopy.horizontalPattern());
            Factory.when(inputAP.verticalPattern()).thenReturn(antennaCopy.verticalPattern());
            AntennaGain<APmanufacturerDataInput> antenna = Factory.antennaGainFactory().getByClass(AntennaManufacturerData.class, Factory.build(inputAP), this.inputPanel.peakGain());
            this.offsetAzimuth = Mathematics.convertAngleToConfineToHorizontalDefinedRange(this.inputPanel.azimuth().trial());
            this.offsetElevation = this.convertAngleToConfineToVerticalDefinedRange(this.inputPanel.elevation().trial());
            this.tilt = this.convertAngleToConfineToVerticalDefinedRange(this.inputPanel.tilt().trial());
            this.elevationCompensation = this.convertAngleToConfineToVerticalDefinedRange(this.inputPanel.elevationCompensation().trial());
            this.angles = new ArrayList();
            this.values = new ArrayList();
            this.valuesHorizontalVertical = new ArrayList();
            this.valuesHorizontalVerticalNew = new ArrayList();
            AntennaResult antennaResult = Factory.results().antennaResult();
            antennaResult.setTilt(this.tilt);
            antennaResult.setElevationCompensation(this.inputPanel.isIL() ? this.elevationCompensation : 0.0);
            LinkResult linkResult = context = this.inputPanel.isIL() ? new TestITUInterferenceLinkResult() : Factory.results().linkResult();
            if (this.inputPanel.plane() == ValidateDataUI_Input.Plane.Vertical) {
                antennaResult.setAzimuth(this.offsetAzimuth);
                for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                    this.angles.add(v);
                    antennaResult.setElevation(v);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.valuesHorizontalVertical.add(this.getGainDefault(context, antennaResult));
                    this.valuesHorizontalVerticalNew.add(this.getGainDefaultNew(context, antennaResult));
                }
            } else {
                antennaResult.setElevation(this.offsetElevation);
                for (double h = 0.0; h <= 360.0; h += this.inputPanel.gran()) {
                    this.angles.add(h);
                    antennaResult.setAzimuth(h);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.valuesHorizontalVertical.add(this.getGainDefault(context, antennaResult));
                    this.valuesHorizontalVerticalNew.add(this.getGainDefaultNew(context, antennaResult));
                }
            }
            this.generatePlot();
        }
    }

    private Double getGainDefaultNew(LinkResult context, AntennaResult antennaResult) {
        boolean compensationToConsider;
        double theta;
        double gain = 0.0;
        double phi = antennaResult.getAzimuth();
        double thetaH = theta = antennaResult.getElevation();
        double phiH = phi;
        double beta = -antennaResult.getTilt();
        double compensation = -antennaResult.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(antennaResult.getTilt(), 0.0, 1.0E-5) || compensationToConsider) {
            double tilt = beta;
            if (compensationToConsider) {
                tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
            }
            theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(beta) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            phi = antennaResult.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        }
        Function horizontalPattern = this.horizontalPatternOrigin.get(0).getX() < 0.0 ? Factory.functionFactory().discreteFunction(this.convertOriginTo360(this.horizontalPatternOrigin)) : Factory.functionFactory().discreteFunction(this.horizontalPatternOrigin);
        Function verticalPattern = this.verticalPatternOrigin.get(0).getX() >= 0.0 ? Factory.functionFactory().discreteFunction(this.convertOriginToSymmetric(this.verticalPatternOrigin)) : Factory.functionFactory().discreteFunction(this.verticalPatternOrigin);
        double horiGain = 0.0;
        double vertiGain = 0.0;
        if (phi > 90.0 && phi < 270.0) {
            theta = theta < 0.0 ? -90.0 : 90.0;
        }
        horiGain = horizontalPattern.evaluate(phi);
        vertiGain = verticalPattern.evaluate(theta);
        gain = this.inputPanel.peakGain() + horiGain + vertiGain;
        return gain;
    }

    private void generatePlotAnglesGenerated(ArrayList<Point2D> anglesDefault, ArrayList<Point2D> anglesGenerated) {
        this.plotPanel.removeAll();
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries horizontal = new XYSeries((Comparable)((Object)"horizontal"));
        XYSeries vertical = new XYSeries((Comparable)((Object)"vertical"));
        for (int i = 1; i < anglesDefault.size(); ++i) {
            horizontal.add(anglesDefault.get(i).getX(), anglesGenerated.get(i).getX());
            vertical.add(anglesDefault.get(i).getY(), anglesGenerated.get(i).getY());
        }
        dataset.addSeries(horizontal);
        dataset.addSeries(vertical);
        JFreeChart dRSSchart = ChartFactory.createXYLineChart("compare generated angles", "angle origin [deg]", "angle generated [deg]", dataset, PlotOrientation.VERTICAL, true, true, false);
        dRSSchart.fireChartChanged();
        XYPlot plot = (XYPlot)dRSSchart.getPlot();
        plot.getRenderer().setSeriesPaint(0, Color.BLUE);
        plot.getRenderer().setSeriesPaint(1, Color.GREEN);
        ChartPanel cp = new ChartPanel(dRSSchart);
        cp.repaint();
        this.plotPanel.add((Component)cp, "Center");
        this.plotPanel.revalidate();
        this.plotPanel.repaint();
        this.split.repaint();
    }

    private ArrayList<Point2D> getAnglesGenerated(ArrayList<Point2D> anglesDefault) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        AntennaResult antennaResult = Factory.results().antennaResult();
        if (this.getInputPanel().plane() == ValidateDataUI_Input.Plane.Vertical) {
            antennaResult.setAzimuth(this.getOffsetAzimuth());
            antennaResult.setTilt(this.getTilt());
            antennaResult.setElevationCompensation(this.getElevationCompensation());
            for (Point2D p : anglesDefault) {
                antennaResult.setElevation(p.getY());
                points.add(this.getAngle(antennaResult));
            }
        } else {
            antennaResult.setElevation(this.getOffsetElevation());
            antennaResult.setTilt(this.getTilt());
            antennaResult.setElevationCompensation(this.getElevationCompensation());
            for (Point2D p : anglesDefault) {
                antennaResult.setAzimuth(p.getX());
                points.add(this.getAngle(antennaResult));
            }
        }
        return points;
    }

    private Point2D getAngle(AntennaResult antennaResult) {
        Point2D p;
        double azimuth;
        double phiH = azimuth = Mathematics.convertAngleToConfineToHorizontalDefinedRange(antennaResult.getAzimuth());
        double thetaH = this.convertAngleToConfineToVerticalDefinedRange(antennaResult.getElevation());
        double beta = antennaResult.getTilt();
        double elevationCompensation = antennaResult.getElevationCompensation();
        boolean compensationToConsider = this.getInputPanel().isIL();
        if (!Mathematics.equals(beta, 0.0, 1.0E-5) || this.getInputPanel().isIL()) {
            double tilt = beta;
            if (compensationToConsider) {
                tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + elevationCompensation);
            }
            double theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            double phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(beta) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            if (azimuth > 180.0) {
                phi = 360.0 - phi;
            }
            if (phi > 180.0) {
                phi = -360.0 + phi;
            }
            if (azimuth > 90.0 && azimuth < 270.0) {
                theta = theta > 0.0 ? 180.0 - theta : -180.0 - theta;
            }
            p = new Point2D(phi, theta);
        } else {
            if (azimuth > 90.0 && azimuth < 270.0) {
                thetaH = thetaH > 0.0 ? 180.0 - thetaH : -180.0 - thetaH;
            }
            if (azimuth > 180.0) {
                phiH = -360.0 + phiH;
            }
            p = new Point2D(phiH, thetaH);
        }
        return p;
    }

    private double getGainDefault(LinkResult context, AntennaResult antennaResult) {
        boolean compensationToConsider;
        double theta;
        double gain = 0.0;
        double phi = antennaResult.getAzimuth();
        double thetaH = theta = antennaResult.getElevation();
        double phiH = phi;
        double beta = -antennaResult.getTilt();
        double compensation = -antennaResult.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(antennaResult.getTilt(), 0.0, 1.0E-5) || compensationToConsider) {
            double tilt = beta;
            if (compensationToConsider) {
                tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
            }
            theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(beta) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            phi = antennaResult.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        }
        Function horizontalPattern = this.horizontalPatternOrigin.get(0).getX() < 0.0 ? Factory.functionFactory().discreteFunction(this.convertOriginTo360(this.horizontalPatternOrigin)) : Factory.functionFactory().discreteFunction(this.horizontalPatternOrigin);
        Function verticalPattern = this.verticalPatternOrigin.get(0).getX() >= 0.0 ? Factory.functionFactory().discreteFunction(this.convertOriginToSymmetric(this.verticalPatternOrigin)) : Factory.functionFactory().discreteFunction(this.verticalPatternOrigin);
        double horiGain = 0.0;
        double vertiGain = 0.0;
        horiGain = horizontalPattern.evaluate(phi);
        if (Math.abs(horiGain - (vertiGain = verticalPattern.evaluate(theta))) < 3.0) {
            double G_horiz = Mathematics.dB2Linear(horiGain);
            double G_vert = Mathematics.dB2Linear(vertiGain);
            gain = Mathematics.dB2Linear(this.inputPanel.peakGain()) * Math.sqrt((G_horiz * G_horiz + G_vert * G_vert) / 2.0);
            gain = Mathematics.linear2dB(gain);
        } else {
            gain = this.inputPanel.peakGain() + Math.min(horiGain, vertiGain);
        }
        return gain;
    }

    /*
     * WARNING - void declaration
     */
    private void generatePlot() {
        this.plotPanel.removeAll();
        double peakGain = this.inputPanel.peakGain();
        XYSeriesCollection dataset = new XYSeriesCollection();
        String plane = this.inputPanel.plane() == ValidateDataUI_Input.Plane.Vertical ? "vertical" : "horizontal";
        XYSeries pattern = new XYSeries((Comparable)((Object)plane));
        XYSeries origin = new XYSeries((Comparable)((Object)"origin pattern"));
        XYSeries originDefault = new XYSeries((Comparable)((Object)"origin algorithm"));
        XYSeries originDefaultNew = new XYSeries((Comparable)((Object)"reverted algorithm"));
        XYSeries trialImport = new XYSeries((Comparable)((Object)"trial data import"));
        if (this.inputPanel.plane() != ValidateDataUI_Input.Plane.HorizontalSymmetric) {
            for (int i = 0; i < this.angles.size(); ++i) {
                pattern.add(this.angles.get(i), (Number)this.values.get(i));
                originDefault.add(this.angles.get(i), (Number)this.valuesHorizontalVertical.get(i));
                originDefaultNew.add(this.angles.get(i), (Number)this.valuesHorizontalVerticalNew.get(i));
            }
            if (this.inputPanel.plane() == ValidateDataUI_Input.Plane.Vertical) {
                if (this.verticalPatternOrigin.get(0).getX() >= 0.0) {
                    ArrayList<Point2D> originSymmetric = this.convertOriginToSymmetric(this.verticalPatternOrigin);
                    for (Point2D point2D : originSymmetric) {
                        origin.add(point2D.getX(), point2D.getY() + peakGain);
                    }
                } else {
                    for (Point2D point2D : this.verticalPatternOrigin) {
                        origin.add(point2D.getX(), point2D.getY() + peakGain);
                    }
                }
            } else if (this.horizontalPatternOrigin.get(0).getX() < 0.0) {
                ArrayList<Point2D> origin360 = this.convertOriginTo360(this.horizontalPatternOrigin);
                for (Point2D point2D : origin360) {
                    origin.add(point2D.getX(), point2D.getY() + peakGain);
                }
            }
        } else {
            void var11_19;
            ArrayList<Double> symmetrical = this.convertToSymmetrical(this.angles);
            boolean bl = false;
            while (var11_19 < symmetrical.size()) {
                pattern.add(symmetrical.get((int)var11_19), (Number)this.values.get((int)var11_19));
                originDefault.add(symmetrical.get((int)var11_19), (Number)this.valuesHorizontalVertical.get((int)var11_19));
                originDefaultNew.add(symmetrical.get((int)var11_19), (Number)this.valuesHorizontalVerticalNew.get((int)var11_19));
                ++var11_19;
            }
            if (this.horizontalPatternOrigin.get(0).getX() >= 0.0) {
                ArrayList<Point2D> arrayList = this.convertOriginToSymmetric(this.horizontalPatternOrigin);
                for (Point2D p2 : arrayList) {
                    origin.add(p2.getX(), p2.getY() + peakGain);
                }
            } else {
                for (Point2D point2D : this.horizontalPatternOrigin) {
                    origin.add(point2D.getX(), point2D.getY() + peakGain);
                }
            }
        }
        dataset.addSeries(pattern);
        dataset.addSeries(origin);
        JFreeChart dRSSchart = ChartFactory.createXYLineChart("AntennaManufacturerData", "off axis [degrees]", "gain [dBi]", dataset, PlotOrientation.VERTICAL, true, true, false);
        dRSSchart.fireChartChanged();
        XYPlot xYPlot = (XYPlot)dRSSchart.getPlot();
        xYPlot.getRenderer().setSeriesPaint(0, Color.BLUE);
        xYPlot.getRenderer().setSeriesPaint(1, Color.GREEN);
        ChartPanel chartPanel = new ChartPanel(dRSSchart);
        chartPanel.repaint();
        this.plotPanel.add((Component)chartPanel, "Center");
        this.plotPanel.revalidate();
        this.plotPanel.repaint();
        this.split.repaint();
    }

    private ArrayList<Point2D> convertOriginTo360(ArrayList<Point2D> patternOrigin) {
        ArrayList<Point2D> res = new ArrayList<Point2D>();
        for (Point2D p : patternOrigin) {
            if (p.getX() >= 0.0 && !Mathematics.equals(p.getX(), 180.0, 1.0E-5)) {
                res.add(p);
                continue;
            }
            if (!(p.getX() < 0.0)) continue;
            res.add(new Point2D(360.0 + p.getX(), p.getY()));
        }
        Collections.sort(res, Point2D.X_COMPARATOR);
        res.add(new Point2D(360.0, ((Point2D)res.get(0)).getY()));
        return res;
    }

    private ArrayList<Point2D> convertOriginToSymmetric(ArrayList<Point2D> patternOrigin) {
        ArrayList<Point2D> res = new ArrayList<Point2D>();
        for (Point2D p : patternOrigin) {
            if (Mathematics.equals(p.getX(), 180.0, 1.0E-5)) {
                res.add(new Point2D(180.0, p.getY()));
                continue;
            }
            if (p.getX() > 180.0) {
                res.add(new Point2D(-360.0 + p.getX(), p.getY()));
                continue;
            }
            res.add(p);
        }
        return res;
    }

    private ArrayList<Double> convertToSymmetrical(ArrayList<Double> simulated) {
        ArrayList<Double> sym = new ArrayList<Double>();
        for (Double aSimulated : simulated) {
            double a = aSimulated;
            if (Mathematics.equals(a, 180.0, 1.0E-5)) {
                a = -180.0;
            } else if (a > 180.0) {
                a = -360.0 + a;
            }
            sym.add(a);
        }
        return sym;
    }

    private double convertAngleToConfineToVerticalDefinedRange(double angle) {
        if (angle < -90.0) {
            return -(angle += 180.0);
        }
        if (angle > 90.0) {
            return -(angle -= 180.0);
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    private void popupDialog(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Test AP for manufacturer data", 1);
    }

    private JPanel getInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.infoPanel.setLayout(gridBagLayout);
        JLabel lblHorizontalOffset = new JLabel("horizontal offset  ");
        GridBagConstraints gbc_lblHorizontalOffset = new GridBagConstraints();
        gbc_lblHorizontalOffset.anchor = 13;
        gbc_lblHorizontalOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblHorizontalOffset.gridx = 0;
        gbc_lblHorizontalOffset.gridy = 0;
        this.infoPanel.add((Component)lblHorizontalOffset, gbc_lblHorizontalOffset);
        JLabel lblDegree = new JLabel(" degree");
        GridBagConstraints gbc_lblDegree = new GridBagConstraints();
        gbc_lblDegree.insets = new Insets(0, 0, 5, 5);
        gbc_lblDegree.gridx = 3;
        gbc_lblDegree.gridy = 0;
        this.infoPanel.add((Component)lblDegree, gbc_lblDegree);
        JLabel lblVerticalOffset = new JLabel("vertical offset  ");
        GridBagConstraints gbc_lblVerticalOffset = new GridBagConstraints();
        gbc_lblVerticalOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblVerticalOffset.anchor = 13;
        gbc_lblVerticalOffset.gridx = 0;
        gbc_lblVerticalOffset.gridy = 1;
        this.infoPanel.add((Component)lblVerticalOffset, gbc_lblVerticalOffset);
        JLabel lblDegree_1 = new JLabel(" degree");
        GridBagConstraints gbc_lblDegree_1 = new GridBagConstraints();
        gbc_lblDegree_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblDegree_1.gridx = 3;
        gbc_lblDegree_1.gridy = 1;
        this.infoPanel.add((Component)lblDegree_1, gbc_lblDegree_1);
        JLabel lblElevationCompensation = new JLabel(" elevation compensation  ");
        GridBagConstraints gbc_lblElevationCompensation = new GridBagConstraints();
        gbc_lblElevationCompensation.insets = new Insets(0, 0, 0, 5);
        gbc_lblElevationCompensation.anchor = 13;
        gbc_lblElevationCompensation.gridx = 0;
        gbc_lblElevationCompensation.gridy = 2;
        this.infoPanel.add((Component)lblElevationCompensation, gbc_lblElevationCompensation);
        JLabel lblDegree_2 = new JLabel(" degree");
        GridBagConstraints gbc_lblDegree_2 = new GridBagConstraints();
        gbc_lblDegree_2.insets = new Insets(0, 0, 0, 5);
        gbc_lblDegree_2.gridx = 3;
        gbc_lblDegree_2.gridy = 2;
        this.infoPanel.add((Component)lblDegree_2, gbc_lblDegree_2);
        return this.infoPanel;
    }
}

