/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing.demo11;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.eventprocessing.demo11.ReportAntennaGainsInput;
import org.seamcat.eventprocessing.demo11.ReportAntennaGainsUI;
import org.seamcat.eventprocessing.demo11.ReportAntennaGainsVectorDefinitions;
import org.seamcat.model.Scenario;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.eventprocessing.PostProcessingTab;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.presentation.WarningColors;

public class DempEPP_11_ReportAntennaGains
implements EventProcessingPlugin<ReportAntennaGainsInput>,
PostProcessingTab {
    private boolean checkPassed;
    private boolean enablePlot;

    @Override
    public void evaluate(Scenario scenario, EventResult result, ReportAntennaGainsInput input, Collector collector) {
        if (this.checkPassed) {
            List<InterferenceLinkResult> linkResults;
            if (input.sysLinks()) {
                if (input.vs()) {
                    int countVictims = 0;
                    for (Victim vr : result.getVictimResult().getVictims()) {
                        String name = scenario.getVictim().getName();
                        name = String.format("" + name + "-%d", countVictims++);
                        collector.add(ReportAntennaGainsVectorDefinitions.gainVLT_VLR(name), vr.getLinkResult().txAntenna().getGain());
                        collector.add(ReportAntennaGainsVectorDefinitions.gainVLR_VLT(name), vr.getLinkResult().rxAntenna().getGain());
                        collector.add(ReportAntennaGainsVectorDefinitions.angleVLR_VLT(name), vr.getLinkResult().rxAntenna().getAzimuth());
                        collector.add(ReportAntennaGainsVectorDefinitions.angleVLT_VLR(name), vr.getLinkResult().txAntenna().getAzimuth());
                    }
                }
                if (input.is()) {
                    int countILTs = 0;
                    for (InterferenceLink link : scenario.getInterferenceLinks()) {
                        linkResults = result.getInterferenceLinkResult(link);
                        String name = link.getInterferer().getName();
                        name = String.format("" + name + "-%d", countILTs++);
                        for (int i = 0; i < linkResults.size(); ++i) {
                            collector.add(ReportAntennaGainsVectorDefinitions.gainILT_ILR(name, i), linkResults.get(i).getInterferingSystemLink().txAntenna().getGain());
                            collector.add(ReportAntennaGainsVectorDefinitions.angleILT_ILR(name, i), linkResults.get(i).getInterferingSystemLink().txAntenna().getAzimuth());
                            collector.add(ReportAntennaGainsVectorDefinitions.gainILR_ILT(name, i), linkResults.get(i).getInterferingSystemLink().rxAntenna().getGain());
                            collector.add(ReportAntennaGainsVectorDefinitions.angleILR_ILT(name, i), linkResults.get(i).getInterferingSystemLink().rxAntenna().getAzimuth());
                        }
                    }
                }
            }
            if (input.iLinks()) {
                int countLinks = 0;
                for (InterferenceLink link : scenario.getInterferenceLinks()) {
                    ++countLinks;
                    linkResults = result.getInterferenceLinkResult(link);
                    for (int i = 0; i < linkResults.size(); ++i) {
                        String name = link.getInterferer().getName();
                        name = String.format("" + name + "_%d", countLinks);
                        InterferenceLinkResult subLink = linkResults.get(i);
                        collector.add(ReportAntennaGainsVectorDefinitions.gainILT_VLR(name, i), subLink.txAntenna().getGain());
                        collector.add(ReportAntennaGainsVectorDefinitions.angleILT_VLR(name, i), subLink.txAntenna().getAzimuth());
                        collector.add(ReportAntennaGainsVectorDefinitions.gainVLR_ILT(name, i), subLink.rxAntenna().getGain());
                        collector.add(ReportAntennaGainsVectorDefinitions.angleVLR_ILT(name, i), subLink.rxAntenna().getAzimuth());
                    }
                }
            }
        }
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, ReportAntennaGainsInput input, Validator validator) {
        this.enablePlot = input.doPlot();
        String msg = "";
        if (!input.sysLinks() && !input.iLinks()) {
            msg = "You should enable at least one of 'System links' and 'Interference links'.";
        }
        if (input.sysLinks() && !input.vs() && !input.is()) {
            msg = "You should enable at least one of 'Victim system' and 'Interfering system'.";
        }
        if (!msg.isEmpty()) {
            this.checkPassed = false;
            msg = msg + "<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">Ignoring this will prevent the EPP from generating any result.</p>";
            validator.error(msg);
        } else {
            this.checkPassed = true;
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 11: Report Antenna Gains", "creates vectors of the simulated antenna gains.<br>Note that in particular cellular interferers may allocate plenty of memory.");
    }

    @Override
    public List<Class<? extends PostProcessingUI>> tabs() {
        ArrayList<Class<? extends PostProcessingUI>> tabs = new ArrayList<Class<? extends PostProcessingUI>>();
        if (this.checkPassed && this.enablePlot) {
            tabs.add(ReportAntennaGainsUI.class);
        }
        return tabs;
    }
}

