/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing.demo11;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PolarAxisLocation;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.eventprocessing.demo11.ReportAntennaGainsInput;
import org.seamcat.eventprocessing.demo11.ReportAntennaGainsVectorDefinitions;
import org.seamcat.eventprocessing.demo11.ReportGainsConfig;
import org.seamcat.model.Scenario;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.eventprocessing.Panels;
import org.seamcat.model.plugin.eventprocessing.PostProcessing;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;

public class ReportAntennaGainsUI
implements PostProcessingUI {
    private Panels panels;
    private final JPanel panelPlot = new JPanel();
    private final ReportGainsConfig gainsConfig = new ReportGainsConfig();
    private boolean initPassed = false;
    private Map<String, VectorResultType> availableGains;
    private Map<String, VectorResultType> availableAngles;

    @Override
    public String getTitle() {
        return "Show gain versus angles";
    }

    @Override
    public void buildUI(Scenario scenario, JPanel canvas, Panels panels) {
        this.panels = panels;
        canvas.setLayout(new BorderLayout());
        canvas.add((Component)this.gainsConfig, "West");
        canvas.add((Component)this.panelPlot, "Center");
    }

    @PostProcessing(order=1, name="Generate plot")
    public void generatePlot(Scenario scenario, Results results, ReportAntennaGainsInput input) {
        if (!this.initPassed) {
            this.initConfig(scenario, results, input);
            XYSeriesCollection seriesResult = this.loadVectorsForPlot(1);
            if (seriesResult != null) {
                this.createPlot(seriesResult, 1);
            }
        } else {
            int selected = this.gainsConfig.getComboBoxSelectLink().getSelectedIndex();
            XYSeriesCollection seriesResult = this.loadVectorsForPlot(selected);
            if (seriesResult != null) {
                this.createPlot(seriesResult, selected);
            }
        }
    }

    private void createPlot(XYSeriesCollection xySeriesCollection, int selected) {
        this.panelPlot.removeAll();
        JFreeChart chart = this.createChart(xySeriesCollection, selected);
        ChartPanel panel = new ChartPanel(chart);
        panel.setPreferredSize(new Dimension(800, 800));
        panel.setMouseZoomable(false);
        panel.setDisplayToolTips(true);
        this.panelPlot.add((Component)panel, "Center");
        this.panelPlot.revalidate();
        this.panelPlot.repaint();
    }

    private JFreeChart createChart(XYSeriesCollection xySeriesCollection, int selected) {
        double min;
        double max = this.getMax(xySeriesCollection);
        XYSeries angleToMax = this.getAngleForMax(xySeriesCollection, max, min = this.getMin(xySeriesCollection));
        if (angleToMax != null) {
            xySeriesCollection.addSeries(angleToMax);
        }
        NumberAxis radiusAxis = new NumberAxis();
        radiusAxis.setTickLabelsVisible(false);
        DefaultPolarItemRenderer renderer = new DefaultPolarItemRenderer();
        renderer.setShapesVisible(true);
        PolarPlot plot = new PolarPlot(xySeriesCollection, radiusAxis, renderer);
        plot.setCounterClockwise(true);
        plot.setAxisLocation(PolarAxisLocation.EAST_BELOW);
        plot.setAngleOffset(0.0);
        plot.setBackgroundPaint(new Color(0xF0F0F0));
        plot.setRadiusGridlinePaint(Color.gray);
        Locale formatLocate = new Locale("us");
        plot.addCornerTextItem(String.format(formatLocate, "max: %2.1f dBi \tmin: %2.1f dBi", max, min));
        String title = (String)this.gainsConfig.getComboBoxSelectLink().getItemAt(selected);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        chart.setBackgroundPaint(new Color(0xF0F0F0));
        return chart;
    }

    private XYSeries getAngleForMax(XYSeriesCollection xySeriesCollection, double max, double min) {
        XYSeries angleToMax = new XYSeries((Comparable)((Object)"max gain azimuth"));
        XYSeries gains = xySeriesCollection.getSeries(0);
        double angle = 0.0;
        for (int i = 0; i < gains.getItemCount(); ++i) {
            if (!(gains.getY(i).doubleValue() >= max)) continue;
            angle = gains.getX(i).doubleValue();
        }
        double step = (max - min) / 20.0;
        if (Mathematics.equals(step, 0.0, 0.001)) {
            return null;
        }
        for (double d = min; d <= max; d += step) {
            angleToMax.add(angle, d);
        }
        return angleToMax;
    }

    private double getMax(XYSeriesCollection res) {
        double max = -1000.0;
        Object o = res.getSeries().get(0);
        if (o instanceof XYSeries) {
            return ((XYSeries)o).getMaxY();
        }
        return max;
    }

    private double getMin(XYSeriesCollection res) {
        double min = -1000.0;
        Object o = res.getSeries().get(0);
        if (o instanceof XYSeries) {
            return ((XYSeries)o).getMinY();
        }
        return min;
    }

    private void initConfig(Scenario scenario, Results results, ReportAntennaGainsInput input) {
        this.gainsConfig.getComboBoxSelectLink().removeAllItems();
        this.availableGains = new HashMap<String, VectorResultType>();
        this.availableAngles = new HashMap<String, VectorResultType>();
        if (input.vs()) {
            VectorResultType anglesVLR = results.findVector(ReportAntennaGainsVectorDefinitions.angleVLR_VLT());
            VectorResultType gainVLR = results.findVector(ReportAntennaGainsVectorDefinitions.gainVLR_VLT);
            if (gainVLR != null) {
                this.availableGains.put(gainVLR.getName(), gainVLR);
                this.availableAngles.put(gainVLR.getName(), anglesVLR);
            } else {
                for (int i = 0; i <= 9; ++i) {
                    Object name = scenario.getVictim().getName();
                    name = String.format("" + (String)name + "-%d", i);
                    for (VectorResultType res : results.getVectorResultTypes()) {
                        if (!res.getName().contains((CharSequence)name)) continue;
                        if (res.def().group().contains("Angles")) {
                            this.availableAngles.put(res.getName(), res);
                            continue;
                        }
                        this.availableGains.put(res.getName(), res);
                    }
                }
            }
        }
        if (input.is()) {
            int countILTs = 0;
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                String name = link.getInterferer().getName();
                name = String.format("" + name + "-%d", countILTs++);
                for (VectorResultType res : results.getVectorResultTypes()) {
                    if (!res.getName().contains(name)) continue;
                    if (res.def().group().contains("Angles")) {
                        this.availableAngles.put(res.getName(), res);
                        continue;
                    }
                    this.availableGains.put(res.getName(), res);
                }
            }
        }
        if (input.iLinks()) {
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                String name = link.getInterferer().getName();
                for (VectorResultType res : results.getVectorResultTypes()) {
                    if (!res.getName().contains(name)) continue;
                    if (res.def().group().contains("Angles")) {
                        this.availableAngles.put(res.getName(), res);
                        continue;
                    }
                    this.availableGains.put(res.getName(), res);
                }
            }
        }
        if (this.availableAngles.size() > 0) {
            Object[] keySet = this.availableAngles.keySet().toArray();
            Arrays.sort(keySet);
            this.gainsConfig.getComboBoxSelectLink().addItem("Select item");
            for (Object aKeySet : keySet) {
                String key = (String)aKeySet;
                this.gainsConfig.getComboBoxSelectLink().addItem(key);
            }
            if (this.gainsConfig.getComboBoxSelectLink().getModel().getSize() > 1) {
                this.gainsConfig.getComboBoxSelectLink().setSelectedIndex(1);
                this.setInitPassed(true);
            }
        } else {
            this.setInitPassed(false);
        }
    }

    private XYSeriesCollection loadVectorsForPlot(int selectedIndex) {
        if (selectedIndex == 0) {
            this.panelPlot.removeAll();
            this.panelPlot.repaint();
            this.popupDialog("Please select a valid item");
            return null;
        }
        XYSeriesCollection result = new XYSeriesCollection();
        XYSeries plotPattern = new XYSeries((Comparable)((Object)"gain versus azimuth"));
        String key = (String)this.gainsConfig.getComboBoxSelectLink().getItemAt(selectedIndex);
        double[] gain = this.availableGains.get(key).getValue().asArray();
        double[] angle = this.availableAngles.get(key).getValue().asArray();
        for (int i = 0; i < gain.length; ++i) {
            plotPattern.add(angle[i], gain[i]);
        }
        result.addSeries(plotPattern);
        return result;
    }

    private void popupDialog(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Inconsistent settings", 1);
    }

    @Override
    public PanelDefinition[] panelDefinitions() {
        return new PanelDefinition[0];
    }

    private void setInitPassed(boolean initPassed) {
        this.initPassed = initPassed;
    }

    private boolean isInitPassed() {
        return this.initPassed;
    }
}

