/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing.im3broadband;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.eventprocessing.im3broadband.EPPforIM3_PPUI;
import org.seamcat.eventprocessing.im3broadband.IM3ValueDefinitions;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.eventprocessing.PostProcessingTab;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.presentation.WarningColors;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class EPPforIM3
implements EventProcessingPlugin<Input>,
PostProcessingTab {
    private boolean checkPassed;

    @Override
    public void evaluate(Scenario scenario, EventResult eventResult, Input input, Collector collector) {
        if (this.isCheckPassed()) {
            BlockingMask blockingMaskOrigin = this.getBlockingMaskOrigin(scenario);
            double noiseFloor = ((GenericSystemPlugin)scenario.getVictim().getSystemPlugin()).getNoiseFloor().trial();
            double dRSS = eventResult.getVictimResult().get(IM3ValueDefinitions.getDefinitionSingleDRSS());
            collector.add(IM3ValueDefinitions.getDefinitionDRSS(), dRSS);
            collector.add(IM3ValueDefinitions.getDefinitionNoiseFloor(), noiseFloor);
            collector.add(IM3ValueDefinitions.getDefinitionScatterVLR(), eventResult.getVictimResult().getVictims().get(0).getLinkResult().rxAntenna().getPosition());
            double sumUnw = 0.0;
            double sumBlock = 0.0;
            double sumIM3 = 0.0;
            double blockResponse = 0.0;
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                String key = link.getInterferer().getName();
                List<InterferenceLinkResult> linkResults = eventResult.getInterferenceLinkResult(link);
                blockResponse = linkResults.get(0).getBlockingAttenuation();
                for (InterferenceLinkResult subLinkResult : linkResults) {
                    collector.add(IM3ValueDefinitions.getDefinitionScatterILT(key), subLinkResult.txAntenna().getPosition());
                    sumUnw += Mathematics.dB2Linear(subLinkResult.getRiRSSUnwantedValue());
                    if (this.isAdjacent(scenario, subLinkResult)) {
                        sumBlock += Mathematics.dB2Linear(subLinkResult.getRiRSSBlockingValue());
                        sumIM3 += Mathematics.dB2Linear(this.getIM3product(link, subLinkResult, input, blockingMaskOrigin, eventResult.getEventNumber()));
                        continue;
                    }
                    sumBlock += 1.0E-100 / (double)linkResults.size();
                    sumIM3 += 1.0E-100 / (double)linkResults.size();
                }
            }
            collector.add(IM3ValueDefinitions.getDefinitionUnwanted("summation"), Mathematics.linear2dB(sumUnw));
            collector.add(IM3ValueDefinitions.getDefinitionBlocking("summation"), Mathematics.linear2dB(sumBlock));
            collector.add(IM3ValueDefinitions.getDefinitionIM3("summation"), Mathematics.linear2dB(sumIM3));
            collector.add(IM3ValueDefinitions.getDefinitionCompareIM(), new Point2D(Mathematics.linear2dB(sumBlock) + blockResponse, Mathematics.linear2dB(sumIM3)));
            if (eventResult.getEventNumber() == 0) {
                if (input.rejection().isConstant()) {
                    double rej = input.rejection().getConstant();
                    if (input.mode() == Input.IntermodulationMode.ABSOLUTE) {
                        rej -= ((GenericSystemPlugin)scenario.getVictim().getSystemPlugin()).getSensitivity();
                    }
                    collector.add(Factory.results().single("intermodulation rejection applied", "dB"), rej);
                } else {
                    Function rej;
                    if (input.mode() == Input.IntermodulationMode.ABSOLUTE) {
                        double offset = ((GenericSystemPlugin)scenario.getVictim().getSystemPlugin()).getSensitivity() + ((GenericSystemPlugin)scenario.getVictim().getSystemPlugin()).getNoiseAugmentation() - ((GenericSystemPlugin)scenario.getVictim().getSystemPlugin()).getInterferenceToNoiseRatio();
                        rej = input.rejection().offset(-offset);
                    } else {
                        rej = input.rejection();
                    }
                    for (Point2D p : rej.getPoints()) {
                        collector.add(Factory.results().multi("intermodulation rejection applied", "offset [MHz]", "rejection [dB"), p);
                    }
                }
            }
        } else if (eventResult.getEventNumber() == 0) {
            collector.add(Factory.results().single("consistency check failed", "no valid results"), 0);
        }
    }

    private boolean isAdjacent(Scenario scenario, InterferenceLinkResult subLinkResult) {
        double fILT;
        double bwVLR = scenario.getVictim().getSystem().getReceiver().getBandwidth();
        double bwILT = scenario.getInterferenceLinks().get(subLinkResult.getInterferer().getInterferenceLinkIndex()).getInterferer().getSystem().getTransmitter().getBandwidth();
        double fVLR = subLinkResult.getVictim().getLinkResult().getFrequency();
        return !Mathematics.equals(fVLR, fILT = subLinkResult.getFrequency(), (bwILT + bwVLR) / 2.0);
    }

    private BlockingMask getBlockingMaskOrigin(Scenario scenario) {
        GenericSystemPlugin rs = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
        double offset = 0.0;
        if (rs.getBlockingAttenuationMode() == GenericSystemPlugin.BlockingAttenuationMode.PROTECTION_RATIO) {
            offset = rs.getExtendedProtectionRatio() + rs.getNoiseAugmentation() - rs.getInterferenceToNoiseRatio();
        } else if (rs.getBlockingAttenuationMode() == GenericSystemPlugin.BlockingAttenuationMode.MODE_SENSITIVITY) {
            offset = rs.getExtendedProtectionRatio() - rs.getSensitivity() - rs.getInterferenceToNoiseRatio();
        }
        Function temp = scenario.getVictim().getSystem().getReceiver().getBlockingMask().getFunction().offset(offset);
        if (temp.isConstant()) {
            return Factory.functionFactory().blockingMask(temp.getConstant());
        }
        List<Point2D> points = temp.getPoints();
        return Factory.functionFactory().blockingMask(points);
    }

    private double getIM3product(InterferenceLink link, InterferenceLinkResult subLinkResult, Input input, BlockingMask blockingMask, int eventNumber) {
        double bwVLR = link.getVictim().getSystem().getReceiver().getBandwidth();
        double bwILT = link.getInterferer().getSystem().getTransmitter().getBandwidth();
        double sens = ((GenericSystemPlugin)link.getVictim().getSystemPlugin()).getSensitivity();
        double nin = ((GenericSystemPlugin)link.getVictim().getSystemPlugin()).getNoiseAugmentation();
        double in = ((GenericSystemPlugin)link.getVictim().getSystemPlugin()).getInterferenceToNoiseRatio();
        double frequencyVLR = subLinkResult.getVictimSystemLink().getFrequency();
        double frequencyILT = subLinkResult.getInterferingSystemLink().getFrequency() - bwILT / 2.0;
        double blockingResponseReference = subLinkResult.getBlockingAttenuation();
        double powerForIM3 = subLinkResult.getRiRSSBlockingValue() + blockingResponseReference;
        double stepSize = Math.min(Math.min(bwVLR, bwILT / 3.0), 0.02);
        double iRSS = powerForIM3 + 10.0 * Math.log10(stepSize / bwILT);
        double sum = 0.0;
        double log10Of3 = 10.0 * Math.log10(3.0);
        double gainMargin = input.useCompression().isRelevant() ? input.useCompression().getValue() : 13.0;
        Bounds vlrFrequencyRange = new Bounds(frequencyVLR - bwVLR / 2.0, frequencyVLR + bwVLR / 2.0, true);
        boolean countProductsIM3 = false;
        for (double d = stepSize / 2.0; d <= bwILT; d += stepSize) {
            for (double e = stepSize / 2.0; e <= bwILT; e += stepSize) {
                double f0;
                double fx = 0.0;
                if (Mathematics.equals(d, e, 0.001)) continue;
                double f1 = frequencyILT + d;
                double f2 = frequencyILT + e;
                if (f1 < f2 && f1 < vlrFrequencyRange.getMin() || f1 > f2 && f1 > vlrFrequencyRange.getMax()) {
                    fx = f1;
                    f1 = f2;
                    f2 = fx;
                }
                if (!vlrFrequencyRange.contains(f0 = 2.0 * f1 - f2)) continue;
                double rejection1 = input.rejection().evaluate(f1 - frequencyVLR);
                double rejection2 = input.rejection().evaluate(f2 - frequencyVLR);
                if (input.mode() == Input.IntermodulationMode.ABSOLUTE) {
                    rejection1 -= sens + nin - in;
                    rejection2 -= sens + nin - in;
                }
                double bc1 = blockingResponseReference - blockingMask.getFunction().evaluate(f1 - frequencyVLR);
                double bc2 = blockingResponseReference - blockingMask.getFunction().evaluate(f2 - frequencyVLR);
                double imp = 2.0 * (iRSS - bc1) + (iRSS - bc2) - 2.0 * rejection1 - rejection2 - 3.0 * sens - 3.0 * (nin - in);
                if ((imp -= log10Of3) + gainMargin > iRSS) {
                    sum += Mathematics.dB2Linear(iRSS - gainMargin);
                    continue;
                }
                sum += Mathematics.dB2Linear(imp);
            }
        }
        return Mathematics.linear2dB(sum);
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
        this.setCheckPassed(true);
        Scenario scenario = context.getScenario();
        if (!(scenario.getVictim().getSystemPlugin() instanceof GenericSystemPlugin)) {
            String msg = "<HtMl>Cellular systems are not allowed as victim. " + IM3ValueDefinitions.consistencyWarning();
            this.setCheckPassed(false);
            validator.error(msg);
            return;
        }
        double bwVLR = scenario.getVictim().getSystem().getReceiver().getBandwidth();
        int index = 0;
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            ++index;
            if (!(link.getInterferer().getSystem().getTransmitter().getBandwidth() <= bwVLR)) continue;
            this.setCheckPassed(false);
            validator.error("<HtMl>Bandwidth of the transmitter of interfering link #" + index + " must be larger than the victim's bandwidth." + IM3ValueDefinitions.consistencyWarning());
        }
        if (input.rejection().evaluate(input.rejection().getBounds().getMax()) <= 0.0) {
            if (input.mode() == Input.IntermodulationMode.RELATIVE) {
                validator.error("Intermodulation rejection mode should be set to 'absolute'" + IM3ValueDefinitions.consistencyWarning());
                this.setCheckPassed(false);
            }
        } else if (input.mode() == Input.IntermodulationMode.ABSOLUTE) {
            validator.error("Intermodulation rejection mode should be set to 'relative'" + IM3ValueDefinitions.consistencyWarning());
            this.setCheckPassed(false);
        }
        if (input.useCompression().isRelevant() && input.useCompression().getValue() < 13.0) {
            validator.error("Value for 'gain compression margin' must be &ge 13 dB" + IM3ValueDefinitions.consistencyWarning());
            this.setCheckPassed(false);
        }
    }

    @Override
    public List<Class<? extends PostProcessingUI>> tabs() {
        ArrayList<Class<? extends PostProcessingUI>> tabs = new ArrayList<Class<? extends PostProcessingUI>>();
        if (this.isCheckPassed()) {
            tabs.add(EPPforIM3_PPUI.class);
        }
        return tabs;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Intermodulation (Broadband) EPP", "<HtMl>calculates IM3 products due to broadband interferers.<br><em " + (Object)((Object)WarningColors.MASK_WARNING) + "> This EPP is basically applicable only to cellular interferers of which the bandwidths are larger than the bandwidth of the generic VLR.</em>");
    }

    private boolean isCheckPassed() {
        return this.checkPassed;
    }

    private void setCheckPassed(boolean checkPassed) {
        this.checkPassed = checkPassed;
    }

    public static interface Input {
        public static final OptionalValue<Double> useCompression = Factory.results().optional(false, 13.0);
        public static final IntermodulationMode mode = IntermodulationMode.ABSOLUTE;
        public static final Function rejection = Factory.functionFactory().constantFunction(-47.0);

        @Config(order=2, name="Intermodulation gain compression margin", unit="dB", toolTip="<html>User defined limit similar to a 'gain compression'. <br>The default value of 13 dB is applied if not user specified, <br>values less than 13 dB are not applicable.</html>")
        public OptionalValue<Double> useCompression();

        @Config(order=6, name="Intermodulation rejection mode")
        public IntermodulationMode mode();

        @Config(order=9, name="Value for Intermodulation rejection")
        public Function rejection();

        public static enum IntermodulationMode {
            RELATIVE("relative in dB"),
            ABSOLUTE("absolute power in dBm");

            private final String mode;

            private IntermodulationMode(String mode) {
                this.mode = mode;
            }

            public String getMode() {
                return this.mode;
            }

            public String toString() {
                return this.mode;
            }
        }
    }
}

