/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing.im3broadband;

import org.seamcat.model.factory.Factory;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.VectorDef;

public abstract class IM3ValueDefinitions {
    public static VectorDef getDefinitionUnwanted(String key) {
        return Factory.results().group("collected vectors", key + "_iRSSunw", "dBm");
    }

    public static VectorDef getDefinitionIM3(String key) {
        return Factory.results().group("collected vectors", key + "_IM3", "dBm");
    }

    public static VectorDef getDefinitionBlocking(String key) {
        return Factory.results().group("collected vectors", key + "_iRSSblock", "dBm");
    }

    public static VectorDef getDefinitionCI(String key) {
        return Factory.results().group("collected vectors", key + "_C/I", "dB");
    }

    public static VectorDef getDefinitionCNI(String key) {
        return Factory.results().group("collected vectors", key + "_C/(N+I)", "dB");
    }

    public static VectorDef getDefinitionIN(String key) {
        return Factory.results().group("collected vectors", key + "_I/N", "dB");
    }

    public static VectorDef getDefinitionNIN(String key) {
        return Factory.results().group("collected vectors", key + "_(N+I)/N", "dB");
    }

    public static VectorDef getDefinitionBlockingAttenuation(String key) {
        return Factory.results().group("collected vectors", key + "_blockingResponse", "dB");
    }

    public static VectorDef getDefinitionDRSS() {
        return Factory.results().group("collected vectors", "dRSS", "dBm");
    }

    public static VectorDef getDefinitionNoiseFloor() {
        return Factory.results().group("collected vectors", "noise floor", "dBm");
    }

    public static VectorDef getDefinitionSingleDRSS() {
        return Factory.results().value("dRSS", "dBm");
    }

    public static VectorDef getDefinitionFrequencyVLR() {
        return Factory.results().value("frequency VLR", "MHz");
    }

    public static VectorDef getDefinitionFrequencyILT(String key) {
        return Factory.results().group("collected vectors", key + "_frequency", "MHz");
    }

    public static MultiValueDef getDefinitionScatterVLR() {
        return Factory.results().multiGroup("collected scatter", "Position VLR", "x [km]", "y [km]");
    }

    public static MultiValueDef getDefinitionCompareIM() {
        return Factory.results().multiGroup("collected scatter", "iRSS vs IM3", "fundamental [dBm]", "IM3 [dBm]");
    }

    public static MultiValueDef getDefinitionScatterILT(String key) {
        return Factory.results().multiGroup("collected scatter", key + "_Position ILT", "x [km]", "y [km]");
    }

    public static String consistencyWarning() {
        return "<p style='color: maroon; font-weight: bold;'>Ignoring this warning will prevent the Post Processing UI from being displayed.</p>";
    }

    public static enum Criterion {
        CNI("C/(N+I)"),
        IN("I/N"),
        NIN("(N+I)/N"),
        CI("C/I");

        private final String criterion;

        private Criterion(String criterion) {
            this.criterion = criterion;
        }

        public String getCriterion() {
            return this.criterion;
        }

        public String toString() {
            return this.criterion;
        }
    }
}

