/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing.ituantennas;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.eventprocessing.ituantennas.TestITUInterferenceLinkResult;
import org.seamcat.eventprocessing.ituantennas.TestITUantennasUIinput;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.DataExporter;
import org.seamcat.model.functions.DataFile;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.Service;
import org.seamcat.model.plugin.antenna.ITU_R_F1245Input;
import org.seamcat.model.plugin.antenna.ITU_R_F1336_4_rec_2_Input;
import org.seamcat.model.plugin.antenna.ITU_R_F1336_4_rec_3_Input;
import org.seamcat.model.plugin.antenna.ITU_R_F699Input;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.eventprocessing.Panels;
import org.seamcat.model.plugin.eventprocessing.PostProcessing;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.AntennaGain;

public class TestITUantennasUI
implements PostProcessingUI {
    private JSplitPane split;
    private JPanel plotPanel = new JPanel(new BorderLayout());
    private JPanel infoPanel = new JPanel();
    private Panels panels;
    private JTextField fieldCompensation;
    private JTextField horOffset;
    private JTextField verOffset;
    private TestITUantennasUIinput inputPanel;
    private TestITUantennasUIinput.AntennaSelection selectedAntenna;
    private List<Double> angles;
    private List<Double> values;
    private DecimalFormat df = new DecimalFormat("##0.0");
    private double horizontalOffset;
    private double verticalOffset;
    private double elevationCompensation;
    @Service
    private DataExporter exporter;
    private JCheckBox chckbxExportPatternOnly;
    private final double EPSILON = 1.0E-4;

    @Override
    public String getTitle() {
        return "Test ITU antennas";
    }

    @Override
    public void buildUI(Scenario scenario, JPanel canvas, Panels panels) {
        this.panels = panels;
        this.split = new JSplitPane(1);
        this.split.add(panels.get("Test configuration").getPanel());
        this.split.add(this.plotPanel);
        canvas.setLayout(new BorderLayout());
        canvas.add((Component)this.getInfoPanel(), "North");
        canvas.add((Component)this.split, "Center");
        canvas.repaint();
    }

    @Override
    public PanelDefinition[] panelDefinitions() {
        return new PanelDefinition[]{new PanelDefinition<TestITUantennasUIinput>("Test configuration", TestITUantennasUIinput.class)};
    }

    @PostProcessing(order=2, name="Plot pattern")
    public void preparePlot(Scenario scenario) {
        this.infoPanel.repaint();
        this.inputPanel = (TestITUantennasUIinput)this.panels.get("Test configuration").getModel();
        this.selectedAntenna = this.inputPanel.antennaToTest();
        if (this.checkAntennaSelected(scenario)) {
            switch (this.selectedAntenna) {
                case F1336R2: {
                    this.doF1336R2(scenario);
                    break;
                }
                case F1336R3: {
                    this.doF1336R3(scenario);
                    break;
                }
                case F699: {
                    this.checkGranularity();
                    this.doF699(scenario);
                    break;
                }
                case F1245: {
                    this.checkGranularity();
                    this.do1245(scenario);
                    break;
                }
                default: {
                    this.doF1336R3(scenario);
                }
            }
        }
    }

    private void doF1336R2(Scenario scenario) {
        this.angles = new ArrayList<Double>();
        this.values = new ArrayList<Double>();
        if (this.inputPanel.plane() != TestITUantennasUIinput.Plane.Vertical) {
            this.popupDialog("<HtMl>Horizontal pattern are ignored by the test of the omni-directional antenna ITU-R F.1336-4 rec.2.<br/>Only vertical pattern are shown always.");
        }
        ITU_R_F1336_4_rec_2_Input f1336r2Input = Factory.prototype(ITU_R_F1336_4_rec_2_Input.class);
        if (scenario.getVictim().getSystem().getReceiver().getAntennaGain().getModel() instanceof ITU_R_F1336_4_rec_2_Input) {
            ITU_R_F1336_4_rec_2_Input antennaCopy = (ITU_R_F1336_4_rec_2_Input)scenario.getVictim().getSystem().getReceiver().getAntennaGain().getModel();
            Factory.when(f1336r2Input.mAnde()).thenReturn(this.inputPanel.mAnde());
            Factory.when(f1336r2Input.additionalTilt()).thenReturn(this.inputPanel.additionalTilt());
            Factory.when(f1336r2Input.theta3()).thenReturn(this.inputPanel.theta3());
            Factory.when(f1336r2Input.usePeak()).thenReturn(this.inputPanel.usePeakGain());
            Factory.when(f1336r2Input.tiltMode()).thenReturn(this.inputPanel.tiltModeRec2());
            Factory.when(f1336r2Input.k()).thenReturn(antennaCopy.k());
        }
        AntennaGain<ITU_R_F1336_4_rec_2_Input> antenna = Factory.antennaGainFactory().getITU_R_F1336_4_rec_2Antenna(Factory.build(f1336r2Input), this.inputPanel.peakGain());
        AntennaResult antennaResult = Factory.results().antennaResult();
        antennaResult.setTilt(this.inputPanel.tilt());
        if (this.inputPanel.fixAzi().isRelevant()) {
            this.horizontalOffset = this.inputPanel.fixAzi().getValue().trial();
            antennaResult.setAzimuth(this.horizontalOffset);
            this.getHorOffset().setText(this.df.format(this.horizontalOffset));
            this.getHorOffset().setBackground(Color.YELLOW);
        } else {
            antennaResult.setAzimuth(0.0);
            this.getHorOffset().setText("");
            this.getHorOffset().setBackground(Color.WHITE);
        }
        this.verticalOffset = 0.0;
        antennaResult.setElevation(this.verticalOffset);
        this.getVerOffset().setText("");
        this.getVerOffset().setBackground(Color.WHITE);
        if (!this.inputPanel.isInterferenceLink()) {
            antennaResult.setElevationCompensation(0.0);
            this.getFieldCompensation().setText("");
            this.getFieldCompensation().setBackground(Color.WHITE);
            for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                antennaResult.setElevation(v);
                this.values.add(antenna.evaluate(Factory.results().linkResult(), antennaResult));
                this.angles.add(v);
            }
        } else {
            this.elevationCompensation = this.inputPanel.elevationCompensation().trial();
            antennaResult.setElevationCompensation(this.elevationCompensation);
            this.getFieldCompensation().setText(this.df.format(this.elevationCompensation));
            this.getFieldCompensation().setBackground(Color.YELLOW);
            for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                antennaResult.setElevation(v);
                this.values.add(antenna.evaluate(new TestITUInterferenceLinkResult(), antennaResult));
                this.angles.add(v);
            }
        }
        this.generatePlot();
    }

    public void doF1336R3(Scenario scenario) {
        this.angles = new ArrayList<Double>();
        this.values = new ArrayList<Double>();
        ITU_R_F1336_4_rec_3_Input f1336r3Input = Factory.prototype(ITU_R_F1336_4_rec_3_Input.class);
        if (scenario.getVictim().getSystem().getTransmitter().getAntennaGain().getModel() instanceof ITU_R_F1336_4_rec_3_Input) {
            ITU_R_F1336_4_rec_3_Input antennaCopy = (ITU_R_F1336_4_rec_3_Input)scenario.getVictim().getSystem().getTransmitter().getAntennaGain().getModel();
            Factory.when(f1336r3Input.tiltMode()).thenReturn(this.inputPanel.tiltModeRec3());
            Factory.when(f1336r3Input.additionalTilt()).thenReturn(this.inputPanel.additionalTilt());
            Factory.when(f1336r3Input.mAnde()).thenReturn(this.inputPanel.mAnde());
            Factory.when(f1336r3Input.phi3()).thenReturn(this.inputPanel.phi3());
            Factory.when(f1336r3Input.theta3()).thenReturn(this.inputPanel.theta3());
            Factory.when(f1336r3Input.usePeakGain()).thenReturn(this.inputPanel.usePeakGain());
            Factory.when(f1336r3Input.kv()).thenReturn(antennaCopy.kv());
            Factory.when(f1336r3Input.kh()).thenReturn(antennaCopy.kh());
            Factory.when(f1336r3Input.kp()).thenReturn(antennaCopy.kp());
            Factory.when(f1336r3Input.ka()).thenReturn(antennaCopy.ka());
        }
        AntennaGain<ITU_R_F1336_4_rec_3_Input> antenna = Factory.antennaGainFactory().getITU_R_F1336_4_rec_3Antenna(Factory.build(f1336r3Input), this.inputPanel.peakGain());
        AntennaResult antennaResult = Factory.results().antennaResult();
        antennaResult.setTilt(this.inputPanel.tilt());
        if (this.inputPanel.fixEle().isRelevant()) {
            this.verticalOffset = this.inputPanel.fixEle().getValue().trial();
            antennaResult.setElevation(this.verticalOffset);
            this.getVerOffset().setText(this.df.format(this.verticalOffset));
            this.getVerOffset().setBackground(Color.YELLOW);
        } else {
            this.verticalOffset = 0.0;
            antennaResult.setElevation(this.verticalOffset);
            this.getVerOffset().setText("");
            this.getVerOffset().setBackground(Color.WHITE);
        }
        if (this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.Vertical)) {
            this.getVerOffset().setText("");
            this.getVerOffset().setBackground(Color.WHITE);
            if (this.inputPanel.fixAzi().isRelevant()) {
                this.horizontalOffset = this.inputPanel.fixAzi().getValue().trial();
                this.getHorOffset().setText(this.df.format(this.horizontalOffset));
                this.getHorOffset().setBackground(Color.YELLOW);
            } else {
                this.horizontalOffset = 0.0;
                this.getHorOffset().setText("");
                this.getHorOffset().setBackground(Color.WHITE);
            }
            antennaResult.setAzimuth(this.horizontalOffset);
            if (!this.inputPanel.isInterferenceLink()) {
                antennaResult.setElevationCompensation(0.0);
                this.getFieldCompensation().setText("");
                this.getFieldCompensation().setBackground(Color.WHITE);
                for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                    antennaResult.setElevation(v);
                    this.values.add(antenna.evaluate(Factory.results().linkResult(), antennaResult));
                    this.angles.add(v);
                }
            } else {
                this.elevationCompensation = this.inputPanel.elevationCompensation().trial();
                antennaResult.setElevationCompensation(this.elevationCompensation);
                this.getFieldCompensation().setText(this.df.format(this.elevationCompensation));
                this.getFieldCompensation().setBackground(Color.YELLOW);
                for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                    antennaResult.setElevation(v);
                    this.values.add(antenna.evaluate(new TestITUInterferenceLinkResult(), antennaResult));
                    this.angles.add(v);
                }
            }
        } else {
            this.getHorOffset().setText("");
            this.getHorOffset().setBackground(Color.WHITE);
            this.horizontalOffset = 0.0;
            if (!this.inputPanel.isInterferenceLink()) {
                antennaResult.setElevationCompensation(0.0);
                this.getFieldCompensation().setText("");
                this.getFieldCompensation().setBackground(Color.WHITE);
                for (double h = 0.0; h < 360.0001; h += this.inputPanel.gran()) {
                    antennaResult.setAzimuth(h);
                    this.values.add(antenna.evaluate(Factory.results().linkResult(), antennaResult));
                    this.angles.add(h);
                }
            } else {
                this.elevationCompensation = this.inputPanel.elevationCompensation().trial();
                antennaResult.setElevationCompensation(this.elevationCompensation);
                this.getFieldCompensation().setText(this.df.format(this.elevationCompensation));
                this.getFieldCompensation().setBackground(Color.YELLOW);
                for (double h = 0.0; h < 360.0001; h += this.inputPanel.gran()) {
                    antennaResult.setAzimuth(h);
                    this.values.add(antenna.evaluate(new TestITUInterferenceLinkResult(), antennaResult));
                    this.angles.add(h);
                }
            }
        }
        this.generatePlot();
    }

    public void doF699(Scenario scenario) {
        this.angles = new ArrayList<Double>();
        this.values = new ArrayList<Double>();
        ITU_R_F699Input f699Input = Factory.prototype(ITU_R_F699Input.class);
        if (scenario.getInterferenceLinks().get(0).getInterferer().getSystem().getReceiver().getAntennaGain().getModel() instanceof ITU_R_F699Input) {
            ITU_R_F699Input antennaCopy = (ITU_R_F699Input)scenario.getInterferenceLinks().get(0).getInterferer().getSystem().getReceiver().getAntennaGain().getModel();
            Factory.when(f699Input.apertureEfficiency()).thenReturn(antennaCopy.apertureEfficiency());
            Factory.when(f699Input.diameter()).thenReturn(antennaCopy.diameter());
            if (this.inputPanel.isForFixed()) {
                Factory.when(f699Input.apertureEfficiency()).thenReturn(this.inputPanel.apertureEfficiency());
                Factory.when(f699Input.diameter()).thenReturn(this.inputPanel.diameter());
            }
        }
        AntennaGain<ITU_R_F699Input> antenna = Factory.antennaGainFactory().getITU_R_F699Antenna(Factory.build(f699Input), this.inputPanel.peakGain());
        AntennaResult antennaResult = Factory.results().antennaResult();
        antennaResult.setTilt(this.inputPanel.tilt());
        if (this.inputPanel.fixEle().isRelevant()) {
            this.verticalOffset = this.inputPanel.fixEle().getValue().trial();
            antennaResult.setElevation(this.verticalOffset);
            this.getVerOffset().setText(this.df.format(this.verticalOffset));
            this.getVerOffset().setBackground(Color.YELLOW);
        } else {
            this.verticalOffset = 0.0;
            antennaResult.setElevation(this.verticalOffset);
            this.getVerOffset().setText("");
            this.getVerOffset().setBackground(Color.WHITE);
        }
        if (this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.Vertical)) {
            double frequency;
            this.getVerOffset().setText("");
            this.getVerOffset().setBackground(Color.WHITE);
            if (this.inputPanel.fixAzi().isRelevant()) {
                this.horizontalOffset = this.inputPanel.fixAzi().getValue().trial();
                this.getHorOffset().setText(this.df.format(this.horizontalOffset));
                this.getHorOffset().setBackground(Color.YELLOW);
            } else {
                this.horizontalOffset = 0.0;
                this.getHorOffset().setText("");
                this.getHorOffset().setBackground(Color.WHITE);
            }
            antennaResult.setAzimuth(this.horizontalOffset);
            double d = frequency = this.inputPanel.isForFixed() ? this.inputPanel.frequency() : 1000.0;
            if (!this.inputPanel.isInterferenceLink()) {
                antennaResult.setElevationCompensation(0.0);
                this.getFieldCompensation().setText("");
                this.getFieldCompensation().setBackground(Color.WHITE);
                for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                    antennaResult.setElevation(v);
                    LinkResult context = Factory.results().linkResult();
                    context.setFrequency(frequency);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.angles.add(v);
                }
            } else {
                this.elevationCompensation = this.inputPanel.elevationCompensation().trial();
                antennaResult.setElevationCompensation(this.elevationCompensation);
                this.getFieldCompensation().setText(this.df.format(this.elevationCompensation));
                this.getFieldCompensation().setBackground(Color.YELLOW);
                for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                    antennaResult.setElevation(v);
                    TestITUInterferenceLinkResult context = new TestITUInterferenceLinkResult();
                    context.setFrequency(frequency);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.angles.add(v);
                }
            }
        } else {
            double frequency;
            this.horizontalOffset = 0.0;
            this.getHorOffset().setText("");
            this.getHorOffset().setBackground(Color.WHITE);
            double d = frequency = this.inputPanel.isForFixed() ? this.inputPanel.frequency() : 1000.0;
            if (!this.inputPanel.isInterferenceLink()) {
                antennaResult.setElevationCompensation(0.0);
                this.getFieldCompensation().setText("");
                this.getFieldCompensation().setBackground(Color.WHITE);
                for (double h = 0.0; h < 360.0001; h += this.inputPanel.gran()) {
                    antennaResult.setAzimuth(h);
                    LinkResult context = Factory.results().linkResult();
                    context.setFrequency(frequency);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.angles.add(h);
                }
            } else {
                this.elevationCompensation = this.inputPanel.elevationCompensation().trial();
                antennaResult.setElevationCompensation(this.elevationCompensation);
                this.getFieldCompensation().setText(this.df.format(this.elevationCompensation));
                this.getFieldCompensation().setBackground(Color.YELLOW);
                for (double h = 0.0; h < 360.0001; h += this.inputPanel.gran()) {
                    antennaResult.setAzimuth(h);
                    TestITUInterferenceLinkResult context = new TestITUInterferenceLinkResult();
                    context.setFrequency(frequency);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.angles.add(h);
                }
            }
        }
        this.generatePlot();
    }

    public void do1245(Scenario scenario) {
        this.angles = new ArrayList<Double>();
        this.values = new ArrayList<Double>();
        ITU_R_F1245Input f1245Input = Factory.prototype(ITU_R_F1245Input.class);
        if (scenario.getInterferenceLinks().get(0).getInterferer().getSystem().getTransmitter().getAntennaGain().getModel() instanceof ITU_R_F1245Input) {
            ITU_R_F1245Input antennaCopy = (ITU_R_F1245Input)scenario.getInterferenceLinks().get(0).getInterferer().getSystem().getTransmitter().getAntennaGain().getModel();
            Factory.when(f1245Input.apertureEfficiency()).thenReturn(antennaCopy.apertureEfficiency());
            Factory.when(f1245Input.diameter()).thenReturn(antennaCopy.diameter());
            Factory.when(f1245Input.useAnnex1()).thenReturn(antennaCopy.useAnnex1());
            if (this.inputPanel.isForFixed()) {
                Factory.when(f1245Input.apertureEfficiency()).thenReturn(this.inputPanel.apertureEfficiency());
                Factory.when(f1245Input.diameter()).thenReturn(this.inputPanel.diameter());
                Factory.when(f1245Input.useAnnex1()).thenReturn(this.inputPanel.useAnnex1());
            }
        }
        AntennaGain<ITU_R_F1245Input> antenna = Factory.antennaGainFactory().getITU_R_F1245Antenna(Factory.build(f1245Input), this.inputPanel.peakGain());
        AntennaResult antennaResult = Factory.results().antennaResult();
        antennaResult.setTilt(this.inputPanel.tilt());
        if (this.inputPanel.fixEle().isRelevant()) {
            this.verticalOffset = this.inputPanel.fixEle().getValue().trial();
            antennaResult.setElevation(this.verticalOffset);
            this.getVerOffset().setText(this.df.format(this.verticalOffset));
            this.getVerOffset().setBackground(Color.YELLOW);
        } else {
            this.verticalOffset = 0.0;
            antennaResult.setElevation(this.verticalOffset);
            this.getVerOffset().setText("");
            this.getVerOffset().setBackground(Color.WHITE);
        }
        if (this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.Vertical)) {
            double frequency;
            this.getVerOffset().setText("");
            this.getVerOffset().setBackground(Color.WHITE);
            if (this.inputPanel.fixAzi().isRelevant()) {
                this.horizontalOffset = this.inputPanel.fixAzi().getValue().trial();
                this.getHorOffset().setText(this.df.format(this.horizontalOffset));
                this.getHorOffset().setBackground(Color.YELLOW);
            } else {
                this.horizontalOffset = 0.0;
                this.getHorOffset().setText("");
                this.getHorOffset().setBackground(Color.WHITE);
            }
            antennaResult.setAzimuth(this.horizontalOffset);
            double d = frequency = this.inputPanel.isForFixed() ? this.inputPanel.frequency() : 1000.0;
            if (!this.inputPanel.isInterferenceLink()) {
                antennaResult.setElevationCompensation(0.0);
                this.getFieldCompensation().setText("");
                this.getFieldCompensation().setBackground(Color.WHITE);
                for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                    antennaResult.setElevation(v);
                    LinkResult context = Factory.results().linkResult();
                    context.setFrequency(frequency);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.angles.add(v);
                }
            } else {
                this.elevationCompensation = this.inputPanel.elevationCompensation().trial();
                antennaResult.setElevationCompensation(this.elevationCompensation);
                this.getFieldCompensation().setText(this.df.format(this.elevationCompensation));
                this.getFieldCompensation().setBackground(Color.YELLOW);
                for (double v = -90.0; v <= 90.0; v += this.inputPanel.gran()) {
                    antennaResult.setElevation(v);
                    TestITUInterferenceLinkResult context = new TestITUInterferenceLinkResult();
                    context.setFrequency(frequency);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.angles.add(v);
                }
            }
        } else {
            double frequency;
            this.horizontalOffset = 0.0;
            this.getHorOffset().setText("");
            this.getHorOffset().setBackground(Color.WHITE);
            double d = frequency = this.inputPanel.isForFixed() ? this.inputPanel.frequency() : 1000.0;
            if (!this.inputPanel.isInterferenceLink()) {
                antennaResult.setElevationCompensation(0.0);
                this.getFieldCompensation().setText("");
                this.getFieldCompensation().setBackground(Color.WHITE);
                for (double h = 0.0; h < 360.0001; h += this.inputPanel.gran()) {
                    antennaResult.setAzimuth(h);
                    LinkResult context = Factory.results().linkResult();
                    context.setFrequency(frequency);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.angles.add(h);
                }
            } else {
                this.elevationCompensation = this.inputPanel.elevationCompensation().trial();
                antennaResult.setElevationCompensation(this.elevationCompensation);
                this.getFieldCompensation().setText(this.df.format(this.elevationCompensation));
                this.getFieldCompensation().setBackground(Color.YELLOW);
                for (double h = 0.0; h < 360.0001; h += this.inputPanel.gran()) {
                    antennaResult.setAzimuth(h);
                    TestITUInterferenceLinkResult context = new TestITUInterferenceLinkResult();
                    context.setFrequency(frequency);
                    this.values.add(antenna.evaluate(context, antennaResult));
                    this.angles.add(h);
                }
            }
        }
        this.generatePlot();
    }

    private void checkGranularity() {
        String msg;
        if (this.inputPanel.gran() > 0.1) {
            msg = "<HtMl>Due to the small beam width of the  " + this.selectedAntenna.toString() + " antenna <br/>  a granularity of not greater than 0.1 degree is recommended.";
            this.popupDialog(msg);
        }
        if (this.inputPanel.peakGain() < 20.0 && !this.inputPanel.isForFixed() || this.inputPanel.peakGain() < 20.0 && this.inputPanel.isForFixed() && !this.inputPanel.diameter().isRelevant()) {
            msg = "<HtMl>A peak gain of " + this.df.format(this.inputPanel.peakGain()) + " dBi<br/>might be too less for an " + this.selectedAntenna.toString() + " antenna.";
            this.popupDialog(msg);
        }
    }

    private void generatePlot() {
        this.plotPanel.removeAll();
        XYSeriesCollection dataset = new XYSeriesCollection();
        String plane = "horizontal";
        if (this.inputPanel.plane().toString().contains("Vertical") || this.inputPanel.antennaToTest().equals((Object)TestITUantennasUIinput.AntennaSelection.F1336R2)) {
            plane = "vertical";
        }
        XYSeries pattern = new XYSeries((Comparable)((Object)plane));
        if (this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.HorizontalSimulated) || this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.Vertical) || this.inputPanel.antennaToTest().equals((Object)TestITUantennasUIinput.AntennaSelection.F1336R2)) {
            for (int i = 0; i < this.angles.size(); ++i) {
                pattern.add(this.angles.get(i), (Number)this.values.get(i));
            }
        } else if (this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.HorizontalSymmetric)) {
            List<Double> symmetrical = this.convertToSymmetrical(this.angles);
            for (int i = 0; i < symmetrical.size(); ++i) {
                pattern.add(symmetrical.get(i), (Number)this.values.get(i));
            }
        }
        dataset.addSeries(pattern);
        JFreeChart dRSSchart = ChartFactory.createXYLineChart(this.inputPanel.antennaToTest().toString(), "off axis [degrees]", "gain [dBi]", dataset, PlotOrientation.VERTICAL, true, true, false);
        dRSSchart.fireChartChanged();
        XYPlot plot = (XYPlot)dRSSchart.getPlot();
        plot.getRenderer().setSeriesPaint(0, Color.BLUE);
        ChartPanel cp = new ChartPanel(dRSSchart);
        cp.repaint();
        this.plotPanel.add((Component)cp, "Center");
        this.plotPanel.revalidate();
        this.plotPanel.repaint();
        this.split.repaint();
    }

    private List<Double> convertToSymmetrical(List<Double> simulated) {
        ArrayList<Double> sym = new ArrayList<Double>();
        for (Double aSimulated : simulated) {
            double a = aSimulated;
            if (Mathematics.equals(a, 180.0, 1.0E-5)) {
                a = -180.0;
            } else if (a > 180.0) {
                a = -360.0 + a;
            }
            sym.add(a);
        }
        return sym;
    }

    private double getPeakGainApplied() {
        if (!this.inputPanel.theta3().isRelevant()) {
            return this.inputPanel.peakGain();
        }
        double phi3 = this.inputPanel.phi3();
        double theta3 = this.inputPanel.theta3().getValue();
        double gain = phi3 >= 120.0 ? -10.0 * Math.log10(theta3 / 107.6) : -10.0 * Math.log10(theta3 * phi3 / 31000.0);
        return gain;
    }

    private void prepareExport() {
        if (this.values.size() > 0) {
            TestITUantennasUIinput.AntennaSelection antennaSelected = this.inputPanel.antennaToTest();
            double peakGainApplied = antennaSelected.equals((Object)TestITUantennasUIinput.AntennaSelection.F1245) || antennaSelected.equals((Object)TestITUantennasUIinput.AntennaSelection.F699) ? (this.inputPanel.isForFixed() && this.inputPanel.diameter().isRelevant() ? this.getResultingGain() : this.inputPanel.peakGain()) : (this.inputPanel.theta3().isRelevant() ? this.getPeakGainApplied() : this.inputPanel.peakGain());
            String envelope = this.inputPanel.usePeakGain() ? "_peak" : "_average";
            String fileName = antennaSelected.toString() + "_" + this.inputPanel.plane().toString() + "_" + this.df.format(peakGainApplied) + " dBi" + envelope + ".xlsx";
            DataFile file = this.exporter.chooseFile(fileName);
            if (file != null) {
                if (!this.getChckbxExportPatternOnly().isSelected()) {
                    file.addRow("Test results of " + antennaSelected.toString());
                    if (antennaSelected.equals((Object)TestITUantennasUIinput.AntennaSelection.F1336R2) || this.inputPanel.plane().toString().contains("vertical")) {
                        file.addRow("plane", TestITUantennasUIinput.Plane.Vertical.toString());
                    } else {
                        file.addRow("plane", this.inputPanel.plane().toString());
                    }
                    if (this.selectedAntenna.equals((Object)TestITUantennasUIinput.AntennaSelection.F1336R2)) {
                        file.addRow("tilt mode", this.inputPanel.tiltModeRec2().toString());
                    } else if (this.selectedAntenna.equals((Object)TestITUantennasUIinput.AntennaSelection.F1336R3)) {
                        file.addRow("tilt mode", this.inputPanel.tiltModeRec3().toString());
                    }
                    if (!Mathematics.equals(this.inputPanel.tilt(), 0.0, 0.001)) {
                        file.addRow("tilt", this.df.format(this.inputPanel.tilt()), "degree");
                    }
                    if (this.inputPanel.isInterferenceLink()) {
                        file.addRow("elevation compensation ", this.inputPanel.elevationCompensation().toString(), "degree");
                        file.addRow("elevation compensation applied", this.getFieldCompensation().getText(), "degree");
                    }
                    if (this.inputPanel.fixAzi().isRelevant() && this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.Vertical)) {
                        file.addRow("azimuth offset", this.inputPanel.fixAzi().getValue().toString(), "degree");
                        file.addRow("azimuth offset applied", this.getHorOffset().getText(), "degree");
                    }
                    if (this.inputPanel.fixEle().isRelevant() && !this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.Vertical)) {
                        file.addRow("vertical offset", this.inputPanel.fixEle().getValue().toString(), "degree");
                        file.addRow("vertical offset applied", this.getVerOffset().getText(), "degree");
                    }
                    switch (antennaSelected) {
                        case F699: 
                        case F1245: {
                            if (!this.inputPanel.isForFixed()) break;
                            file.addRow("frequency", this.df.format(this.inputPanel.frequency()), "MHz");
                            if (this.inputPanel.apertureEfficiency().isRelevant()) {
                                file.addRow("aperture efficiency", this.df.format(this.inputPanel.apertureEfficiency().getValue()));
                            }
                            if (this.inputPanel.diameter().isRelevant()) {
                                file.addRow("diamteter", this.df.format(this.inputPanel.diameter().getValue()), "m");
                                file.addRow("resulting peak gain", this.df.format(peakGainApplied), "dBi");
                            } else {
                                file.addRow("peak Gain", this.df.format(peakGainApplied), "dBi");
                            }
                            if (!antennaSelected.equals((Object)TestITUantennasUIinput.AntennaSelection.F1245) || !this.inputPanel.useAnnex1()) break;
                            file.addRow("Annex 1 of ITU-R F.1245-2 applied");
                            break;
                        }
                        default: {
                            if (this.inputPanel.theta3().isRelevant()) {
                                file.addRow("vertical beam width", this.df.format(this.inputPanel.theta3().getValue()), "degree");
                                file.addRow("resulting peak gain", this.df.format(peakGainApplied), "dBi");
                            } else {
                                file.addRow("peak Gain", this.df.format(peakGainApplied), "dBi");
                            }
                            if (!this.inputPanel.mAnde()) break;
                            file.addRow("additional tilt", this.inputPanel.additionalTilt().toString(), "degree");
                        }
                    }
                    file.addRow("", "");
                    file.addRow("off-axis", "gain");
                }
                ArrayList<Double> offaxis = new ArrayList<Double>();
                if (this.inputPanel.plane().equals((Object)TestITUantennasUIinput.Plane.HorizontalSymmetric)) {
                    offaxis.addAll(this.convertToSymmetrical(this.angles));
                } else {
                    offaxis.addAll(this.angles);
                }
                for (int i = 0; i < offaxis.size(); ++i) {
                    double relGain = this.values.get(i) - peakGainApplied;
                    file.addRow((Number)offaxis.get(i), relGain);
                }
                file.close();
            }
        }
    }

    private double getResultingGain() {
        double diameterToLambda = this.inputPanel.diameter().getValue() * this.inputPanel.frequency() / 300.0;
        double g = this.inputPanel.apertureEfficiency().isRelevant() ? 10.0 * Math.log10(this.inputPanel.apertureEfficiency().getValue() * Math.PI * Math.PI * diameterToLambda * diameterToLambda) : 7.7 + 20.0 * Math.log10(diameterToLambda);
        return g;
    }

    private boolean checkAntennaSelected(Scenario scenario) {
        String msg = "<HtMl>";
        if (!scenario.getVictim().getSystem().getReceiver().getAntennaGain().description().name().equals(TestITUantennasUIinput.AntennaSelection.F1336R2.toString()) && this.selectedAntenna == TestITUantennasUIinput.AntennaSelection.F1336R2) {
            msg = msg + "Please set " + TestITUantennasUIinput.AntennaSelection.F1336R2.toString() + " to VLR <br/>";
        }
        if (!scenario.getVictim().getSystem().getTransmitter().getAntennaGain().description().name().equals(TestITUantennasUIinput.AntennaSelection.F1336R3.toString()) && this.selectedAntenna == TestITUantennasUIinput.AntennaSelection.F1336R3) {
            msg = msg + "Please set " + TestITUantennasUIinput.AntennaSelection.F1336R3.toString() + " to VLT <br/>";
        }
        if (!scenario.getInterferenceLinks().get(0).getInterferer().getSystem().getReceiver().getAntennaGain().description().name().equals(TestITUantennasUIinput.AntennaSelection.F699.toString()) && this.selectedAntenna == TestITUantennasUIinput.AntennaSelection.F699) {
            msg = msg + "Please set " + TestITUantennasUIinput.AntennaSelection.F699.toString() + " to ILR <br/>";
        }
        if (!scenario.getInterferenceLinks().get(0).getInterferer().getSystem().getTransmitter().getAntennaGain().description().name().equals(TestITUantennasUIinput.AntennaSelection.F1245.toString()) && this.selectedAntenna == TestITUantennasUIinput.AntennaSelection.F1245) {
            msg = msg + "Please set " + TestITUantennasUIinput.AntennaSelection.F1245.toString() + " to ILT <br/>";
        }
        if (msg.length() > 10) {
            msg = msg + "<b>Restart the simulation to apply the changes.</b>";
            this.popupDialog(msg);
            return false;
        }
        return true;
    }

    private void popupDialog(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Test ITU-R F-Series antennas", 1);
    }

    private JPanel getInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.infoPanel.setLayout(gridBagLayout);
        JLabel lblHorizontalOffset = new JLabel("horizontal offset  ");
        GridBagConstraints gbc_lblHorizontalOffset = new GridBagConstraints();
        gbc_lblHorizontalOffset.anchor = 13;
        gbc_lblHorizontalOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblHorizontalOffset.gridx = 0;
        gbc_lblHorizontalOffset.gridy = 0;
        this.infoPanel.add((Component)lblHorizontalOffset, gbc_lblHorizontalOffset);
        this.horOffset = new JTextField();
        GridBagConstraints gbc_horOffset = new GridBagConstraints();
        gbc_horOffset.insets = new Insets(0, 0, 5, 5);
        gbc_horOffset.fill = 2;
        gbc_horOffset.gridx = 2;
        gbc_horOffset.gridy = 0;
        this.infoPanel.add((Component)this.horOffset, gbc_horOffset);
        this.horOffset.setColumns(10);
        JLabel lblDegree = new JLabel(" degree");
        GridBagConstraints gbc_lblDegree = new GridBagConstraints();
        gbc_lblDegree.insets = new Insets(0, 0, 5, 5);
        gbc_lblDegree.gridx = 3;
        gbc_lblDegree.gridy = 0;
        this.infoPanel.add((Component)lblDegree, gbc_lblDegree);
        JLabel lblVerticalOffset = new JLabel("vertical offset  ");
        GridBagConstraints gbc_lblVerticalOffset = new GridBagConstraints();
        gbc_lblVerticalOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblVerticalOffset.anchor = 13;
        gbc_lblVerticalOffset.gridx = 0;
        gbc_lblVerticalOffset.gridy = 1;
        this.infoPanel.add((Component)lblVerticalOffset, gbc_lblVerticalOffset);
        this.verOffset = new JTextField();
        GridBagConstraints gbc_verOffset = new GridBagConstraints();
        gbc_verOffset.insets = new Insets(0, 0, 5, 5);
        gbc_verOffset.fill = 2;
        gbc_verOffset.gridx = 2;
        gbc_verOffset.gridy = 1;
        this.infoPanel.add((Component)this.verOffset, gbc_verOffset);
        this.verOffset.setColumns(10);
        JLabel lblDegree_1 = new JLabel(" degree");
        GridBagConstraints gbc_lblDegree_1 = new GridBagConstraints();
        gbc_lblDegree_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblDegree_1.gridx = 3;
        gbc_lblDegree_1.gridy = 1;
        this.infoPanel.add((Component)lblDegree_1, gbc_lblDegree_1);
        this.chckbxExportPatternOnly = new JCheckBox("export pattern only ");
        this.chckbxExportPatternOnly.setToolTipText("not selected adds a header with all relevant settings");
        this.chckbxExportPatternOnly.setSelected(true);
        GridBagConstraints gbc_chckbxExportPatternOnly = new GridBagConstraints();
        gbc_chckbxExportPatternOnly.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxExportPatternOnly.gridx = 7;
        gbc_chckbxExportPatternOnly.gridy = 1;
        this.infoPanel.add((Component)this.chckbxExportPatternOnly, gbc_chckbxExportPatternOnly);
        JButton btnNewButton = new JButton("Export Pattern to XLSX");
        btnNewButton.setForeground(Color.BLUE);
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TestITUantennasUI.this.prepareExport();
            }
        });
        GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
        gbc_btnNewButton.insets = new Insets(0, 0, 5, 0);
        gbc_btnNewButton.gridx = 7;
        gbc_btnNewButton.gridy = 2;
        this.infoPanel.add((Component)btnNewButton, gbc_btnNewButton);
        JLabel lblElevationCompensation = new JLabel(" elevation compensation  ");
        GridBagConstraints gbc_lblElevationCompensation = new GridBagConstraints();
        gbc_lblElevationCompensation.insets = new Insets(0, 0, 0, 5);
        gbc_lblElevationCompensation.anchor = 13;
        gbc_lblElevationCompensation.gridx = 0;
        gbc_lblElevationCompensation.gridy = 2;
        this.infoPanel.add((Component)lblElevationCompensation, gbc_lblElevationCompensation);
        this.fieldCompensation = new JTextField();
        GridBagConstraints gbc_fieldCompensation = new GridBagConstraints();
        gbc_fieldCompensation.insets = new Insets(0, 0, 0, 5);
        gbc_fieldCompensation.fill = 2;
        gbc_fieldCompensation.gridx = 2;
        gbc_fieldCompensation.gridy = 2;
        this.infoPanel.add((Component)this.fieldCompensation, gbc_fieldCompensation);
        this.fieldCompensation.setColumns(10);
        JLabel lblDegree_2 = new JLabel(" degree");
        GridBagConstraints gbc_lblDegree_2 = new GridBagConstraints();
        gbc_lblDegree_2.insets = new Insets(0, 0, 0, 5);
        gbc_lblDegree_2.gridx = 3;
        gbc_lblDegree_2.gridy = 2;
        this.infoPanel.add((Component)lblDegree_2, gbc_lblDegree_2);
        return this.infoPanel;
    }

    private JTextField getHorOffset() {
        return this.horOffset;
    }

    private JTextField getVerOffset() {
        return this.verOffset;
    }

    private JTextField getFieldCompensation() {
        return this.fieldCompensation;
    }

    private JCheckBox getChckbxExportPatternOnly() {
        return this.chckbxExportPatternOnly;
    }
}

