/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.function;

import java.util.Arrays;
import java.util.List;

public class BinarySearch<T> {
    private List<T> sortedList;
    private Filter<T> filter;

    private BinarySearch(List<T> sortedList, Filter<T> filter) {
        this.sortedList = sortedList;
        this.filter = filter;
    }

    public static <T> int search(List<T> sortedList, Filter<T> filter) {
        if (filter == null || sortedList == null || sortedList.isEmpty()) {
            return 0;
        }
        int highestIndex = sortedList.size() - 1;
        if (sortedList.size() < 10) {
            int i;
            for (i = 0; i < sortedList.size() && filter.evaluate(sortedList.get(i), i); ++i) {
            }
            return Math.min(i, highestIndex);
        }
        return Math.min(super.search(0, highestIndex), highestIndex);
    }

    public static <T> int searchArray(T[] sortedArray, Filter<T> filter) {
        if (sortedArray == null || sortedArray.length == 0) {
            return 0;
        }
        return BinarySearch.search(Arrays.asList(sortedArray), filter);
    }

    private <T> int search(int min, int max) {
        if (!this.filter.evaluate(this.sortedList.get(min), min)) {
            return min;
        }
        if (min == max) {
            return min + 1;
        }
        if (min + 1 == max) {
            if (this.filter.evaluate(this.sortedList.get(max), max)) {
                return max + 1;
            }
            return min + 1;
        }
        int middle = (min + max) / 2;
        if (this.filter.evaluate(this.sortedList.get(middle), middle)) {
            return this.search(middle, max);
        }
        return this.search(min, middle);
    }

    public static interface Filter<T> {
        public boolean evaluate(T var1, int var2);
    }
}

