/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.function;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class EmissionMaskImpl
implements EmissionMask {
    private Description description = new DescriptionImpl("Spectrum Emission Mask", "");
    private MaskFunctionImpl emissionMask;

    public EmissionMaskImpl() {
        this.emissionMask = new MaskFunctionImpl(new ArrayList<Point2D>(), new ArrayList<Double>());
    }

    public EmissionMaskImpl(List<Point2D> points, List<Double> mask) {
        this.emissionMask = new MaskFunctionImpl(points, mask);
    }

    public String toString() {
        return this.description().name();
    }

    public EmissionMaskImpl copy() {
        ArrayList<Double> mask = new ArrayList<Double>();
        for (Point2D point : this.emissionMask.points()) {
            mask.add(this.emissionMask.getMask(point));
        }
        ArrayList<Point2D> copy = new ArrayList<Point2D>(this.emissionMask.points());
        EmissionMaskImpl result = new EmissionMaskImpl(copy, mask);
        result.setDescription(this.description());
        return result;
    }

    @Override
    public Description description() {
        return this.description;
    }

    @Override
    public MaskFunction getEmissionMask() {
        return this.emissionMask;
    }

    public void setDescription(Description description) {
        this.description = description;
    }
}

