/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.help;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.seamcat.presentation.MainWindow;

public class SeamcatHelpResolver {
    private static final Logger LOG = Logger.getLogger(SeamcatHelpResolver.class);
    private static Properties helpUriMapping;

    public static URI resolveHelpURI(Object o, String context) throws Exception {
        if (helpUriMapping == null) {
            SeamcatHelpResolver.reloadHelpUriMappings();
        }
        String key = o.getClass().getName();
        return SeamcatHelpResolver.getUri(context, key);
    }

    private static URI getUri(String context, String key) throws URISyntaxException {
        if (helpUriMapping.containsKey(key)) {
            String url = helpUriMapping.getProperty(key);
            if (context != null) {
                url = url + "#" + context;
            }
            URI uri = new URI(url);
            return uri;
        }
        LOG.warn("No Help URI found for: " + key);
        URI uri = new URI("http://confluence.seamcat.org/display/SH/SEAMCAT+Handbook");
        return uri;
    }

    public static void reloadHelpUriMappings() throws IOException {
        helpUriMapping = new Properties();
        helpUriMapping.load(SeamcatHelpResolver.class.getResourceAsStream("/help_urls.properties"));
    }

    public static void showHelp(Object o, String context) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            URI uri = null;
            try {
                uri = SeamcatHelpResolver.resolveHelpURI(o, context);
                desktop.browse(uri);
            }
            catch (Exception use) {
                LOG.error("Unable to show help page in browser", use);
                JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>SEAMCAT was unable to launch a browser and direct you to the help page:<br />" + (uri != null ? uri.toString() : "No URL was found"), "Unable to launch browser", 2);
            }
        }
    }

    public static void showHelp(String name) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            URI uri = null;
            try {
                if (helpUriMapping == null) {
                    SeamcatHelpResolver.reloadHelpUriMappings();
                }
                uri = new URI(name);
                desktop.browse(uri);
            }
            catch (Exception use) {
                LOG.error("Unable to show help page in browser", use);
                JOptionPane.showMessageDialog(MainWindow.getInstance(), "<html>SEAMCAT was unable to launch a browser and direct you to the help page:<br />" + (uri != null ? uri.toString() : "No URL was found"), "Unable to launch browser", 2);
            }
        }
    }

    public static void showHelp(Object o) {
        SeamcatHelpResolver.showHelp(o, null);
    }
}

