/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.interfaces;

import org.seamcat.interfaces.LibraryVisitor;
import org.seamcat.model.Library;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.TransmitterModel;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.presentation.library.LibraryItemWrapper;

public class DuplicateVisitor
implements LibraryVisitor<Boolean> {
    private final Library existing;

    public DuplicateVisitor(Library existing) {
        this.existing = existing;
    }

    @Override
    public Boolean visit(ReceiverModel receiver) {
        String name = receiver.description().name();
        for (ReceiverModel rec : this.existing.getReceivers()) {
            if (!name.equals(rec.description().name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(TransmitterModel transmitter) {
        String name = transmitter.description().name();
        for (LibraryItem libraryItem : this.existing.getTransmitters()) {
            if (!name.equals(libraryItem.description().name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(CDMALLD lld) {
        for (CDMALLD cdmalld : this.existing.getCDMALinkLevelData()) {
            if (!LibraryItemWrapper.toString(cdmalld).equals(LibraryItemWrapper.toString(lld))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(EmissionMask mask) {
        return this.existing.getSpectrumEmissionMasks().contains(mask);
    }

    @Override
    public Boolean visit(BlockingMask mask) {
        return this.existing.getReceiverBlockingMasks().contains(mask);
    }

    @Override
    public Boolean visit(IntermodulationRejectionMask mask) {
        return this.existing.getIntermodRejectionMasks().contains(mask);
    }

    @Override
    public Boolean visit(BitRateMapping bitRateMapping) {
        return this.existing.getBitRateMappings().contains(bitRateMapping);
    }

    @Override
    public Boolean visit(Configuration plugin) {
        return this.existing.getPluginConfigurations(plugin.getClass()).contains(plugin);
    }

    @Override
    public Boolean visit(SystemPluginConfiguration system) {
        String name = system.configuration().description().name();
        for (SystemPluginConfiguration model : this.existing.getSystems()) {
            if (!name.equals(model.configuration().description().name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(JarConfigurationModel jar) {
        String name = jar.getName();
        for (JarConfigurationModel model : this.existing.getInstalledJars()) {
            if (!model.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

