/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.loadsave;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.FactoryConfigurationError;
import org.seamcat.batch.BatchJobList;
import org.seamcat.marshalling.BatchMarshaller;
import org.seamcat.marshalling.WorkspaceMarshaller;
import org.seamcat.migration.IOUtils;
import org.seamcat.model.Workspace;
import org.seamcat.persistence.Marshaller;

public class BatchSaver {
    private BatchJobList batch;

    public BatchSaver(BatchJobList batch) {
        this.batch = batch;
    }

    public void saveToFile(File file) {
        FileOutputStream outputStream;
        try {
            outputStream = new FileOutputStream(file);
            this.saveToStream(outputStream);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        IOUtils.closeQuietly(outputStream);
    }

    public void saveToStream(OutputStream outputStream) {
        try {
            this.trySaveToStream(outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void trySaveToStream(OutputStream outputStream) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
        this.saveScenarioToZip(zipOutputStream);
        this.saveResultsToZip(zipOutputStream);
        zipOutputStream.close();
    }

    private void saveResultsToZip(ZipOutputStream zipOutputStream) throws IOException, FactoryConfigurationError {
        for (Workspace item : this.batch.getBatchJobs()) {
            if (!item.isHasBeenCalculated()) continue;
            ZipEntry resultsXmlZipEntry = new ZipEntry(item.getName() + "_results.xml");
            zipOutputStream.putNextEntry(resultsXmlZipEntry);
            Marshaller marshaller = IOUtils.fromOutputStream(zipOutputStream);
            WorkspaceMarshaller.saveResultsToXmlStream(item.getSimulationResults(), marshaller);
            marshaller.close();
        }
    }

    private void saveScenarioToZip(ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry scenarioXmlZipEntry = new ZipEntry("batch.xml");
        zipOutputStream.putNextEntry(scenarioXmlZipEntry);
        Marshaller marshaller = IOUtils.fromOutputStream(zipOutputStream);
        BatchMarshaller.marshall(marshaller, this.batch);
        marshaller.close();
    }
}

