/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.loadsave;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.seamcat.commands.CancelLoadCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.EventHandler;
import org.seamcat.loadsave.LoadException;
import org.seamcat.loadsave.ResultLoader;
import org.seamcat.marshalling.WorkspaceMarshaller;
import org.seamcat.marshalling.WorkspaceResultMarshaller;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.XmlUtils;
import org.seamcat.model.Workspace;
import org.seamcat.model.engines.PartialSimulationResults;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.UnMarshallerW3CDom;
import org.seamcat.persistence.impl.XmlEventStream;
import org.seamcat.scenario.WorkspaceScenario;
import org.w3c.dom.Document;

public class WorkspaceLoader {
    private boolean loadCancelled = false;
    private UnMarshaller unMarshaller;

    public WorkspaceLoader() {
        EventBusFactory.getEventBus().subscribe(this);
    }

    public Workspace loadFromFile(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Workspace workspace = this.loadWorkspaceScenarioFromZipFile(zipFile);
        if (!this.loadPartial(workspace, zipFile)) {
            this.loadResultsIntoWorkspace(workspace, zipFile);
        }
        return workspace;
    }

    private Workspace loadWorkspaceScenarioFromZipFile(ZipFile zipFile) {
        Document document;
        ZipEntry scenarioEntry = zipFile.getEntry("scenario.xml");
        if (scenarioEntry == null) {
            throw new LoadException("Failed to load workspace. Scenario entry not found in zip file.");
        }
        try {
            document = XmlUtils.parse(zipFile.getInputStream(scenarioEntry));
        }
        catch (IOException e) {
            throw new LoadException(e);
        }
        return WorkspaceMarshaller.unmarshall(new UnMarshallerW3CDom(document.getDocumentElement()));
    }

    private boolean loadPartial(Workspace workspace, ZipFile zipFile) {
        ZipEntry partialEntry = zipFile.getEntry("partial.xml");
        if (partialEntry != null) {
            try {
                this.unMarshaller = IOUtils.fromInputStream(zipFile.getInputStream(partialEntry));
                workspace.setScenario(new WorkspaceScenario(workspace));
                PartialSimulationResults partial = WorkspaceResultMarshaller.loadFromXmlStream(workspace.getScenario(), this.unMarshaller);
                workspace.setPartial(partial);
                workspace.setHasBeenCalculated(false);
                return true;
            }
            catch (XmlEventStream.Cancelled partial) {
            }
            catch (Exception e) {
                throw new LoadException("Failed to load results into workspace.", e);
            }
        }
        return false;
    }

    private void loadResultsIntoWorkspace(Workspace workspace, ZipFile zipFile) {
        ZipEntry resultsEntry = zipFile.getEntry("results.xml");
        if (resultsEntry != null) {
            try {
                this.unMarshaller = IOUtils.fromInputStream(zipFile.getInputStream(resultsEntry));
                ResultLoader.readResultsFromXmlStream(workspace, this.unMarshaller);
                workspace.setHasBeenCalculated(true);
            }
            catch (XmlEventStream.Cancelled cancelled) {
            }
            catch (Exception e) {
                throw new LoadException("Failed to load results into workspace.", e);
            }
        } else {
            workspace.setHasBeenCalculated(false);
        }
    }

    public boolean isCancelled() {
        return this.loadCancelled;
    }

    @EventHandler
    public void cancel(CancelLoadCommand command) {
        this.loadCancelled = true;
        this.unMarshaller.cancel();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        EventBusFactory.getEventBus().unsubscribe(this);
    }
}

