/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.loadsave;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.FactoryConfigurationError;
import org.seamcat.marshalling.WorkspaceMarshaller;
import org.seamcat.migration.IOUtils;
import org.seamcat.model.Workspace;
import org.seamcat.model.engines.PartialSimulationResults;
import org.seamcat.persistence.Marshaller;
import org.seamcat.simulation.result.SimulationResultImpl;

public class WorkspaceSaver {
    private Workspace workspace;
    private SimulationResultImpl results;
    private PartialSimulationResults partial;

    public WorkspaceSaver(Workspace workspace) {
        this.workspace = workspace;
        if (workspace.isHasBeenCalculated()) {
            this.results = workspace.getSimulationResults();
        } else if (workspace.getPartial() != null) {
            this.partial = workspace.getPartial();
        }
    }

    public void saveToFile(File file) {
        FileOutputStream outputStream;
        try {
            outputStream = new FileOutputStream(file);
            this.saveToStream(outputStream);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        IOUtils.closeQuietly(outputStream);
    }

    private void saveToStream(OutputStream outputStream) {
        try {
            this.trySaveToStream(outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void trySaveToStream(OutputStream outputStream) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
        this.saveScenarioToZip(zipOutputStream);
        if (this.results != null) {
            this.saveResultsToZip(zipOutputStream);
        } else if (this.partial != null) {
            this.savePartialToZip(zipOutputStream);
        }
        zipOutputStream.close();
    }

    private void savePartialToZip(ZipOutputStream zipOutputStream) throws IOException, FactoryConfigurationError {
        ZipEntry resultsXmlZipEntry = new ZipEntry("partial.xml");
        zipOutputStream.putNextEntry(resultsXmlZipEntry);
        Marshaller marshaller = IOUtils.fromOutputStream(zipOutputStream);
        WorkspaceMarshaller.saveResultsToXmlStream(this.partial, marshaller);
        marshaller.close();
    }

    private void saveResultsToZip(ZipOutputStream zipOutputStream) throws IOException, FactoryConfigurationError {
        ZipEntry resultsXmlZipEntry = new ZipEntry("results.xml");
        zipOutputStream.putNextEntry(resultsXmlZipEntry);
        Marshaller marshaller = IOUtils.fromOutputStream(zipOutputStream);
        WorkspaceMarshaller.saveResultsToXmlStream(this.results, marshaller);
        marshaller.close();
    }

    private void saveScenarioToZip(ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry scenarioXmlZipEntry = new ZipEntry("scenario.xml");
        zipOutputStream.putNextEntry(scenarioXmlZipEntry);
        Marshaller marshaller = IOUtils.fromOutputStream(zipOutputStream);
        WorkspaceMarshaller.toElement(this.workspace, marshaller);
        marshaller.close();
    }
}

