/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.marshalling;

import java.util.LinkedHashMap;
import java.util.Map;
import org.seamcat.model.engines.IndexedValueDef;
import org.seamcat.model.engines.PartialSimulationResults;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.simulation.result.FunctionDefImpl;
import org.seamcat.simulation.result.MultiPlotDefImpl;
import org.seamcat.simulation.result.SingleValueDefImpl;
import org.seamcat.simulation.result.VectorDefImpl;

public class IndexedValueDefMarshaller {
    public static int addValueDef(IndexedValueDef def, int id, Map<IndexedValueDef, Integer> vectorIdMap, Marshaller marshaller, String type) {
        if (def.getDef().intermediate()) {
            return id;
        }
        vectorIdMap.put(def, id);
        marshaller.beginElement("valueDef");
        marshaller.attribute("type", type);
        marshaller.attribute("id", Integer.toString(id));
        marshaller.attribute("index", Integer.toString(def.getIndex()));
        Object value = def.getDef();
        marshaller.attribute("name", value.name());
        marshaller.attribute("unit", value.unit());
        if (value.isGrouped()) {
            marshaller.attribute("group", value.group());
        }
        if (value instanceof UniqueValueDef) {
            marshaller.attribute("yUnit", ((UniqueValueDef)value).yUnit());
        } else if (value instanceof MultiValueDef) {
            marshaller.attribute("yUnit", ((MultiValueDef)value).yUnit());
        }
        marshaller.endElement("valueDef");
        return id + 1;
    }

    public static void readValueDef(PartialSimulationResults results, Map<Integer, IndexedValueDef> vectorIdMap, Map<Integer, LinkedHashMap> valueMap, Map<Integer, String> typeMap, UnMarshaller unMarshaller) {
        int id = Integer.parseInt(unMarshaller.attribute("id"));
        String name = unMarshaller.attribute("name");
        String unit = unMarshaller.attribute("unit");
        String group = unMarshaller.attribute("group");
        int index = Integer.parseInt(unMarshaller.attribute("index"));
        String type = unMarshaller.attribute("type");
        typeMap.put(id, type);
        switch (type) {
            case "vector": {
                VectorDefImpl def = group == null ? new VectorDefImpl(name, unit, false) : new VectorDefImpl(group, name, unit, false);
                vectorIdMap.put(id, new IndexedValueDef<VectorDefImpl>(index, def));
                valueMap.put(id, results.getVectorResults());
                break;
            }
            case "sample": {
                VectorDefImpl sample = group == null ? new VectorDefImpl(name, unit, false) : new VectorDefImpl(group, name, unit, false);
                vectorIdMap.put(id, new IndexedValueDef<VectorDefImpl>(index, sample));
                valueMap.put(id, results.getSampleResults());
                break;
            }
            case "barChart": {
                MultiPlotDefImpl barDef = group == null ? new MultiPlotDefImpl(name, unit, unMarshaller.attribute("yUnit"), false) : new MultiPlotDefImpl(group, name, unit, unMarshaller.attribute("yUnit"), false);
                vectorIdMap.put(id, new IndexedValueDef<MultiPlotDefImpl>(index, barDef));
                valueMap.put(id, results.getBarCharts());
                break;
            }
            case "scatter": {
                MultiPlotDefImpl scat = group == null ? new MultiPlotDefImpl(name, unit, unMarshaller.attribute("yUnit"), false) : new MultiPlotDefImpl(group, name, unit, unMarshaller.attribute("yUnit"), false);
                vectorIdMap.put(id, new IndexedValueDef<MultiPlotDefImpl>(index, scat));
                valueMap.put(id, results.getScatterPlots());
                break;
            }
            case "function": {
                FunctionDefImpl func = group == null ? new FunctionDefImpl(name, unit, unMarshaller.attribute("yUnit"), false) : new FunctionDefImpl(group, name, unit, unMarshaller.attribute("yUnit"), false);
                vectorIdMap.put(id, new IndexedValueDef<FunctionDefImpl>(index, func));
                valueMap.put(id, results.getFunctions());
                break;
            }
            case "single": {
                SingleValueDefImpl sin = group == null ? new SingleValueDefImpl(name, unit, false) : new SingleValueDefImpl(group, name, unit, false);
                vectorIdMap.put(id, new IndexedValueDef<SingleValueDefImpl>(index, sin));
                valueMap.put(id, results.getSingleValues());
                break;
            }
            case "linkResult": {
                MultiPlotDefImpl lr = group == null ? new MultiPlotDefImpl(name, unit, unMarshaller.attribute("yUnit"), false) : new MultiPlotDefImpl(group, name, unit, unMarshaller.attribute("yUnit"), false);
                vectorIdMap.put(id, new IndexedValueDef<MultiPlotDefImpl>(index, lr));
                valueMap.put(id, results.getLinkResults());
            }
        }
    }
}

