/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.marshalling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.settings.SettingsFormatVersionConstants;
import org.seamcat.migration.settings.SettingsMigrator;
import org.seamcat.model.LibraryModel;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.TransmitterModel;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.JarFiles;

public class LibraryMarshaller {
    private static final Logger LOG = Logger.getLogger(LibraryMarshaller.class);

    public void exportLibrary(List<LibraryItem> selected, File file) {
        try {
            LibraryModel model = Factory.prototype(LibraryModel.class);
            List systems = Factory.when(model.systems()).thenReturn(new ArrayList());
            List receivers = Factory.when(model.receivers()).thenReturn(new ArrayList());
            List transmitters = Factory.when(model.transmitters()).thenReturn(new ArrayList());
            List lld = Factory.when(model.cdmalld()).thenReturn(new ArrayList());
            List emissionMasks = Factory.when(model.emissionMasks()).thenReturn(new ArrayList());
            List blockingMasks = Factory.when(model.blockingMasks()).thenReturn(new ArrayList());
            List jars = Factory.when(model.jars()).thenReturn(new ArrayList());
            List configurations = Factory.when(model.pluginConfigurations()).thenReturn(new ArrayList());
            for (LibraryItem item : selected) {
                if (item instanceof SystemPluginConfiguration) {
                    systems.add((SystemPluginConfiguration)item);
                    continue;
                }
                if (item instanceof ReceiverModel) {
                    receivers.add((ReceiverModel)item);
                    continue;
                }
                if (item instanceof TransmitterModel) {
                    transmitters.add((TransmitterModel)item);
                    continue;
                }
                if (item instanceof CDMALLD) {
                    lld.add((CDMALLD)item);
                    continue;
                }
                if (item instanceof EmissionMask) {
                    emissionMasks.add((EmissionMask)item);
                    continue;
                }
                if (item instanceof BlockingMask) {
                    blockingMasks.add((BlockingMask)item);
                    continue;
                }
                if (item instanceof Configuration) {
                    JarConfigurationModel jar;
                    Configuration configuration = (Configuration)item;
                    if (!JarFiles.isBuiltIn(configuration) && !jars.contains(jar = JarFiles.getJar(configuration))) {
                        jars.add(jar);
                    }
                    configurations.add(configuration);
                    continue;
                }
                if (!(item instanceof JarConfigurationModel) || jars.contains(item)) continue;
                jars.add((JarConfigurationModel)item);
            }
            Factory.when(model.seamcat_version()).thenReturn("VERSION");
            Factory.when(model.settings_format_version()).thenReturn(SettingsFormatVersionConstants.CURRENT_VERSION.getNumber());
            Marshaller marshaller = IOUtils.fromOutputStream(new FileOutputStream(file));
            marshaller.beginElement("seamcat");
            GenericTypeMarshaller.toElement(LibraryModel.class, marshaller, Factory.build(model));
            marshaller.endElement("seamcat");
            marshaller.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LibraryModel loadAndParseSettingsFile(File settingsFile, File prehistoricSettingsFile) {
        new SettingsMigrator().migrateAndShuffleSettingsFiles(settingsFile, prehistoricSettingsFile);
        try {
            if (settingsFile.exists()) {
                UnMarshaller unMarshaller = IOUtils.fromInputStream(new FileInputStream(settingsFile));
                unMarshaller.checkBeginElement("seamcat");
                LibraryModel libraryModel = GenericTypeMarshaller.fromElement(LibraryModel.class, unMarshaller);
                unMarshaller.checkEndElement("seamcat");
                unMarshaller.close();
                return libraryModel;
            }
        }
        catch (Exception e) {
            LOG.error("Error reading settings file", e);
        }
        return null;
    }
}

