/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.marshalling;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;
import org.seamcat.marshalling.WorkspaceResultMarshaller;
import org.seamcat.migration.workspace.WorkspaceFormatVersionConstants;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Workspace;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.engines.PartialSimulationResults;
import org.seamcat.model.plugin.UIPosition;
import org.seamcat.model.plugin.UITab;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.LinkResultSamples;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.workspace.InterferenceLinkUI;
import org.seamcat.model.workspace.SimulationControl;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.DistributionMarshaller;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.persistence.impl.LinkResultMarshaller;
import org.seamcat.persistence.impl.PluginMarshaller;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.JarFiles;
import org.seamcat.plugin.PostProcessingUIState;
import org.seamcat.simulation.result.ResultsImpl;
import org.seamcat.simulation.result.SimulationResultImpl;

public class WorkspaceMarshaller {
    private static final Logger LOG = Logger.getLogger(WorkspaceMarshaller.class);
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);

    public static void saveResultsToXmlStream(PartialSimulationResults results, Marshaller marshaller) {
        marshaller.beginElement("partialResults");
        WorkspaceResultMarshaller.saveToXmlStream(marshaller, results);
        marshaller.endElement("partialResults");
    }

    public static void saveResultsToXmlStream(SimulationResultImpl results, Marshaller marshaller) {
        marshaller.beginElement("workspaceResults");
        WorkspaceResultMarshaller.saveToXmlStream(marshaller, results.getSeamcatResults(), "SEAMCATResults", "SEAMCATResult");
        WorkspaceResultMarshaller.saveToXmlStream(marshaller, results.getEventProcessingResults(), "EventProcessingResults", "EventProcessingResult");
        if (results.getSamples() != null) {
            LinkResultSamples samples = results.getSamples();
            marshaller.beginElement("samples");
            marshaller.beginElement("victim");
            for (LinkResult result : samples.getVictimSystemSamples()) {
                LinkResultMarshaller.marshall(marshaller, result);
            }
            marshaller.endElement("victim");
            marshaller.beginElement("interferer");
            for (LinkResult result : samples.getInterferingSystemSamples()) {
                LinkResultMarshaller.marshall(marshaller, result);
            }
            marshaller.endElement("interferer");
            marshaller.endElement("samples");
        }
        marshaller.endElement("workspaceResults");
    }

    public static void toElement(Workspace model, Marshaller marshaller) {
        marshaller.beginElement("Workspace");
        marshaller.attribute("seamcat_version", STRINGLIST.getString("APPLICATION_TITLE"));
        marshaller.attribute("workspace_format_version", Integer.toString(WorkspaceFormatVersionConstants.CURRENT_VERSION.getNumber()));
        marshaller.attribute("workspace_reference", model.getName());
        marshaller.attribute("hasBeenCalculated", Boolean.toString(model.isHasBeenCalculated()));
        marshaller.attribute("victim", model.getVictimSystemId());
        HashSet<String> jars = new HashSet<String>();
        for (EventProcessingConfiguration eventProcessingConfiguration : model.getEventProcessingList()) {
            WorkspaceMarshaller.resolveExternalDependencies(jars, eventProcessingConfiguration);
        }
        ArrayList<Configuration> plugins = new ArrayList<Configuration>();
        for (SystemPlugin systemPlugin : model.getSystemPlugins()) {
            Class<? extends SystemModel> pluginUIClass = GenericTypeMarshaller.getPluginUIClass(systemPlugin);
            WorkspaceMarshaller.collectSystemPlugins(plugins, pluginUIClass, systemPlugin.getUI());
            if (JarFiles.isBuiltIn(systemPlugin)) continue;
            jars.add(JarFiles.getJarId(systemPlugin));
        }
        for (InterferenceLinkElement interferenceLinkElement : model.getInterferenceLinkUIs()) {
            WorkspaceMarshaller.collectSystemPlugins(plugins, InterferenceLinkUI.class, interferenceLinkElement.getSettings());
        }
        for (Configuration configuration : plugins) {
            WorkspaceMarshaller.resolveExternalDependencies(jars, configuration);
        }
        if (model.isHasBeenCalculated()) {
            SimulationResultImpl simulationResultImpl = model.getSimulationResults();
            for (Results group : simulationResultImpl.getSeamcatResults()) {
                WorkspaceMarshaller.handleGroup(jars, group);
            }
            for (Results group : simulationResultImpl.getEventProcessingResults()) {
                WorkspaceMarshaller.handleGroup(jars, group);
            }
        }
        if (!jars.isEmpty()) {
            marshaller.beginElement("embeddedJars");
            for (String string : jars) {
                WorkspaceMarshaller.addJar(string, marshaller);
            }
            marshaller.endElement("embeddedJars");
        }
        marshaller.beginElement("systems");
        for (SystemPlugin systemPlugin : model.getSystemPlugins()) {
            marshaller.beginElement("system");
            marshaller.attribute("classname", systemPlugin.getClass().getName());
            marshaller.attribute("location", JarFiles.getJarId(systemPlugin));
            Class<? extends SystemModel> sysClass = GenericTypeMarshaller.getPluginUIClass(systemPlugin);
            GenericTypeMarshaller.toElement(sysClass, marshaller, systemPlugin.getUI());
            marshaller.endElement("system");
        }
        marshaller.endElement("systems");
        marshaller.beginElement("links");
        for (InterferenceLinkElement interferenceLinkElement : model.getInterferenceLinkUIs()) {
            marshaller.beginElement("link");
            marshaller.attribute("id", interferenceLinkElement.getId());
            marshaller.attribute("interferingSystemId", interferenceLinkElement.getInterferingSystemId());
            marshaller.attribute("name", interferenceLinkElement.getName());
            GenericTypeMarshaller.toElement(InterferenceLinkUI.class, marshaller, interferenceLinkElement.getSettings());
            marshaller.endElement("link");
        }
        marshaller.endElement("links");
        marshaller.beginElement("frequencies");
        WorkspaceMarshaller.appendFrequency(marshaller, model.getVictimFrequency());
        for (Distribution distribution : model.getInterferingLinkFrequency()) {
            WorkspaceMarshaller.appendFrequency(marshaller, distribution);
        }
        marshaller.endElement("frequencies");
        marshaller.beginElement("plugin-configurations");
        if (!model.getEventProcessingList().isEmpty()) {
            for (EventProcessing eventProcessing : model.getEventProcessingList()) {
                PluginMarshaller.marshall(marshaller, eventProcessing, false);
            }
        }
        marshaller.endElement("plugin-configurations");
        marshaller.beginElement("simulationControl");
        GenericTypeMarshaller.toElement(SimulationControl.class, marshaller, model.getSimulationControl());
        marshaller.endElement("simulationControl");
        marshaller.endElement("Workspace");
    }

    private static void handleGroup(Set<String> jars, Results group) {
        ResultsImpl res = (ResultsImpl)group;
        for (PostProcessingUIState state : res.getPostProcessingState()) {
            for (Map.Entry<PanelDefinition<?>, Object> entry : state.get().entrySet()) {
                WorkspaceMarshaller.handle(jars, entry.getKey().getModelClass(), entry.getValue());
            }
        }
    }

    private static void appendFrequency(Marshaller marshaller, Distribution dist) {
        marshaller.beginElement("frequency");
        DistributionMarshaller.marshall(marshaller, dist);
        marshaller.endElement("frequency");
    }

    private static void collectSystemPlugins(List<Configuration> plugins, Class<?> clazz, Object model) {
        for (Method method : clazz.getDeclaredMethods()) {
            Object value;
            try {
                value = method.invoke(model, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (Configuration.class.isAssignableFrom(method.getReturnType())) {
                plugins.add((Configuration)value);
                continue;
            }
            if (method.getAnnotation(UITab.class) != null) {
                WorkspaceMarshaller.collectSystemPlugins(plugins, method.getReturnType(), value);
                continue;
            }
            if (method.getAnnotation(UIPosition.class) == null) continue;
            WorkspaceMarshaller.collectSystemPlugins(plugins, method.getReturnType(), value);
        }
    }

    private static void resolveExternalDependencies(Set<String> external, Configuration configuration) {
        if (!JarFiles.isBuiltIn(configuration)) {
            external.add(JarFiles.getJarId(configuration));
        }
        WorkspaceMarshaller.handle(external, configuration.getModelClass(), configuration.getModel());
    }

    private static void handle(Set<String> external, Class<?> modelClass, Object model) {
        for (Method method : modelClass.getDeclaredMethods()) {
            Class<?> type = method.getReturnType();
            if (!PropagationModel.class.isAssignableFrom(type) && !AntennaGain.class.isAssignableFrom(type)) continue;
            try {
                Configuration inner = (Configuration)method.invoke(model, new Object[0]);
                WorkspaceMarshaller.resolveExternalDependencies(external, inner);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void addJar(String jarId, Marshaller marshaller) {
        JarConfigurationModel jar = JarFiles.getJarConfiguration(jarId);
        if (jar != null) {
            PluginMarshaller.marshall(jar, marshaller, false);
        } else {
            LOG.warn("Jar file not found '" + jarId + "'");
        }
    }

    public static Workspace unmarshall(final UnMarshaller unMarshaller) {
        final Workspace model = new Workspace();
        model.setName(unMarshaller.attribute("workspace_reference"));
        model.setVictimSystemId(unMarshaller.attribute("victim"));
        model.setHasBeenCalculated(Boolean.valueOf(unMarshaller.attribute("hasBeenCalculated")));
        unMarshaller.processOptionalWrappedElementSequence("embeddedJars", "jar", new Processor(){

            @Override
            public void process() {
                JarConfigurationModel jarModel = PluginMarshaller.fromElement(unMarshaller);
                JarFiles.addJarConfiguration(jarModel);
            }
        });
        model.setSystemPlugins(new ArrayList<SystemPlugin>());
        unMarshaller.processWrappedElementSequence("systems", "system", new Processor(){

            @Override
            public void process() {
                String location = unMarshaller.attribute("location");
                JarConfigurationModel jar = JarFiles.getJarConfiguration(location);
                try {
                    SystemPlugin plugin = jar.getSystemPluginClass(unMarshaller.attribute("classname")).newInstance();
                    Class<? extends SystemModel> uiClass = GenericTypeMarshaller.getPluginUIClass(plugin);
                    SystemModel ui = GenericTypeMarshaller.fromElement(uiClass, unMarshaller);
                    plugin.setUI(ui);
                    model.getSystemPlugins().add(plugin);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error reading class", e);
                }
            }
        });
        model.setInterferenceLinkUIs(new ArrayList<InterferenceLinkElement>());
        unMarshaller.processWrappedElementSequence("links", "link", new Processor(){

            @Override
            public void process() {
                String id = unMarshaller.attribute("id");
                String sysId = unMarshaller.attribute("interferingSystemId");
                String name = unMarshaller.attribute("name");
                InterferenceLinkUI ui = GenericTypeMarshaller.fromElement(InterferenceLinkUI.class, unMarshaller);
                model.getInterferenceLinkUIs().add(new InterferenceLinkElement(id, sysId, name, ui));
            }
        });
        final boolean[] first = new boolean[]{true};
        unMarshaller.processWrappedElementSequence("frequencies", "frequency", new Processor(){

            @Override
            public void process() {
                Distribution distribution = DistributionMarshaller.unMarshall(unMarshaller);
                if (first[0]) {
                    model.setVictimFrequency(distribution);
                    first[0] = false;
                } else {
                    model.getInterferingLinkFrequency().add(distribution);
                }
            }
        });
        final ArrayList<EventProcessingConfiguration> configurations = new ArrayList<EventProcessingConfiguration>();
        unMarshaller.processWrappedElementSequence("plugin-configurations", "pluginConfiguration", new Processor(){

            @Override
            public void process() {
                EventProcessingConfiguration configuration = (EventProcessingConfiguration)PluginMarshaller.unMarshallPlugin(unMarshaller, true);
                if (configuration != null) {
                    configurations.add(configuration);
                }
            }
        });
        if (!configurations.isEmpty()) {
            model.setEventProcessingList(configurations);
        }
        unMarshaller.checkBeginElement("simulationControl");
        model.setSimulationControl(GenericTypeMarshaller.fromElement(SimulationControl.class, unMarshaller));
        unMarshaller.checkEndElement("simulationControl");
        return model;
    }
}

