/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.marshalling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.marshalling.IndexedValueDefMarshaller;
import org.seamcat.model.Scenario;
import org.seamcat.model.engines.IndexedValueDef;
import org.seamcat.model.engines.PartialSimulationResults;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.ValueDefinition;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.IntegerResultType;
import org.seamcat.model.types.result.LongResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.StringResultType;
import org.seamcat.model.types.result.VectorResult;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.FunctionMarshaller;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.persistence.impl.LinkResultMarshaller;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.JarFiles;
import org.seamcat.plugin.PostProcessingUIState;
import org.seamcat.simulation.result.ResultsImpl;

public class WorkspaceResultMarshaller {
    public static void saveToXmlStream(Marshaller marshaller, PartialSimulationResults results) {
        Iterator<Map.Entry<IndexedValueDef<VectorDef>, Object[]>> value;
        Integer id;
        marshaller.attribute("simulationSeed", Long.toString(results.getSimulationSeed()));
        marshaller.attribute("beginSimulationTime", Long.toString(results.getBeginSimulationTime()));
        marshaller.attribute("beginEventTime", Long.toString(results.getBeginEventTime()));
        marshaller.attribute("events", Integer.toString(results.getEvents()));
        marshaller.attribute("groups", Integer.toString(results.getGroupCount()));
        int idCounter = 0;
        HashMap<IndexedValueDef, Integer> vectorIdMap = new HashMap<IndexedValueDef, Integer>();
        marshaller.beginElement("definitions");
        for (IndexedValueDef<VectorDef> indexedValueDef : results.getVectorResults().keySet()) {
            idCounter = IndexedValueDefMarshaller.addValueDef(indexedValueDef, idCounter, vectorIdMap, marshaller, "vector");
        }
        for (IndexedValueDef<VectorDef> indexedValueDef : results.getSampleResults().keySet()) {
            idCounter = IndexedValueDefMarshaller.addValueDef(indexedValueDef, idCounter, vectorIdMap, marshaller, "sample");
        }
        for (IndexedValueDef<ValueDefinition> indexedValueDef : results.getBarCharts().keySet()) {
            idCounter = IndexedValueDefMarshaller.addValueDef(indexedValueDef, idCounter, vectorIdMap, marshaller, "barChart");
        }
        for (IndexedValueDef<ValueDefinition> indexedValueDef : results.getScatterPlots().keySet()) {
            idCounter = IndexedValueDefMarshaller.addValueDef(indexedValueDef, idCounter, vectorIdMap, marshaller, "scatter");
        }
        for (IndexedValueDef<ValueDefinition> indexedValueDef : results.getFunctions().keySet()) {
            idCounter = IndexedValueDefMarshaller.addValueDef(indexedValueDef, idCounter, vectorIdMap, marshaller, "function");
        }
        for (IndexedValueDef<ValueDefinition> indexedValueDef : results.getSingleValues().keySet()) {
            idCounter = IndexedValueDefMarshaller.addValueDef(indexedValueDef, idCounter, vectorIdMap, marshaller, "single");
        }
        for (IndexedValueDef<ValueDefinition> indexedValueDef : results.getLinkResults().keySet()) {
            idCounter = IndexedValueDefMarshaller.addValueDef(indexedValueDef, idCounter, vectorIdMap, marshaller, "linkResult");
        }
        marshaller.endElement("definitions");
        marshaller.beginElement("preSimulations");
        marshaller.beginElement("pre");
        WorkspaceResultMarshaller.saveResultTypes(marshaller, results.getVictimResults());
        marshaller.endElement("pre");
        for (Results results2 : results.getResults()) {
            marshaller.beginElement("pre");
            WorkspaceResultMarshaller.saveResultTypes(marshaller, results2);
            marshaller.endElement("pre");
        }
        marshaller.endElement("preSimulations");
        marshaller.beginElement("unordered");
        for (Map.Entry entry : results.getBarCharts().entrySet()) {
            if (!vectorIdMap.containsKey(entry.getKey())) continue;
            id = (Integer)vectorIdMap.get(entry.getKey());
            value = (List)entry.getValue();
            marshaller.beginElement("pre");
            marshaller.attribute("id", Integer.toString(id));
            WorkspaceResultMarshaller.writeValues(marshaller, (List<BarChartValue>)((Object)value));
            marshaller.endElement("pre");
        }
        for (Map.Entry entry : results.getScatterPlots().entrySet()) {
            if (!vectorIdMap.containsKey(entry.getKey())) continue;
            id = (Integer)vectorIdMap.get(entry.getKey());
            List plot = (List)entry.getValue();
            marshaller.beginElement("pre");
            marshaller.attribute("id", Integer.toString(id));
            WorkspaceResultMarshaller.writePoints(marshaller, plot);
            marshaller.endElement("pre");
        }
        for (Map.Entry entry : results.getLinkResults().entrySet()) {
            if (!vectorIdMap.containsKey(entry.getKey())) continue;
            id = (Integer)vectorIdMap.get(entry.getKey());
            List links = (List)entry.getValue();
            marshaller.beginElement("pre");
            marshaller.attribute("id", Integer.toString(id));
            marshaller.beginElement("linkResults");
            for (LinkResult link : links) {
                LinkResultMarshaller.marshall(marshaller, link);
            }
            marshaller.endElement("linkResults");
            marshaller.endElement("pre");
        }
        for (Map.Entry entry : results.getSingleValues().entrySet()) {
            if (!vectorIdMap.containsKey(entry.getKey())) continue;
            id = (Integer)vectorIdMap.get(entry.getKey());
            marshaller.beginElement("pre");
            marshaller.attribute("id", Integer.toString(id));
            value = (SingleValueTypes)entry.getValue();
            WorkspaceResultMarshaller.single(marshaller, (SingleValueTypes)((Object)value));
            marshaller.endElement("pre");
        }
        for (Map.Entry entry : results.getFunctions().entrySet()) {
            if (!vectorIdMap.containsKey(entry.getKey())) continue;
            id = (Integer)vectorIdMap.get(entry.getKey());
            marshaller.beginElement("pre");
            marshaller.attribute("id", Integer.toString(id));
            WorkspaceResultMarshaller.marshallFunction(marshaller, (Function)entry.getValue());
            marshaller.endElement("pre");
        }
        marshaller.endElement("unordered");
        List<Integer> unprocessed = results.getUnprocessed();
        Integer n = unprocessed.get(0);
        marshaller.beginElement("ordered");
        for (int i = 0; i < n; ++i) {
            marshaller.beginElement("preValues");
            marshaller.attribute("number", Integer.toString(i));
            for (Map.Entry<IndexedValueDef<VectorDef>, double[]> entry : results.getVectorResults().entrySet()) {
                if (!vectorIdMap.containsKey(entry.getKey())) continue;
                int id2 = (Integer)vectorIdMap.get(entry.getKey());
                double val = entry.getValue()[i];
                WorkspaceResultMarshaller.addValue(marshaller, id2, Double.toString(val));
            }
            for (Map.Entry<IndexedValueDef<VectorDef>, Object[]> entry : results.getSampleResults().entrySet()) {
                if (!vectorIdMap.containsKey(entry.getKey())) continue;
                int id2 = (Integer)vectorIdMap.get(entry.getKey());
                List val = ((List[])entry.getValue())[i];
                if (val == null) continue;
                WorkspaceResultMarshaller.addValue(marshaller, id2, val.toString());
            }
            marshaller.endElement("preValues");
        }
        marshaller.endElement("ordered");
        marshaller.beginElement("victimSamples");
        for (LinkResult result : results.getVictimSamples()) {
            LinkResultMarshaller.marshall(marshaller, result);
        }
        marshaller.endElement("victimSamples");
        marshaller.beginElement("interfererSamples");
        for (LinkResult result : results.getInterfererSamples()) {
            LinkResultMarshaller.marshall(marshaller, result);
        }
        marshaller.endElement("interfererSamples");
    }

    private static void marshallFunction(Marshaller marshaller, Function function) {
        if (function instanceof MaskFunction) {
            FunctionMarshaller.marshall(marshaller, (MaskFunction)function);
        } else {
            FunctionMarshaller.marshall(marshaller, function);
        }
    }

    private static Function unMarshalFunction(UnMarshaller un) {
        Function function = un.peekNextElement("ConstantFunction") || un.peekNextElement("discretefunction") ? FunctionMarshaller.unMarshallFunction(un) : FunctionMarshaller.unMarshall(un);
        return function;
    }

    private static void addValue(Marshaller marshaller, int id, String value) {
        marshaller.beginElement("pre");
        marshaller.attribute("id", Integer.toString(id));
        marshaller.attribute("value", value);
        marshaller.endElement("pre");
    }

    static void saveToXmlStream(Marshaller marshaller, List<Results> results, String group, String name) {
        marshaller.beginElement(group);
        for (Results result : results) {
            marshaller.beginElement(name);
            WorkspaceResultMarshaller.saveResultTypes(marshaller, result);
            marshaller.endElement(name);
        }
        marshaller.endElement(group);
    }

    private static void saveResultTypes(Marshaller marshaller, Results result) {
        marshaller.attribute("id", result.getId());
        marshaller.attribute("name", result.getName());
        ResultsImpl results = (ResultsImpl)result;
        if (results != null) {
            List<PostProcessingUIState> list;
            List<FunctionResultType> list2;
            List<BarChartResultType> list3;
            List<ScatterDiagramResultType> list4;
            List<VectorResultType> list5;
            Map<String, List<VectorResultType>> map;
            Map<String, List<SingleValueTypes>> sGroups;
            List<SingleValueTypes> sTypes = results.nonGroupedSingleValues();
            if (sTypes != null && sTypes.size() > 0) {
                marshaller.beginElement("SingleValues");
                for (SingleValueTypes singleValueTypes : sTypes) {
                    WorkspaceResultMarshaller.single(marshaller, singleValueTypes);
                }
                marshaller.endElement("SingleValues");
            }
            if ((sGroups = results.allSingleValueGroups()) != null && !sGroups.isEmpty()) {
                marshaller.beginElement("SingleGroups");
                for (Map.Entry<String, List<SingleValueTypes>> entry : sGroups.entrySet()) {
                    marshaller.beginElement("SingleGroup");
                    marshaller.attribute("name", entry.getKey());
                    for (SingleValueTypes singleValueTypes : entry.getValue()) {
                        WorkspaceResultMarshaller.single(marshaller, singleValueTypes);
                    }
                    marshaller.endElement("SingleGroup");
                }
                marshaller.endElement("SingleGroups");
            }
            if ((map = results.allGroups()) != null && map.size() > 0) {
                marshaller.beginElement("VectorGroups");
                for (Map.Entry<String, List<VectorResultType>> entry : map.entrySet()) {
                    marshaller.beginElement("VectorGroup");
                    List<VectorResultType> list6 = entry.getValue();
                    marshaller.attribute("name", entry.getKey());
                    marshaller.attribute("unit", list6.get(0).getUnit());
                    for (VectorResultType vectorResultType : list6) {
                        marshaller.beginElement("NamedVector");
                        marshaller.attribute("name", vectorResultType.getName());
                        WorkspaceResultMarshaller.writeVector(marshaller, vectorResultType.getValue());
                        marshaller.endElement("NamedVector");
                    }
                    marshaller.endElement("VectorGroup");
                }
                marshaller.endElement("VectorGroups");
            }
            if ((list5 = results.nonGrouped()) != null && list5.size() > 0) {
                marshaller.beginElement("VectorValues");
                for (VectorResultType vectorResultType : list5) {
                    marshaller.beginElement("Vector");
                    marshaller.attribute("name", vectorResultType.getName());
                    marshaller.attribute("unit", vectorResultType.getUnit());
                    WorkspaceResultMarshaller.writeVector(marshaller, vectorResultType.getValue());
                    marshaller.endElement("Vector");
                }
                marshaller.endElement("VectorValues");
            }
            if ((list4 = results.getScatterDiagramResultTypes()) != null && list4.size() > 0) {
                marshaller.beginElement("ScatterPlots");
                for (ScatterDiagramResultType scatterDiagramResultType : list4) {
                    marshaller.beginElement("Scatter");
                    marshaller.attribute("title", scatterDiagramResultType.def().name());
                    marshaller.attribute("xLabel", scatterDiagramResultType.def().unit());
                    marshaller.attribute("yLabel", scatterDiagramResultType.def().yUnit());
                    WorkspaceResultMarshaller.writePoints(marshaller, (List<Point2D>)scatterDiagramResultType.value());
                    marshaller.endElement("Scatter");
                }
                marshaller.endElement("ScatterPlots");
            }
            if ((list3 = results.getBarChartResultTypes()) != null && list3.size() > 0) {
                marshaller.beginElement("BarCharts");
                for (BarChartResultType barChartResultType : list3) {
                    marshaller.beginElement("BarChart");
                    marshaller.attribute("title", barChartResultType.def().name());
                    marshaller.attribute("xLabel", barChartResultType.def().unit());
                    marshaller.attribute("yLabel", barChartResultType.def().yUnit());
                    WorkspaceResultMarshaller.writeValues(marshaller, (List<BarChartValue>)barChartResultType.value());
                    marshaller.endElement("BarChart");
                }
                marshaller.endElement("BarCharts");
            }
            if ((list2 = results.getFunctionResultTypes()) != null && list2.size() > 0) {
                marshaller.beginElement("Functions");
                for (FunctionResultType type : list2) {
                    marshaller.beginElement("Function");
                    marshaller.attribute("name", type.def().name());
                    marshaller.attribute("domainUnit", type.def().unit());
                    marshaller.attribute("rangeUnit", type.def().yUnit());
                    WorkspaceResultMarshaller.marshallFunction(marshaller, type.value());
                    marshaller.endElement("Function");
                }
                marshaller.endElement("Functions");
            }
            if ((list = results.getPostProcessingState()) != null && !list.isEmpty()) {
                marshaller.beginElement("PostProcessingUIs");
                for (PostProcessingUIState ppUI : list) {
                    marshaller.beginElement("PostProcessingUI");
                    marshaller.attribute("id", ppUI.getId());
                    for (Map.Entry<PanelDefinition<?>, Object> entry : ppUI.get().entrySet()) {
                        marshaller.beginElement("model");
                        marshaller.attribute("name", entry.getKey().getName());
                        marshaller.attribute("class", entry.getKey().getModelClass().getName());
                        GenericTypeMarshaller.toElement(entry.getKey().getModelClass(), marshaller, entry.getValue());
                        marshaller.endElement("model");
                    }
                    marshaller.endElement("PostProcessingUI");
                }
                marshaller.endElement("PostProcessingUIs");
            }
        }
    }

    private static void single(Marshaller marshaller, SingleValueTypes value) {
        if (value instanceof DoubleResultType) {
            WorkspaceResultMarshaller.writeSingleValue(marshaller, value, Double.toString((Double)value.value()), "double");
        } else if (value instanceof IntegerResultType) {
            WorkspaceResultMarshaller.writeSingleValue(marshaller, value, Integer.toString((Integer)value.value()), "int");
        } else if (value instanceof StringResultType) {
            WorkspaceResultMarshaller.writeSingleValue(marshaller, value, (String)value.value(), "string");
        } else if (value instanceof LongResultType) {
            WorkspaceResultMarshaller.writeSingleValue(marshaller, value, Long.toString((Long)value.value()), "longInt");
        }
    }

    private static void writeSingleValue(Marshaller marshaller, SingleValueTypes single, String value, String type) {
        marshaller.beginElement("Single");
        marshaller.attribute("name", single.def().name());
        marshaller.attribute("value", value);
        marshaller.attribute("unit", single.def().unit());
        marshaller.attribute("type", type);
        marshaller.endElement("Single");
    }

    private static void writeVector(Marshaller marshaller, VectorResult vector) {
        marshaller.beginElement("values");
        for (double d : vector.asArray()) {
            marshaller.beginElement("value");
            marshaller.attribute("v", Double.toString(d));
            marshaller.endElement("value");
        }
        marshaller.endElement("values");
    }

    private static void writePoints(Marshaller marshaller, List<Point2D> points) {
        marshaller.beginElement("points");
        for (Point2D point : points) {
            marshaller.beginElement("point");
            marshaller.attribute("x", Double.toString(point.getX()));
            marshaller.attribute("y", Double.toString(point.getY()));
            marshaller.endElement("point");
        }
        marshaller.endElement("points");
    }

    private static void writeValues(Marshaller marshaller, List<BarChartValue> values) {
        marshaller.beginElement("values");
        for (BarChartValue value : values) {
            marshaller.beginElement("value");
            marshaller.attribute("name", value.getName());
            marshaller.attribute("value", Double.toString(value.getValue()));
            marshaller.endElement("value");
        }
        marshaller.endElement("values");
    }

    public static PartialSimulationResults loadFromXmlStream(final Scenario scenario, final UnMarshaller unMarshaller) {
        unMarshaller.checkBeginElement("partialResults");
        int events = Integer.parseInt(unMarshaller.attribute("events"));
        int groups = Integer.parseInt(unMarshaller.attribute("groups"));
        final PartialSimulationResults partial = new PartialSimulationResults(events, groups);
        partial.setSimulationSeed(Long.parseLong(unMarshaller.attribute("simulationSeed")));
        partial.setBeginEventTime(Long.parseLong(unMarshaller.attribute("beginEventTime")));
        partial.setBeginSimulationTime(Long.parseLong(unMarshaller.attribute("beginSimulationTime")));
        unMarshaller.checkBeginElement("definitions");
        final HashMap valueDefMap = new HashMap();
        final HashMap indexMap = new HashMap();
        final HashMap typeMap = new HashMap();
        unMarshaller.processSequence("valueDef", new Processor(){

            @Override
            public void process() {
                IndexedValueDefMarshaller.readValueDef(partial, valueDefMap, indexMap, typeMap, unMarshaller);
            }
        });
        unMarshaller.checkEndElement("definitions");
        unMarshaller.checkBeginElement("preSimulations");
        unMarshaller.checkBeginElement("pre");
        String id = unMarshaller.attribute("id");
        ArrayList<Results> rList = new ArrayList<Results>();
        WorkspaceResultMarshaller.loadResult(scenario, id, unMarshaller, rList);
        unMarshaller.checkEndElement("pre");
        partial.setVictimResults((Results)rList.get(0));
        rList.clear();
        while (unMarshaller.peekNextElement("pre")) {
            unMarshaller.checkBeginElement("pre");
            id = unMarshaller.attribute("id");
            WorkspaceResultMarshaller.loadResult(scenario, id, unMarshaller, rList);
            unMarshaller.checkEndElement("pre");
        }
        LinkedHashMap<InterferenceLink, Results> iPre = new LinkedHashMap<InterferenceLink, Results>();
        List<InterferenceLink> interferenceLinks = scenario.getInterferenceLinks();
        for (int i = 0; i < interferenceLinks.size(); ++i) {
            InterferenceLink link = interferenceLinks.get(i);
            iPre.put(link, (Results)rList.get(i));
        }
        partial.setResults(iPre);
        unMarshaller.checkEndElement("preSimulations");
        unMarshaller.processWrappedElementSequence("unordered", "pre", new Processor(){

            @Override
            public void process() {
                String type;
                int id = Integer.parseInt(unMarshaller.attribute("id"));
                IndexedValueDef def = (IndexedValueDef)valueDefMap.get(id);
                switch (type = (String)typeMap.get(id)) {
                    case "barChart": {
                        ArrayList barValues = new ArrayList();
                        WorkspaceResultMarshaller.readValues(unMarshaller, barValues);
                        ((LinkedHashMap)indexMap.get(id)).put(def, barValues);
                        break;
                    }
                    case "scatter": {
                        ArrayList scatter = new ArrayList();
                        WorkspaceResultMarshaller.readPointList(unMarshaller, scatter);
                        ((LinkedHashMap)indexMap.get(id)).put(def, scatter);
                        break;
                    }
                    case "linkResult": {
                        final ArrayList links = new ArrayList();
                        unMarshaller.processWrappedElementSequence("linkResults", "linkResult", new Processor(){

                            @Override
                            public void process() {
                                links.add(LinkResultMarshaller.unMarshall(unMarshaller));
                            }
                        });
                        ((LinkedHashMap)indexMap.get(id)).put(def, links);
                        break;
                    }
                    case "single": {
                        String group = null;
                        if (def.getDef().isGrouped()) {
                            group = def.getDef().group();
                        }
                        SingleValueTypes single = WorkspaceResultMarshaller.parseSingle(group, unMarshaller);
                        ((LinkedHashMap)indexMap.get(id)).put(def, single);
                        break;
                    }
                    case "function": {
                        ((LinkedHashMap)indexMap.get(id)).put(def, WorkspaceResultMarshaller.unMarshalFunction(unMarshaller));
                    }
                }
            }
        });
        final int[] lastIdx = new int[]{0};
        unMarshaller.processWrappedElementSequence("ordered", "preValues", new Processor(){

            @Override
            public void process() {
                int number;
                lastIdx[0] = number = Integer.parseInt(unMarshaller.attribute("number"));
                unMarshaller.processSequence("pre", new Processor(){

                    @Override
                    public void process() {
                        String type;
                        int id = Integer.parseInt(unMarshaller.attribute("id"));
                        IndexedValueDef def = (IndexedValueDef)valueDefMap.get(id);
                        switch (type = (String)typeMap.get(id)) {
                            case "vector": {
                                if (!((LinkedHashMap)indexMap.get(id)).containsKey(def)) {
                                    ((LinkedHashMap)indexMap.get(id)).put(def, new double[scenario.numberOfEvents()]);
                                }
                                ((double[])((LinkedHashMap)indexMap.get((Object)Integer.valueOf((int)id))).get((Object)def))[number] = Double.parseDouble(unMarshaller.attribute("value"));
                                break;
                            }
                            case "sample": {
                                if (!((LinkedHashMap)indexMap.get(id)).containsKey(def)) {
                                    ((LinkedHashMap)indexMap.get(id)).put(def, new List[scenario.numberOfEvents()]);
                                }
                                String value = unMarshaller.attribute("value");
                                String[] split = value.substring(1, value.length() - 1).split(",");
                                ArrayList<Double> vals = new ArrayList<Double>();
                                for (String s : split) {
                                    vals.add(Double.parseDouble(s));
                                }
                                ((List[])((LinkedHashMap)indexMap.get((Object)Integer.valueOf((int)id))).get((Object)def))[number] = vals;
                            }
                        }
                    }
                });
            }
        });
        partial.setFirstUnprocessed(lastIdx[0] + 1);
        unMarshaller.processWrappedElementSequence("victimSamples", "linkResult", new Processor(){

            @Override
            public void process() {
                partial.getVictimSamples().add(LinkResultMarshaller.unMarshall(unMarshaller));
            }
        });
        unMarshaller.processWrappedElementSequence("interfererSamples", "linkResult", new Processor(){

            @Override
            public void process() {
                partial.getInterfererSamples().add(LinkResultMarshaller.unMarshall(unMarshaller));
            }
        });
        unMarshaller.checkEndElement("partialResults");
        return partial;
    }

    public static List<Results> loadFromXmlStream(final Scenario scenario, final UnMarshaller unMarshaller, String group, final String name) {
        final ArrayList<Results> results = new ArrayList<Results>();
        unMarshaller.processOptionalElement(group, new Processor(){

            @Override
            public void process() {
                unMarshaller.processSequence(name, new Processor(){

                    @Override
                    public void process() {
                        String id = unMarshaller.attribute("id");
                        WorkspaceResultMarshaller.loadResult(scenario, id, unMarshaller, results);
                    }
                });
            }
        });
        return results;
    }

    private static SingleValueTypes<?> parseSingle(String groupName, UnMarshaller un) {
        String type = un.attribute("type");
        UniqueValueDef def = groupName == null ? Factory.results().single(un.attribute("name"), un.attribute("unit")) : Factory.results().singleGroup(groupName, un.attribute("name"), un.attribute("unit"));
        SingleValueTypes<Double> res = null;
        if (type.equals("double")) {
            res = new DoubleResultType(def, new Double(un.attribute("value")));
        } else if (type.equals("int")) {
            res = new IntegerResultType(def, new Integer(un.attribute("value")));
        } else if (type.equals("string")) {
            res = new StringResultType(def, un.attribute("value"));
        } else if (type.equals("longInt")) {
            res = new LongResultType(def, new Long(un.attribute("value")));
        }
        return res;
    }

    private static void loadResult(final Scenario scenario, String id, final UnMarshaller unMarshaller, List<Results> results) {
        final ResultsImpl result = new ResultsImpl(id, unMarshaller.attribute("name"));
        unMarshaller.processOptionalWrappedElementSequence("SingleValues", "Single", new Processor(){

            @Override
            public void process() {
                result.getSingleValueTypes().add(WorkspaceResultMarshaller.parseSingle(null, unMarshaller));
            }
        });
        unMarshaller.processOptionalWrappedElementSequence("SingleGroups", "SingleGroup", new Processor(){

            @Override
            public void process() {
                final String groupName = unMarshaller.attribute("name");
                unMarshaller.processSequence("Single", new Processor(){

                    @Override
                    public void process() {
                        result.getSingleValueTypes().add(WorkspaceResultMarshaller.parseSingle(groupName, unMarshaller));
                    }
                });
            }
        });
        unMarshaller.processOptionalWrappedElementSequence("VectorGroups", "VectorGroup", new Processor(){

            @Override
            public void process() {
                final String group = unMarshaller.attribute("name");
                final String unit = unMarshaller.attribute("unit");
                unMarshaller.processSequence("NamedVector", new Processor(){

                    @Override
                    public void process() {
                        String name = unMarshaller.attribute("name");
                        VectorDef def = Factory.results().group(group, name, unit);
                        result.getVectorResultTypes().add(new VectorResultType(def, WorkspaceResultMarshaller.readVector(unMarshaller)));
                    }
                });
            }
        });
        unMarshaller.processOptionalWrappedElementSequence("VectorValues", "Vector", new Processor(){

            @Override
            public void process() {
                result.getVectorResultTypes().add(new VectorResultType(Factory.results().value(unMarshaller.attribute("name"), unMarshaller.attribute("unit")), WorkspaceResultMarshaller.readVector(unMarshaller)));
            }
        });
        unMarshaller.processOptionalWrappedElementSequence("ScatterPlots", "Scatter", new Processor(){

            @Override
            public void process() {
                ScatterDiagramResultType scatter = new ScatterDiagramResultType(Factory.results().multi(unMarshaller.attribute("title"), unMarshaller.attribute("xLabel"), unMarshaller.attribute("yLabel")));
                WorkspaceResultMarshaller.readPointList(unMarshaller, (List)scatter.value());
                result.getScatterDiagramResultTypes().add(scatter);
            }
        });
        unMarshaller.processOptionalWrappedElementSequence("BarCharts", "BarChart", new Processor(){

            @Override
            public void process() {
                BarChartResultType barChart = new BarChartResultType(Factory.results().multi(unMarshaller.attribute("title"), unMarshaller.attribute("xLabel"), unMarshaller.attribute("yLabel")));
                WorkspaceResultMarshaller.readValues(unMarshaller, (List)barChart.value());
                result.getBarChartResultTypes().add(barChart);
            }
        });
        unMarshaller.processOptionalWrappedElementSequence("Functions", "Function", new Processor(){

            @Override
            public void process() {
                UniqueValueDef def = Factory.results().function(unMarshaller.attribute("name"), unMarshaller.attribute("domainUnit"), unMarshaller.attribute("rangeUnit"));
                Function function = WorkspaceResultMarshaller.unMarshalFunction(unMarshaller);
                result.getFunctionResultTypes().add(new FunctionResultType(def, function));
            }
        });
        unMarshaller.processOptionalWrappedElementSequence("PostProcessingUIs", "PostProcessingUI", new Processor(){

            @Override
            public void process() {
                EventProcessing epp;
                String configId = unMarshaller.attribute("id");
                EventProcessingConfiguration conf = null;
                Iterator<EventProcessing> iterator = scenario.getEventProcessingList().iterator();
                while (iterator.hasNext() && !configId.equals((conf = (EventProcessingConfiguration)(epp = iterator.next())).getId())) {
                }
                final JarConfigurationModel jar = conf == null ? JarFiles.getJarConfiguration("BUILT-IN") : JarFiles.getJar(conf);
                final LinkedHashMap map = new LinkedHashMap();
                unMarshaller.processSequence("model", new Processor(){

                    @Override
                    public void process() {
                        PanelDefinition pc = new PanelDefinition(unMarshaller.attribute("name"), jar.loadClass(unMarshaller.attribute("class")));
                        Object uiModel = GenericTypeMarshaller.fromElement(pc.getModelClass(), unMarshaller);
                        map.put(pc, uiModel);
                    }
                });
                result.getPostProcessingState().add(new PostProcessingUIState(configId, map));
            }
        });
        results.add(result);
    }

    private static List<Double> readVector(final UnMarshaller unMarshaller) {
        final ArrayList<Double> vector = new ArrayList<Double>();
        unMarshaller.processWrappedElementSequence("values", "value", new Processor(){

            @Override
            public void process() {
                vector.add(new Double(unMarshaller.attribute("v")));
            }
        });
        return vector;
    }

    private static void readPointList(final UnMarshaller unMarshaller, final List<Point2D> target) {
        unMarshaller.processWrappedElementSequence("points", "point", new Processor(){

            @Override
            public void process() {
                target.add(new Point2D(Double.parseDouble(unMarshaller.attribute("x")), Double.parseDouble(unMarshaller.attribute("y"))));
            }
        });
    }

    private static void readValues(final UnMarshaller un, final List<BarChartValue> target) {
        un.processWrappedElementSequence("values", "value", new Processor(){

            @Override
            public void process() {
                target.add(new BarChartValue(un.attribute("name"), Double.parseDouble(un.attribute("value"))));
            }
        });
    }
}

