/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration;

import java.util.ArrayList;
import java.util.List;

public final class FormatVersion {
    private int number;

    public FormatVersion(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isLaterThan(FormatVersion other) {
        return this.number > other.number;
    }

    public static List<FormatVersion> rangeOf(FormatVersion start, FormatVersion end) {
        ArrayList<FormatVersion> versions = new ArrayList<FormatVersion>();
        for (int i = start.number; i <= end.number; ++i) {
            versions.add(new FormatVersion(i));
        }
        return versions;
    }

    public FormatVersion nextVersion() {
        return new FormatVersion(this.number + 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.number;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormatVersion other = (FormatVersion)obj;
        return this.number == other.number;
    }

    public String toString() {
        return "v" + this.number;
    }
}

