/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.batch;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.MigrationException;
import org.seamcat.migration.VersionExtractor;
import org.seamcat.migration.batch.BatchFormatVersionConstants;

public class BatchVersionExtractor
extends VersionExtractor {
    public static final String BATCH_FORMAT_VERSION = "batch_format_version";

    @Override
    public FormatVersion extractVersion(File file) {
        VersionExtractor.FileType fileType = this.determineFileType(file);
        switch (fileType) {
            case XML_FILE: {
                return this.extractVersionFromXmlFile(file);
            }
            case ZIP_FILE: {
                return this.extractVersionFromZippedFile(file);
            }
        }
        throw new MigrationException("File type " + (Object)((Object)fileType) + " not supported for " + file);
    }

    private FormatVersion extractVersionFromXmlFile(File file) {
        try {
            return this.extractVersionAttributesFromScenarioDocument(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private FormatVersion extractVersionAttributesFromScenarioDocument(InputStream inputStream) {
        try {
            return this.tryExtractVersionAttributesFromScenarioDocument(inputStream);
        }
        catch (XMLStreamException e) {
            throw new MigrationException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new MigrationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormatVersion tryExtractVersionAttributesFromScenarioDocument(InputStream inputStream) throws XMLStreamException, FactoryConfigurationError {
        XMLEventReader eventReader = null;
        try {
            eventReader = XMLInputFactory.newFactory().createXMLEventReader(inputStream);
            while (eventReader.peek() != null && !eventReader.peek().isStartElement()) {
                eventReader.next();
            }
            if (eventReader.peek() == null) {
                throw new MigrationException("Document element not found");
            }
            StartElement documentElement = eventReader.peek().asStartElement();
            Attribute version = documentElement.getAttributeByName(new QName(BATCH_FORMAT_VERSION));
            if (version == null) {
                FormatVersion formatVersion = BatchFormatVersionConstants.PREHISTORIC;
                return formatVersion;
            }
            FormatVersion formatVersion = new FormatVersion(Integer.parseInt(version.getValue()));
            return formatVersion;
        }
        finally {
            IOUtils.closeQuietly(eventReader);
        }
    }

    private FormatVersion extractVersionFromZippedFile(File file) {
        FormatVersion formatVersion;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry scenarioEntry = zipFile.getEntry("batch.xml");
            if (scenarioEntry == null) {
                throw new MigrationException("Scenario entry not found in workspace zip file");
            }
            InputStream scenarioInputStream = zipFile.getInputStream(scenarioEntry);
            formatVersion = this.extractVersionAttributesFromScenarioDocument(scenarioInputStream);
        }
        catch (Exception e) {
            try {
                throw new MigrationException("Failed extracting version from workspace zip file: " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(zipFile);
        return formatVersion;
    }
}

