/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.seamcat.migration.workspace.Rule011PropagationModelWorkspaceMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule004PropagationModelSettingsMigration
implements FileMigration {
    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List pms = context.selectNodes("//PropagationModel");
        for (Object o : pms) {
            Rule011PropagationModelWorkspaceMigration.migratePropagationModel((Element)o, document);
        }
        List library = context.selectNodes("//library");
        if (library.size() > 0) {
            Element lib = (Element)library.get(0);
            Element configurations = document.createElement("plugin-configurations");
            lib.appendChild(configurations);
        }
        this.updateVersion(document);
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(3);
    }
}

