/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.seamcat.migration.workspace.Rule025AntennaPluginWorkspaceMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule009AntennaPluginSettingsMigration
implements FileMigration {
    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        Element configurations;
        JXPathContext context = JXPathContext.newContext(document);
        List antennas = context.selectNodes("//antenna");
        for (Object o : antennas) {
            Element element = (Element)o;
            Rule025AntennaPluginWorkspaceMigration.migrateAntenna(document, element);
        }
        List configurationsList = context.selectNodes("//pluginConfigurations");
        if (configurationsList.isEmpty()) {
            Node library = document.getElementsByTagName("library").item(0);
            configurations = document.createElement("pluginConfigurations");
            library.appendChild(configurations);
        } else {
            configurations = (Element)configurationsList.get(0);
        }
        List rootAntennas = context.selectNodes("//antennas");
        if (rootAntennas.size() > 0) {
            Element root = (Element)rootAntennas.get(0);
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element conf = (Element)childNodes.item(i).getFirstChild();
                childNodes.item(i).removeChild(conf);
                configurations.appendChild(conf);
            }
            root.getParentNode().removeChild(root);
        }
        this.updateVersion(document);
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(8);
    }
}

