/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.seamcat.migration.workspace.Rule051UserDefinedDRSSWorkspaceMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule019UserDefinedDRSSSettingsMigration
implements FileMigration {
    private Map<String, Element> genericSystems = new HashMap<String, Element>();

    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List syss = context.selectNodes("//systems/composite");
        for (Object e : syss) {
            Element s = (Element)e;
            if (!s.getAttribute("class").equals("org.seamcat.model.systems.generic.SystemModelGeneric")) continue;
            String id = ((Element)s.getParentNode()).getAttribute("id");
            this.genericSystems.put(id, s);
        }
        for (Map.Entry entry : this.genericSystems.entrySet()) {
            Element system = (Element)entry.getValue();
            Element path = (Element)system.getElementsByTagName("path").item(0).getFirstChild();
            Element drss = document.createElement("drss");
            path.appendChild(drss);
            Rule051UserDefinedDRSSWorkspaceMigration.appendDefault(document, drss);
        }
        this.updateVersion(document);
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(18);
    }
}

