/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.seamcat.migration.workspace.Rule052TrafficAndCorrelationModeWorkspaceMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule020TrafficAndDensitySettingsMigration
implements FileMigration {
    private Map<String, Element> genericSystems = new HashMap<String, Element>();

    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List sList = context.selectNodes("//composite");
        for (Object o : sList) {
            Element composite = (Element)o;
            if (!composite.getAttribute("class").equals("org.seamcat.model.systems.generic.SystemModelGeneric")) continue;
            Node path = (Node)JXPathContext.newContext(context, composite).selectSingleNode("//path/composite");
            Element density = Rule052TrafficAndCorrelationModeWorkspaceMigration.getDefaultDensity(document);
            path.appendChild(density);
        }
        this.updateVersion(document);
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(19);
    }
}

