/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule021CompositeMarshallerSettingsMigration
implements FileMigration {
    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List cList = context.selectNodes("//composite");
        ArrayList<Element> destructive = new ArrayList<Element>();
        for (Object o : cList) {
            Element composite = (Element)o;
            Node parent = composite.getParentNode();
            String name = parent.getNodeName();
            if (name.equals("systems")) {
                destructive.add(composite);
                continue;
            }
            if (name.equals("receivers")) {
                destructive.add(composite);
                continue;
            }
            if (name.equals("transmitters")) {
                destructive.add(composite);
                continue;
            }
            while (composite.hasChildNodes()) {
                Node child = composite.getFirstChild();
                composite.removeChild(child);
                parent.appendChild(child);
            }
            parent.removeChild(composite);
        }
        for (Element composite : destructive) {
            Node parent = composite.getParentNode();
            String name = parent.getNodeName();
            if (name.equals("systems")) {
                Element system = document.createElement("system");
                system.setAttribute("class", composite.getAttribute("class"));
                this.moveAllChildrenAndReplace(parent, composite, system);
                continue;
            }
            if (name.equals("receivers")) {
                Element receiver = document.createElement("receiver");
                this.moveAllChildrenAndReplace(parent, composite, receiver);
                continue;
            }
            if (!name.equals("transmitters")) continue;
            Element transmitter = document.createElement("transmitter");
            this.moveAllChildrenAndReplace(parent, composite, transmitter);
        }
        this.updateVersion(document);
    }

    private void moveAllChildrenAndReplace(Node parent, Element composite, Element newElement) {
        while (composite.hasChildNodes()) {
            Node child = composite.getFirstChild();
            composite.removeChild(child);
            newElement.appendChild(child);
        }
        parent.removeChild(composite);
        parent.appendChild(newElement);
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(20);
    }
}

