/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.MigrationException;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.w3c.dom.Document;

public abstract class AbstractScenarioMigration
implements FileMigration {
    private List<MigrationIssue> migrationIssues;

    protected List<MigrationIssue> getMigrationIssues() {
        return this.migrationIssues;
    }

    @Override
    public void migrate(File originalZipFile, File migratedZipFile, List<MigrationIssue> migrationIssues) {
        this.migrationIssues = migrationIssues;
        try {
            ZipFile zipFile = new ZipFile(originalZipFile);
            ZipOutputStream resultStream = new ZipOutputStream(new FileOutputStream(migratedZipFile));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                Document document;
                ZipEntry entry = entries.nextElement();
                resultStream.putNextEntry(new ZipEntry(entry.getName()));
                if (entry.getName().equals("scenario.xml")) {
                    document = XmlUtils.parse(zipFile.getInputStream(entry));
                    this.migrateScenarioDocument(document);
                    XmlUtils.write(document, resultStream);
                    continue;
                }
                if (entry.getName().equals("results.xml")) {
                    document = XmlUtils.parse(zipFile.getInputStream(entry));
                    this.migrateResultsDocument(document);
                    XmlUtils.write(document, resultStream);
                    continue;
                }
                IOUtils.copy(zipFile.getInputStream(entry), (OutputStream)resultStream);
            }
            resultStream.close();
            zipFile.close();
        }
        catch (IOException e) {
            throw new MigrationException(e);
        }
    }

    abstract void migrateScenarioDocument(Document var1);

    abstract void migrateResultsDocument(Document var1);
}

