/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FileUtils;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.MigrationException;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.persistence.impl.XmlEventFactory;

public class Rule006XmlToZipFileWorkspaceMigration
implements FileMigration {
    private static final Set<String> SCENARIO_TOP_LEVEL_ELEMENT_NAMES = new HashSet<String>(Arrays.asList("InterferenceLink", "VictimSystemLink", "Control", "postprocessing-plugins"));
    private static final Set<String> RESULTS_TOP_LEVEL_ELEMENT_NAMES = new HashSet<String>(Arrays.asList("iceConfigurations", "CDMAResults", "Signals", "Correlations", "CoverageRadiuses"));

    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        try {
            this.tryMigrate(originalFile, migratedFile);
        }
        catch (Exception e) {
            throw new MigrationException("Failed to migrate XML workspac e to ZIP workspace", e);
        }
    }

    public void tryMigrate(File originalFile, File migratedFile) throws Exception {
        File scenarioFile = IOUtils.createTempFile();
        File resultsFile = IOUtils.createTempFile();
        boolean hasResults = this.splitOriginalIntoScenarioAndResults(originalFile, scenarioFile, resultsFile);
        this.createZipFileFromScenarioAndResultsFiles(migratedFile, scenarioFile, resultsFile, hasResults);
        scenarioFile.delete();
        resultsFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean splitOriginalIntoScenarioAndResults(File originalFile, File scenarioFile, File resultsFile) throws Exception {
        boolean bl;
        XMLEventWriter scenarioEventWriter = null;
        XMLEventWriter resultsEventWriter = null;
        XMLEventReader originalEventReader = null;
        try {
            scenarioEventWriter = XMLOutputFactory.newFactory().createXMLEventWriter(new BufferedOutputStream(new FileOutputStream(scenarioFile)));
            resultsEventWriter = XMLOutputFactory.newFactory().createXMLEventWriter(new BufferedOutputStream(new FileOutputStream(resultsFile)));
            originalEventReader = XMLInputFactory.newFactory().createXMLEventReader(new BufferedInputStream(new FileInputStream(originalFile)));
            scenarioEventWriter.add(XmlEventFactory.startDocument());
            resultsEventWriter.add(XmlEventFactory.startDocument());
            resultsEventWriter.add(XmlEventFactory.startElement("workspaceResults"));
            boolean hasResults = this.splitOriginalIntoScenarioAndResults(originalEventReader, scenarioEventWriter, resultsEventWriter);
            resultsEventWriter.add(XmlEventFactory.endElement("workspaceResults"));
            scenarioEventWriter.add(XmlEventFactory.endDocument());
            resultsEventWriter.add(XmlEventFactory.endDocument());
            bl = hasResults;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(scenarioEventWriter);
            IOUtils.closeQuietly(resultsEventWriter);
            IOUtils.closeQuietly(originalEventReader);
            throw throwable;
        }
        IOUtils.closeQuietly(scenarioEventWriter);
        IOUtils.closeQuietly(resultsEventWriter);
        IOUtils.closeQuietly(originalEventReader);
        return bl;
    }

    private boolean splitOriginalIntoScenarioAndResults(XMLEventReader eventReader, XMLEventWriter scenarioEventWriter, XMLEventWriter resultsEventWriter) throws XMLStreamException {
        boolean resultsElementFound = false;
        this.skipNonElementEvents(eventReader);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.peek();
            if (this.isWorkspaceElementStartEvent(event)) {
                scenarioEventWriter.add(this.makeWorkspaceStartElementWithBumpedVersion(event.asStartElement()));
                eventReader.nextEvent();
            } else if (this.isWorkspaceElementEndEvent(event)) {
                this.moveEvent(eventReader, scenarioEventWriter);
            } else if (this.isScenarioTopLevelElement(event)) {
                this.moveSubTree(eventReader, scenarioEventWriter);
            } else if (this.isResultsTopLevelElement(event)) {
                resultsElementFound = true;
                this.moveSubTree(eventReader, resultsEventWriter);
            } else {
                throw new MigrationException("Unexpected element event: " + event);
            }
            this.skipNonElementEvents(eventReader);
        }
        return resultsElementFound;
    }

    private StartElement makeWorkspaceStartElementWithBumpedVersion(final StartElement originalWorkspaceElement) {
        final XMLEventFactory eventFactory = XMLEventFactory.newFactory();
        Iterator replacingAttributeIterator = new Iterator(){
            Iterator originalAttributeIterator;
            {
                this.originalAttributeIterator = originalWorkspaceElement.getAttributes();
            }

            @Override
            public boolean hasNext() {
                return this.originalAttributeIterator.hasNext();
            }

            public Object next() {
                Attribute attribute = (Attribute)this.originalAttributeIterator.next();
                if (attribute.getName().getLocalPart().equals("workspace_format_version")) {
                    return eventFactory.createAttribute(new QName("workspace_format_version"), Integer.toString(Rule006XmlToZipFileWorkspaceMigration.this.getOriginalVersion().nextVersion().getNumber()));
                }
                return attribute;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return eventFactory.createStartElement(originalWorkspaceElement.getName(), replacingAttributeIterator, originalWorkspaceElement.getNamespaces());
    }

    private void skipNonElementEvents(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event = eventReader.peek();
        while (event != null && !event.isStartElement() && !event.isEndElement()) {
            eventReader.nextEvent();
            event = eventReader.peek();
        }
    }

    private boolean isWorkspaceElementStartEvent(XMLEvent event) {
        return event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("Workspace");
    }

    private boolean isWorkspaceElementEndEvent(XMLEvent event) {
        return event.isEndElement() && event.asEndElement().getName().getLocalPart().equals("Workspace");
    }

    private boolean isScenarioTopLevelElement(XMLEvent event) {
        if (event.isStartElement()) {
            String elementName = event.asStartElement().getName().getLocalPart();
            return SCENARIO_TOP_LEVEL_ELEMENT_NAMES.contains(elementName);
        }
        return false;
    }

    private boolean isResultsTopLevelElement(XMLEvent event) {
        if (event.isStartElement()) {
            String elementName = event.asStartElement().getName().getLocalPart();
            return RESULTS_TOP_LEVEL_ELEMENT_NAMES.contains(elementName);
        }
        return false;
    }

    private void moveEvent(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        writer.add(reader.nextEvent());
    }

    private void moveSubTree(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        StartElement startElement = reader.nextEvent().asStartElement();
        Stack<String> elementNames = new Stack<String>();
        elementNames.push(startElement.getName().getLocalPart());
        writer.add(startElement);
        while (!elementNames.empty()) {
            if (reader.hasNext()) {
                String poppedElementName;
                XMLEvent currentEvent = reader.nextEvent();
                writer.add(currentEvent);
                if (currentEvent.isStartElement()) {
                    elementNames.push(currentEvent.asStartElement().getName().getLocalPart());
                }
                if (!currentEvent.isEndElement() || (poppedElementName = (String)elementNames.pop()).equals(currentEvent.asEndElement().getName().getLocalPart())) continue;
                throw new XMLStreamException("Unexpected end element event: " + currentEvent);
            }
            throw new XMLStreamException("Unexpected end of XML stream while moving subtree for element: " + startElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipFileFromScenarioAndResultsFiles(File migratedFile, File scenarioFile, File resultsFile, boolean hasResults) throws Exception {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(migratedFile)));
            ZipEntry scenarioEntry = new ZipEntry("scenario.xml");
            zipOutputStream.putNextEntry(scenarioEntry);
            FileUtils.copyFile(scenarioFile, zipOutputStream);
            if (hasResults) {
                ZipEntry resultsEntry = new ZipEntry("results.xml");
                zipOutputStream.putNextEntry(resultsEntry);
                FileUtils.copyFile(resultsFile, zipOutputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(zipOutputStream);
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(5);
    }
}

