/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.seamcat.migration.workspace.MigrateLocalEnvironment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule017LocalEnvironmentWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List links = context.selectNodes("//InterferingSystemLink");
        Element iTx = null;
        Element iRx = null;
        Element vTx = null;
        Element vRx = null;
        boolean hasVictimTx = false;
        boolean hasVictimRx = false;
        boolean hasInterfererTx = false;
        boolean hasInterfererRx = false;
        boolean first = true;
        for (Object o : links) {
            if (first) {
                iTx = (Element)((Element)o).getElementsByTagName("transmitter").item(0);
                iRx = (Element)((Element)o).getElementsByTagName("receiver").item(0);
                continue;
            }
            first = false;
        }
        links = context.selectNodes("//VictimSystemLink");
        for (Object o : links) {
            vTx = (Element)((Element)o).getElementsByTagName("transmitter").item(0);
            vRx = (Element)((Element)o).getElementsByTagName("receiver").item(0);
        }
        links = context.selectNodes("//InterferenceLink");
        boolean multiple = false;
        for (Object link : links) {
            NodeList sensing;
            MigrateLocalEnvironment tx;
            MigrateLocalEnvironment rx;
            Element element = (Element)link;
            Element transmitter = (Element)element.getElementsByTagName("transmitter").item(0);
            boolean interfererIsCr = Boolean.parseBoolean(transmitter.getAttribute("interferer_is_cr"));
            Element path = (Element)element.getFirstChild();
            Element pm = (Element)path.getElementsByTagName("plugin-configuration").item(0);
            if (this.cleanPm(pm, rx = new MigrateLocalEnvironment(), tx = new MigrateLocalEnvironment())) {
                if (multiple) {
                    this.getMigrationIssues().add(new MigrationIssue("Local environments are skipped for multiple Interfering links"));
                } else {
                    this.writeEnvironment(rx, vRx, document);
                    hasVictimRx = true;
                    this.writeEnvironment(tx, iTx, document);
                    hasInterfererTx = true;
                }
            }
            if ((sensing = element.getElementsByTagName("WantedTransmitterToInterferingTransmitterPath")).getLength() > 0) {
                MigrateLocalEnvironment sRx = new MigrateLocalEnvironment();
                MigrateLocalEnvironment sTx = new MigrateLocalEnvironment();
                if (this.cleanPm((Element)sensing.item(0).getFirstChild().getFirstChild(), sRx, sTx) && interfererIsCr) {
                    if (multiple) {
                        this.getMigrationIssues().add(new MigrationIssue("Local environments are skipped for multiple Interfering links"));
                    } else {
                        this.writeEnvironment(tx, vTx, document);
                        hasVictimTx = true;
                        this.writeEnvironment(rx, iRx, document);
                        hasInterfererRx = true;
                    }
                }
            }
            multiple = true;
        }
        links = context.selectNodes("//VictimSystemLink");
        for (Object o : links) {
            this.handleLink((Element)o, document, hasVictimRx, hasVictimTx);
        }
        links = context.selectNodes("//InterferingSystemLink");
        for (Object o : links) {
            this.handleLink((Element)o, document, hasInterfererRx, hasInterfererTx);
        }
        this.updateVersion(document);
    }

    private boolean cleanPm(Element pm, MigrateLocalEnvironment rx, MigrateLocalEnvironment tx) {
        String cn = pm.getAttribute("classname");
        boolean hasEnvironments = true;
        if (cn.equals("org.seamcat.model.propagation.HataSE21PropagationModel") || cn.equals("org.seamcat.model.propagation.HataSE24PropagationModel")) {
            rx.setEnvironment(this.valueOf(this.rem(pm, "param10")));
            tx.setEnvironment(this.valueOf(this.rem(pm, "param11")));
            rx.setWallLoss(Double.parseDouble(this.rem(pm, "param12")));
            rx.setWallLossStdDev(Double.parseDouble(this.rem(pm, "param13")));
            tx.setWallLoss(rx.wallLoss());
            tx.setWallLossStdDev(rx.stdDev());
        } else if (cn.equals("org.seamcat.model.propagation.SDPropagationModel")) {
            rx.setEnvironment(this.valueOf(this.rem(pm, "param13")));
            tx.setEnvironment(this.valueOf(this.rem(pm, "param14")));
            rx.setWallLoss(Double.parseDouble(this.rem(pm, "param15")));
            rx.setWallLossStdDev(Double.parseDouble(this.rem(pm, "param16")));
            tx.setWallLoss(rx.wallLoss());
            tx.setWallLossStdDev(rx.stdDev());
        } else {
            hasEnvironments = false;
        }
        return hasEnvironments;
    }

    private void handleLink(Element element, Document document, boolean hasRx, boolean hasTx) {
        boolean hasEnvironments = true;
        Element pm = (Element)element.getElementsByTagName("PropagationModel").item(0).getFirstChild();
        String cn = pm.getAttribute("classname");
        MigrateLocalEnvironment rx = new MigrateLocalEnvironment();
        MigrateLocalEnvironment tx = new MigrateLocalEnvironment();
        if (cn.equals("org.seamcat.model.propagation.HataSE21PropagationModel") || cn.equals("org.seamcat.model.propagation.HataSE24PropagationModel")) {
            rx.setEnvironment(this.valueOf(this.rem(pm, "param10")));
            tx.setEnvironment(this.valueOf(this.rem(pm, "param11")));
            rx.setWallLoss(Double.parseDouble(this.rem(pm, "param12")));
            rx.setWallLossStdDev(Double.parseDouble(this.rem(pm, "param13")));
            tx.setWallLoss(rx.wallLoss());
            tx.setWallLossStdDev(rx.stdDev());
        } else if (cn.equals("org.seamcat.model.propagation.SDPropagationModel")) {
            rx.setEnvironment(this.valueOf(this.rem(pm, "param13")));
            tx.setEnvironment(this.valueOf(this.rem(pm, "param14")));
            rx.setWallLoss(Double.parseDouble(this.rem(pm, "param15")));
            rx.setWallLossStdDev(Double.parseDouble(this.rem(pm, "param16")));
            tx.setWallLoss(rx.wallLoss());
            tx.setWallLossStdDev(rx.stdDev());
        } else {
            hasEnvironments = false;
        }
        if (hasEnvironments) {
            Element les;
            if (!hasRx) {
                Node receiver = element.getElementsByTagName("receiver").item(0);
                les = document.createElement("LocalEnvironments");
                les.appendChild(this.add(document.createElement("LocalEnvironment"), rx));
                receiver.appendChild(les);
            }
            if (!hasTx) {
                Node transmitter = element.getElementsByTagName("transmitter").item(0);
                les = document.createElement("LocalEnvironments");
                les.appendChild(this.add(document.createElement("LocalEnvironment"), tx));
                transmitter.appendChild(les);
            }
        }
    }

    private String valueOf(String number) {
        if ("0".equals(number)) {
            return "Indoor";
        }
        return "Outdoor";
    }

    private void writeEnvironment(MigrateLocalEnvironment le, Element element, Document document) {
        Element les = document.createElement("LocalEnvironments");
        les.appendChild(this.add(document.createElement("LocalEnvironment"), le));
        element.appendChild(les);
    }

    private String rem(Element element, String name) {
        String attribute = element.getAttribute(name);
        element.removeAttribute(name);
        return attribute;
    }

    private Element add(Element le, MigrateLocalEnvironment env) {
        le.setAttribute("environment", env.environment());
        le.setAttribute("prop", Double.toString(env.prop()));
        le.setAttribute("wallLoss", Double.toString(env.wallLoss()));
        le.setAttribute("stdDev", Double.toString(env.stdDev()));
        return le;
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(16);
    }
}

