/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule021SignalsWorkspaceResultMigration
extends AbstractScenarioMigration {
    private Collection<String> vectors = Arrays.asList("iRSSVectorListBlocking", "iRSSVectorListIntermodulation", "iRSSVectorListUnwanted", "iRSSVectorListOverloading");

    @Override
    void migrateScenarioDocument(Document document) {
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List list = context.selectNodes("//SEAMCATResults");
        if (list.size() > 0) {
            Element results = (Element)list.get(0);
            Element signals = (Element)context.selectSingleNode("//Signals");
            NodeList childNodes = signals.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                int j;
                Element vectorValues;
                Element migratedResult;
                Element vector = (Element)childNodes.item(i);
                if (vector.getNodeName().equals("DRSSVector")) {
                    migratedResult = document.createElement("SEAMCATResult");
                    migratedResult.setAttribute("name", vector.getAttribute("name"));
                    vectorValues = this.appendEmptyGroups(document, migratedResult);
                    Element values = this.appendValuesElement(document, vectorValues);
                    NodeList valuesList = vector.getFirstChild().getChildNodes();
                    if (valuesList.getLength() <= 0) continue;
                    for (j = 0; j < valuesList.getLength(); ++j) {
                        Element event = (Element)valuesList.item(j);
                        Element value = document.createElement("value");
                        value.setAttribute("v", event.getAttribute("y"));
                        values.appendChild(value);
                    }
                    results.appendChild(migratedResult);
                    continue;
                }
                if (!this.vectors.contains(vector.getNodeName())) continue;
                vector = (Element)vector.getFirstChild();
                migratedResult = document.createElement("SEAMCATResult");
                migratedResult.setAttribute("name", vector.getAttribute("name"));
                vectorValues = this.appendEmptyGroups(document, migratedResult);
                Element vectorList = (Element)vector.getFirstChild();
                NodeList subVectors = vectorList.getChildNodes();
                for (j = 0; j < subVectors.getLength(); ++j) {
                    Element sub = (Element)subVectors.item(j);
                    Element values = this.appendValuesElement(document, vectorValues);
                    Element actualVector = (Element)sub.getFirstChild().getFirstChild();
                    if (!actualVector.hasChildNodes()) continue;
                    NodeList valueList = actualVector.getChildNodes();
                    for (int k = 0; k < valueList.getLength(); ++k) {
                        Element v = (Element)valueList.item(k);
                        Element value = document.createElement("value");
                        value.setAttribute("v", v.getAttribute("y"));
                        values.appendChild(value);
                    }
                    results.appendChild(migratedResult);
                }
            }
            this.removeNode(context, "//Signals");
        }
    }

    private Element appendEmptyGroups(Document document, Element result) {
        result.appendChild(document.createElement("SingleValues"));
        result.appendChild(document.createElement("VectorGroups"));
        Element vectorValues = document.createElement("VectorValues");
        result.appendChild(vectorValues);
        result.appendChild(document.createElement("ScatterPlots"));
        result.appendChild(document.createElement("BarCharts"));
        result.appendChild(document.createElement("CustomResults"));
        return vectorValues;
    }

    private Element appendValuesElement(Document document, Element vectorValues) {
        Element vectorElement = document.createElement("Vector");
        vectorElement.setAttribute("name", "dRSS vector");
        vectorElement.setAttribute("unit", "dBm");
        Element values = document.createElement("values");
        vectorElement.appendChild(values);
        vectorValues.appendChild(vectorElement);
        return values;
    }

    private void removeNode(JXPathContext context, String searchPath) {
        List blocking = context.selectNodes(searchPath);
        for (Object o : blocking) {
            if (!(o instanceof Node)) continue;
            ((Node)o).getParentNode().removeChild((Node)o);
        }
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(20);
    }
}

