/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule028TransmitterWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List transmitters = context.selectNodes("//transmitter");
        for (Object o : transmitters) {
            Element element = (Element)o;
            Rule028TransmitterWorkspaceMigration.fixTransmitter(element, document);
        }
        this.updateVersion(document);
    }

    public static void fixTransmitter(Element transmitter, Document doc) {
        Element emissionMask;
        Element it;
        Rule028TransmitterWorkspaceMigration.rename(transmitter, "interferer_is_cr", "cognitiveRadio");
        Node parentNode = transmitter.getParentNode();
        if (parentNode != null && parentNode.getNodeName().equals("InterferingTransmitter") && (it = (Element)parentNode).hasAttribute("deviceCR")) {
            transmitter.setAttribute("cognitiveRadio", it.getAttribute("deviceCR"));
            it.removeAttribute("deviceCR");
        }
        Rule028TransmitterWorkspaceMigration.rename(transmitter, "power_control_max_threshold", "receivePower");
        Rule028TransmitterWorkspaceMigration.rename(transmitter, "use_power_control", "powerControl");
        Element powerDist = Rule028TransmitterWorkspaceMigration.findFirst(transmitter, "power-supplied-distribution");
        if (powerDist != null) {
            Rule028TransmitterWorkspaceMigration.rename(powerDist, doc, "power");
        }
        if ((emissionMask = Rule028TransmitterWorkspaceMigration.findFirst(transmitter, "spectrum-emission-mask")) != null) {
            Rule028TransmitterWorkspaceMigration.rename(emissionMask, doc, "emissionMask");
        }
        String useFloor = transmitter.getAttribute("use_unwanted_emission");
        transmitter.removeAttribute("use_unwanted_emission");
        Element floor = Rule028TransmitterWorkspaceMigration.findFirst(transmitter, "unwantedemissionfloor");
        if (floor != null) {
            Element emissionFloor = Rule028TransmitterWorkspaceMigration.rename(floor, doc, "emissionFloor");
            emissionFloor.setAttribute("enabled", useFloor);
        }
        Element powercontrol = Rule028TransmitterWorkspaceMigration.findFirst(transmitter, "powercontrol");
        String pcmin = powercontrol.getAttribute("pcmin");
        String pcrange = powercontrol.getAttribute("pcrange");
        String pcstep = powercontrol.getAttribute("pcstep");
        transmitter.setAttribute("stepSize", pcstep);
        transmitter.setAttribute("minThreshold", pcmin);
        transmitter.setAttribute("dynamicRange", pcrange);
        transmitter.removeChild(powercontrol);
    }

    private static Element findFirst(Element parent, String name) {
        NodeList powerDists = parent.getElementsByTagName(name);
        if (powerDists.getLength() > 0) {
            return (Element)powerDists.item(0);
        }
        return null;
    }

    private static void rename(Element element, String attribute, String newName) {
        String value = element.getAttribute(attribute);
        element.removeAttribute(attribute);
        element.setAttribute(newName, value);
    }

    private static Element rename(Element orig, Document document, String newName) {
        Element elm = document.createElement(newName);
        for (int i = 0; i < orig.getChildNodes().getLength(); ++i) {
            elm.appendChild(orig.getChildNodes().item(i));
        }
        Node parentNode = orig.getParentNode();
        parentNode.removeChild(orig);
        parentNode.appendChild(elm);
        return elm;
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(27);
    }
}

