/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule033DmaLayoutSectorWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List dmas = context.selectNodes("//CdmaSystem");
        for (Object o : dmas) {
            int layout;
            Element element = (Element)o;
            int type = Integer.parseInt(element.getAttribute("cellType"));
            element.removeAttribute("cellType");
            if (element.hasAttribute("gridLayout")) {
                layout = Integer.parseInt(element.getAttribute("gridLayout"));
                element.removeAttribute("gridLayout");
            } else {
                layout = 1;
            }
            String sectorSetup = type == 1 ? "SingleSector" : (layout == 1 ? "TriSector3GPP2" : "TriSector3GPP");
            element.setAttribute("sectorSetup", sectorSetup);
        }
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(32);
    }
}

