/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import java.util.UUID;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule038SystemFifthWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List workspaces = context.selectNodes("//Workspace");
        if (workspaces.size() != 1) {
            throw new RuntimeException("ERROR");
        }
        Element workspace = (Element)workspaces.get(0);
        Element systems = document.createElement("systems");
        List links = context.selectNodes("//InterferenceLink");
        for (Object o : links) {
            Element element = (Element)o;
            Element system = (Element)element.getElementsByTagName("system").item(0);
            String id = UUID.randomUUID().toString();
            system.setAttribute("id", id);
            element.setAttribute("interferingSystem", id);
            element.removeChild(system);
            systems.appendChild(system);
        }
        Element system = (Element)workspace.getElementsByTagName("system").item(0);
        String victimId = UUID.randomUUID().toString();
        system.setAttribute("id", victimId);
        system.getParentNode().removeChild(system);
        systems.appendChild(system);
        workspace.setAttribute("victim", victimId);
        workspace.appendChild(systems);
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(37);
    }
}

