/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule040LocalEnvironmentsWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List systems = context.selectNodes("//system");
        for (Object o : systems) {
            Element system = (Element)o;
            Node local = system.getElementsByTagName("localEnvironments").item(0);
            NodeList childNodes = local.getChildNodes();
            if (childNodes.getLength() != 2) continue;
            Node receiver = childNodes.item(0);
            Node transmitter = childNodes.item(1);
            local.removeChild(receiver);
            Element receiverEnvironments = document.createElement("receiverEnvironments");
            receiverEnvironments.appendChild(receiver);
            local.removeChild(transmitter);
            Element transmitterEnvironments = document.createElement("transmitterEnvironments");
            transmitterEnvironments.appendChild(transmitter);
            local.appendChild(receiverEnvironments);
            local.appendChild(transmitterEnvironments);
        }
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(39);
    }
}

