/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule043ValueDistributionWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List relative = context.selectNodes("//relativeLocation");
        for (Object o : relative) {
            Element link = (Element)o;
            this.appendDist(document, link, "deltaX");
            this.appendDist(document, link, "deltaY");
            this.appendDist(document, link, "coLocationX");
            this.appendDist(document, link, "coLocationY");
            this.appendDist(document, link, "minimumCouplingLoss");
            this.appendDist(document, link, "protectionDistance");
        }
        this.updateVersion(document);
    }

    private void appendDist(Document document, Element element, String name) {
        if (element.hasAttribute(name)) {
            String constant = element.getAttribute(name);
            element.removeAttribute(name);
            Element namedEle = document.createElement(name);
            Element distribution = document.createElement("distribution");
            distribution.setAttribute("constant", constant);
            distribution.setAttribute("type", "0");
            namedEle.appendChild(distribution);
            element.appendChild(namedEle);
        }
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(42);
    }
}

