/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule045DRSSWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        Element ws = (Element)context.selectNodes("//Workspace").get(0);
        String vId = ws.getAttribute("victim");
        List systems = context.selectNodes("//system");
        for (Object sys : systems) {
            Element system = (Element)sys;
            String id = system.getAttribute("id");
            NodeList dRSS = system.getElementsByTagName("dRSS");
            if (dRSS.getLength() <= 0) continue;
            Node dRSSNode = dRSS.item(0);
            if (vId.equals(id)) {
                dRSSNode.getParentNode().removeChild(dRSSNode);
                ws.appendChild(dRSSNode);
                continue;
            }
            dRSSNode.getParentNode().removeChild(dRSSNode);
        }
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(44);
    }
}

