/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule046AntennaDMAPatternWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        Element ws = (Element)context.selectNodes("//Workspace").get(0);
        List systems = context.selectNodes("//system");
        for (Object sys : systems) {
            Element system = (Element)sys;
            Element composite = (Element)system.getFirstChild();
            String clazz = composite.getAttribute("class");
            if (!clazz.equals("org.seamcat.model.systems.cdma.SystemModelCDMAUpLink") && !clazz.equals("org.seamcat.model.systems.cdma.SystemModelCDMADownLink") && !clazz.equals("org.seamcat.model.systems.ofdma.SystemModelOFDMAUpLink") && !clazz.equals("org.seamcat.model.systems.ofdma.SystemModelOFDMADownLink")) continue;
            Element desc = (Element)composite.getFirstChild();
            String name = desc.getAttribute("name");
            Element bs = (Element)composite.getElementsByTagName("baseStation").item(0);
            NodeList horizontals = bs.getElementsByTagName("horizontal");
            if (horizontals.getLength() <= 0) continue;
            Element item = (Element)horizontals.item(0);
            NodeList pts = item.getElementsByTagName("point2d");
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            for (int i = 0; i < pts.getLength(); ++i) {
                Element pElement = (Element)pts.item(i);
                points.add(new Point2D(Double.parseDouble(pElement.getAttribute("x")), Double.parseDouble(pElement.getAttribute("y"))));
            }
            double min = ((Point2D)points.get(0)).getX();
            double max = ((Point2D)points.get(points.size() - 1)).getX();
            if (min == 0.0 && max == 360.0 || min != -180.0 || max != 180.0) continue;
            this.getMigrationIssues().add(new MigrationIssue("System '" + name + "' contained a horizontal antenna pattern in the range -180 to 180. This has been converted to range 0 to 360"));
            List<Point2D> converted = Rule046AntennaDMAPatternWorkspaceMigration.convertFrom180180To0360(points);
            Node discreteFunction = item.getFirstChild().getFirstChild();
            while (discreteFunction.hasChildNodes()) {
                discreteFunction.removeChild(discreteFunction.getFirstChild());
            }
            for (Point2D point : converted) {
                Element point2d = document.createElement("point2d");
                point2d.setAttribute("x", Double.toString(point.getX()));
                point2d.setAttribute("y", Double.toString(point.getY()));
                discreteFunction.appendChild(point2d);
            }
        }
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(45);
    }

    public static List<Point2D> convertFrom180180To0360(List<Point2D> points) {
        ArrayList<Point2D> converted = new ArrayList<Point2D>();
        for (Point2D p : points) {
            if (p.getX() < -179.999) continue;
            if (p.getX() < 0.0) {
                converted.add(new Point2D(p.getX() + 360.0, p.getY()));
            } else {
                converted.add(p);
            }
            if (!(Math.abs(p.getX()) < 0.001)) continue;
            converted.add(new Point2D(360.0, p.getY()));
        }
        Collections.sort(converted, Point2D.X_COMPARATOR);
        return Factory.functionFactory().discreteFunction(converted).getPoints();
    }
}

