/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.settings.Rule016SensingSettingsMigration;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule047SensingWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List sList = context.selectNodes("//system");
        List lList = context.selectNodes("//link");
        for (Object s : sList) {
            Element emi = this.find((Element)s, "emissionCharacteristics");
            if (emi == null) continue;
            Rule016SensingSettingsMigration.appendSensing(emi, document);
        }
        for (Object ll : lList) {
            Element link = (Element)ll;
            Element origin = (Element)link.getElementsByTagName("sensingCharacteristics").item(0);
            String id = link.getAttribute("interferingSystemId");
            Element system = this.find(sList, id);
            Element emissions = this.find(system, "emissionCharacteristics");
            if (emissions == null) continue;
            emissions.setAttribute("probabilityOfFailure", origin.getAttribute("probabilityOfFailure"));
            emissions.setAttribute("receptionBandwidth", origin.getAttribute("receptionBandwidth"));
            NodeList nodes = emissions.getChildNodes();
            ArrayList<Node> toBeRemoved = new ArrayList<Node>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node item = nodes.item(i);
                String name = item.getNodeName();
                if (!name.equals("eirpMax") && !name.equals("detectionThreshold") && !name.equals("propagationModel")) continue;
                toBeRemoved.add(item);
            }
            for (Node node : toBeRemoved) {
                emissions.removeChild(node);
            }
            while (origin.hasChildNodes()) {
                Node child = origin.getFirstChild();
                origin.removeChild(child);
                emissions.appendChild(child);
            }
            Node parent = origin.getParentNode();
            parent.removeChild(origin);
            emissions.appendChild(parent.getFirstChild());
        }
        this.updateVersion(document);
    }

    private Element find(Element origin, String name) {
        NodeList list = origin.getElementsByTagName(name);
        if (list.getLength() == 1) {
            return (Element)list.item(0);
        }
        return null;
    }

    private Element find(List sList, String id) {
        for (Object ss : sList) {
            Element system = (Element)ss;
            if (!system.getAttribute("id").equals(id)) continue;
            return system;
        }
        throw new RuntimeException("System not found: " + id);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(46);
    }
}

