/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule050CorrelationModeForPluginsWorkspaceMigration
extends AbstractScenarioMigration {
    private Map<String, Element> genericSystems = new HashMap<String, Element>();

    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List syss = context.selectNodes("//system/composite");
        for (Object sys : syss) {
            Element s = (Element)sys;
            if (!s.getAttribute("class").equals("org.seamcat.model.systems.generic.SystemModelGeneric")) continue;
            String id = ((Element)s.getParentNode()).getAttribute("id");
            this.genericSystems.put(id, s);
        }
        List rls = context.selectNodes("//links/link/composite/path/composite/relativeLocation");
        for (Object rl : rls) {
            Element relativeLoc = (Element)rl;
            Element settings = document.createElement("correlationSettings");
            Element customUI = document.createElement("customUI");
            int mode = Integer.parseInt(relativeLoc.getAttribute("mode"));
            if (this.or(mode, 0, 3, 11, 13, 15, 16, 20, 22)) {
                settings.setAttribute("mode", "0");
                this.createNONEElements(document, customUI, mode, relativeLoc);
            } else if (this.or(mode, 1, 4, 17)) {
                settings.setAttribute("mode", "1");
                this.createUNIFORMElements(document, customUI, relativeLoc);
            } else if (this.or(mode, 2, 5, 18)) {
                settings.setAttribute("mode", "2");
                this.createCLOSESTElements(document, customUI, relativeLoc);
            } else {
                settings.setAttribute("mode", "3");
            }
            settings.setAttribute("numberOfActiveTx", relativeLoc.getAttribute("numberOfActiveTransmitters"));
            String posRelativeTo = this.or(mode, 0, 1, 2, 6, 9, 14, 15) ? "VLRx" : (this.or(mode, 10, 11, 16, 17, 18, 19, 20, 21, 22) ? "Victim BS ref.cell" : "VLTx");
            settings.setAttribute("positionRelativeTo", posRelativeTo);
            String targetPos = this.or(mode, 8, 9, 21, 22) ? "ILRx" : (this.or(mode, 10, 11, 12, 13, 14, 15) ? "Interfering BS ref.cell" : "ILTx");
            settings.setAttribute("correlationTarget", targetPos);
            settings.setAttribute("isCoLocated", relativeLoc.getAttribute("isCoLocated"));
            settings.setAttribute("coLocatedWith", relativeLoc.getAttribute("coLocatedWith"));
            this.move(relativeLoc, settings, "deltaX");
            this.move(relativeLoc, settings, "deltaY");
            this.move(relativeLoc, settings, "minimumCouplingLoss");
            settings.appendChild(customUI);
            Node parent = relativeLoc.getParentNode();
            parent.removeChild(relativeLoc);
            parent.appendChild(settings);
        }
        for (Element element : this.genericSystems.values()) {
            Element density = (Element)element.getElementsByTagName("density").item(0);
            density.getParentNode().removeChild(density);
        }
        this.updateVersion(document);
    }

    private void createNONEElements(Document doc, Element customUI, int mode, Element old) {
        Element customItem = doc.createElement("customItem");
        customItem.setAttribute("classname", "org.seamcat.model.correlation.None");
        customItem.setAttribute("usePolygon", old.getAttribute("usePolygon"));
        customItem.setAttribute("shape", old.getAttribute("shape"));
        customItem.setAttribute("simulationRadius", old.getAttribute("simulationRadius"));
        this.move(old, customItem, "pathAzimuth");
        this.move(old, customItem, "pathDistanceFactor");
        this.move(old, customItem, "protectionDistance");
        this.move(old, customItem, "turnCCW");
        customUI.appendChild(customItem);
        if (!this.or(mode, 11, 13, 15)) {
            customItem = doc.createElement("customItem");
            customItem.setAttribute("classname", "org.seamcat.model.correlation.ILRAtCenter");
            customItem.setAttribute("ilrAtTheCenter", old.getAttribute("setILRatTheCenter"));
            customUI.appendChild(customItem);
        }
    }

    private void createUNIFORMElements(Document doc, Element customUI, Element old) {
        Element customItem = doc.createElement("customItem");
        customItem.setAttribute("classname", "org.seamcat.model.correlation.UniformDensity");
        this.move(old, customItem, "pathAzimuth");
        this.move(old, customItem, "pathDistanceFactor");
        this.move(old, customItem, "protectionDistance");
        customUI.appendChild(customItem);
        customItem = doc.createElement("customItem");
        customItem.setAttribute("classname", "org.seamcat.model.correlation.ILRAtCenter");
        customItem.setAttribute("ilrAtTheCenter", old.getAttribute("setILRatTheCenter"));
        customUI.appendChild(customItem);
        Element node = (Element)old.getParentNode().getParentNode().getParentNode().getParentNode();
        String sysId = node.getAttribute("interferingSystemId");
        Element system = this.genericSystems.get(sysId);
        Element density = (Element)system.getElementsByTagName("density").item(0);
        customItem = doc.createElement("customItem");
        customItem.setAttribute("classname", "org.seamcat.model.generic.InterferersDensityUI");
        customItem.setAttribute("densityTx", density.getAttribute("densityTx"));
        customItem.setAttribute("probabilityOfTransmission", density.getAttribute("probabilityOfTransmission"));
        customItem.setAttribute("hourOfDay", density.getAttribute("hourOfDay"));
        this.move(density, customItem, "activity");
        customUI.appendChild(customItem);
    }

    private void createCLOSESTElements(Document doc, Element customUI, Element old) {
        Element customItem = doc.createElement("customItem");
        customItem.setAttribute("classname", "org.seamcat.model.correlation.Closest");
        this.move(old, customItem, "pathAzimuth");
        this.move(old, customItem, "protectionDistance");
        customUI.appendChild(customItem);
        customItem = doc.createElement("customItem");
        customItem.setAttribute("classname", "org.seamcat.model.correlation.ILRAtCenter");
        customItem.setAttribute("ilrAtTheCenter", old.getAttribute("setILRatTheCenter"));
        customUI.appendChild(customItem);
        Element node = (Element)old.getParentNode().getParentNode().getParentNode().getParentNode();
        String sysId = node.getAttribute("interferingSystemId");
        Element system = this.genericSystems.get(sysId);
        Element density = (Element)system.getElementsByTagName("density").item(0);
        customItem = doc.createElement("customItem");
        customItem.setAttribute("classname", "org.seamcat.model.generic.InterferersDensityUI");
        customItem.setAttribute("densityTx", density.getAttribute("densityTx"));
        customItem.setAttribute("probabilityOfTransmission", density.getAttribute("probabilityOfTransmission"));
        customItem.setAttribute("hourOfDay", density.getAttribute("hourOfDay"));
        this.move(density, customItem, "activity");
        customUI.appendChild(customItem);
    }

    private void move(Element from, Element to, String childName) {
        Node child = from.getElementsByTagName(childName).item(0);
        if (child == null) {
            return;
        }
        from.removeChild(child);
        to.appendChild(child);
    }

    private boolean or(int mode, int ... options) {
        for (int option : options) {
            if (mode != option) continue;
            return true;
        }
        return false;
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(49);
    }
}

