/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule056ListElementsWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List rx = context.selectNodes("//receiverEnvironments/LocalEnvironments");
        Rule056ListElementsWorkspaceMigration.migrateLocalEnvironments(document, rx);
        List tx = context.selectNodes("//transmitterEnvironments/LocalEnvironments");
        Rule056ListElementsWorkspaceMigration.migrateLocalEnvironments(document, tx);
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    public static void migrateLocalEnvironments(Document document, List nodes) {
        for (Object node : nodes) {
            Element obsolete = (Element)node;
            NodeList children = obsolete.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element le = (Element)children.item(i);
                Element item = document.createElement("item");
                String env = le.getAttribute("environment").equals("Outdoor") ? "1" : "0";
                item.setAttribute("environment", env);
                item.setAttribute("prop", le.getAttribute("prop"));
                item.setAttribute("stdDev", le.getAttribute("stdDev"));
                item.setAttribute("wallLoss", le.getAttribute("wallLoss"));
                obsolete.getParentNode().appendChild(item);
            }
            Node parent = obsolete.getParentNode();
            parent.removeChild(obsolete);
        }
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(55);
    }
}

