/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule064ResultGroupsWorkspaceMigration
extends AbstractScenarioMigration {
    private int ilCount = 0;

    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List list = context.selectNodes("//links/link");
        this.ilCount = list.size();
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List vectors = context.selectNodes("//SEAMCATResults/SEAMCATResult/VectorValues/Vector");
        for (Object vector : vectors) {
            Element vec = (Element)vector;
            String name = vec.getAttribute("name");
            if (!name.equals("dRSS vector")) continue;
            vec.removeAttribute("name");
            vec.setAttribute("name", "dRSS");
        }
        Element victim = null;
        ArrayList<Element> links = new ArrayList<Element>();
        Node statistics = null;
        ArrayList<Element> other = new ArrayList<Element>();
        Element results = (Element)context.selectSingleNode("//SEAMCATResults");
        List list = context.selectNodes("//SEAMCATResults/SEAMCATResult");
        for (Object o : list) {
            Element element = (Element)o;
            String name = element.getAttribute("name");
            if (name.startsWith("Victim")) {
                victim = element;
                continue;
            }
            if (name.equals("Statistics")) {
                statistics = element;
                continue;
            }
            if (name.startsWith("Link")) {
                links.add(element);
                continue;
            }
            other.add(element);
        }
        if (victim != null && statistics != null && links.size() == this.ilCount) {
            return;
        }
        if (victim == null) {
            Element first = (Element)list.get(0);
            for (Element element1 : other) {
                if (first == element1) continue;
                this.merge(element1, first);
                element1.getParentNode().removeChild(element1);
            }
        }
        if (links.size() < this.ilCount) {
            for (int i = links.size(); i < this.ilCount; ++i) {
                Element seamcatResult = document.createElement("SEAMCATResult");
                seamcatResult.setAttribute("id", "seamcatResult");
                seamcatResult.setAttribute("name", "Link " + (i + 1));
                results.appendChild(seamcatResult);
            }
        }
        if (statistics == null) {
            results.appendChild(this.statistics(document));
        } else {
            Node parentNode = statistics.getParentNode();
            parentNode.removeChild(statistics);
            parentNode.appendChild(statistics);
        }
        Element pre = (Element)context.selectSingleNode("//PreResults");
        if (pre != null) {
            pre.getParentNode().removeChild(pre);
        }
    }

    private void merge(Element from, Element to) {
        JXPathContext context = JXPathContext.newContext(to);
        JXPathContext fromContext = JXPathContext.newContext(from);
        this.simpleMove(context, fromContext, "/SingleValues");
        this.simpleMove(context, fromContext, "/VectorGroups");
        this.simpleMove(context, fromContext, "/VectorValues");
    }

    private void simpleMove(JXPathContext context, JXPathContext fromContext, String path) {
        Element fromElement = (Element)fromContext.selectSingleNode(path);
        Element toElement = (Element)context.selectSingleNode(path);
        while (fromElement.hasChildNodes()) {
            Node firstChild = fromElement.getFirstChild();
            fromElement.removeChild(firstChild);
            toElement.appendChild(firstChild);
        }
    }

    private Element statistics(Document document) {
        Element group = document.createElement("SEAMCATResult");
        group.setAttribute("id", "seamcatResult");
        group.setAttribute("name", "Statistics");
        Element singleValues = document.createElement("SingleValues");
        group.appendChild(singleValues);
        Element single = document.createElement("Single");
        single.setAttribute("name", "Simulation seed");
        single.setAttribute("value", "-1");
        single.setAttribute("type", "longInt");
        single.setAttribute("unit", "");
        singleValues.appendChild(single);
        return group;
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(63);
    }
}

