/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.function.BitRateMappingImpl;
import org.seamcat.function.BlockingMaskImpl;
import org.seamcat.function.EmissionMaskImpl;
import org.seamcat.function.IntermodulationRejectionMaskImpl;
import org.seamcat.interfaces.Dispatcher;
import org.seamcat.interfaces.LibraryVisitor;
import org.seamcat.model.LibraryModel;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.functions.LibraryFunctionItem;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.systems.aggregate.SystemModelAggregate;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.TransmitterModel;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.ui.SystemModelIMT2020DownLink;
import org.seamcat.model.systems.imt2020downlink.ui.SystemModelIMT2020DownLinkMicro;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.ui.SystemModelIMT2020UpLink;
import org.seamcat.model.systems.imt2020uplink.ui.SystemModelIMT2020UpLinkMicro;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.CoverageRadiusConfiguration;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.JarFiles;
import org.seamcat.plugin.PluginClass;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.library.LibraryItemWrapper;
import org.seamcat.presentation.systems.SystemListItem;

public class Library
implements LibraryVisitor<List<? extends LibraryItem>> {
    private static final Logger LOG = Logger.getLogger(Library.class);
    private LibraryModel model;

    public Library(LibraryModel model) {
        this.model = model;
    }

    public LibraryModel getModel() {
        return this.model;
    }

    public List<Configuration> getConfigurationsForJar(JarConfigurationModel jar) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        for (PluginClass aClass : jar.getPluginClasses()) {
            for (Configuration configuration : this.model.pluginConfigurations()) {
                if (configuration.getPluginClass() != aClass.getPluginClass()) continue;
                list.add(configuration);
            }
        }
        return list;
    }

    private void ensureConfiguration(JarConfigurationModel jarConfigurationModel) {
        List<Configuration> forJar = this.getConfigurationsForJar(jarConfigurationModel);
        for (PluginClass pc : jarConfigurationModel.getPluginClasses()) {
            if (this.contains(forJar, pc)) continue;
            this.model.pluginConfigurations().add(pc.configuration());
        }
    }

    private boolean contains(List<Configuration> forJar, PluginClass pc) {
        for (Configuration configuration : forJar) {
            if (configuration.getPluginClass() != pc.getPluginClass()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLibraryFunction(EmissionMaskImpl function) {
        return this.find(function, this.model.emissionMasks()) != null;
    }

    public boolean hasLibraryFunction(BlockingMaskImpl function) {
        return this.find(function, this.model.blockingMasks()) != null;
    }

    public boolean hasLibraryFunction(LibraryFunctionItem function) {
        if (function instanceof BlockingMask) {
            return this.find(function, this.model.blockingMasks()) != null;
        }
        if (function instanceof IntermodulationRejectionMask) {
            return this.find(function, this.model.intermodRejectionMasks()) != null;
        }
        if (function instanceof BitRateMapping) {
            return this.find(function, this.model.blockingMasks()) != null;
        }
        return false;
    }

    public boolean addLibraryFunction(EmissionMask function) {
        return this.add(function, this.model.emissionMasks());
    }

    public boolean addLibraryFunction(LibraryFunctionItem function) {
        if (function instanceof BlockingMask) {
            return this.add((BlockingMask)function, this.model.blockingMasks());
        }
        if (function instanceof IntermodulationRejectionMask) {
            return this.add((IntermodulationRejectionMask)function, this.model.intermodRejectionMasks());
        }
        if (function instanceof BitRateMapping) {
            return this.add((BitRateMapping)function, this.model.bitRateMappings());
        }
        return false;
    }

    public void overrideLibraryFunction(EmissionMask function) {
        this.remove(function, this.model.emissionMasks());
        this.add(function, this.model.emissionMasks());
    }

    public void overrideLibraryFunction(BlockingMask function) {
        this.remove(function, this.model.blockingMasks());
        this.add(function, this.model.blockingMasks());
    }

    public void overrideLibraryFunction(LibraryFunctionItem function) {
        if (function instanceof BlockingMask) {
            this.remove(function, this.model.blockingMasks());
            this.add((BlockingMask)function, this.model.blockingMasks());
        } else if (function instanceof IntermodulationRejectionMask) {
            this.remove(function, this.model.intermodRejectionMasks());
            this.add((IntermodulationRejectionMask)function, this.model.intermodRejectionMasks());
        } else if (function instanceof BitRateMapping) {
            this.remove(function, this.model.bitRateMappings());
            this.add((BitRateMapping)function, this.model.bitRateMappings());
        }
    }

    public List<EmissionMask> getSpectrumEmissionMasks() {
        ArrayList<EmissionMask> result = new ArrayList<EmissionMask>();
        for (EmissionMask spectrumEmissionMask : this.model.emissionMasks()) {
            result.add(spectrumEmissionMask);
        }
        return result;
    }

    public List<SystemPluginConfiguration> getSystems() {
        return new ArrayList<SystemPluginConfiguration>(this.model.systems());
    }

    public <T extends LibraryFunctionItem> List<T> getLibraryFunction(Class<T> clazz) {
        if (clazz == BlockingMask.class) {
            return new ArrayList<BlockingMask>(this.model.blockingMasks());
        }
        if (clazz == IntermodulationRejectionMask.class) {
            return new ArrayList<IntermodulationRejectionMask>(this.model.intermodRejectionMasks());
        }
        if (clazz == BitRateMapping.class) {
            return new ArrayList<BitRateMapping>(this.model.bitRateMappings());
        }
        throw new RuntimeException("No library functions of type: " + clazz);
    }

    public List<BlockingMask> getReceiverBlockingMasks() {
        return new ArrayList<BlockingMask>(this.model.blockingMasks());
    }

    public List<IntermodulationRejectionMask> getIntermodRejectionMasks() {
        return new ArrayList<IntermodulationRejectionMask>(this.model.intermodRejectionMasks());
    }

    public List<BitRateMapping> getBitRateMappings() {
        return new ArrayList<BitRateMapping>(this.model.bitRateMappings());
    }

    public void writeAll(Class<? extends LibraryItem> type, List<? extends LibraryItem> all) {
        block28: {
            block30: {
                block29: {
                    block27: {
                        if (type != ReceiverModel.class) break block27;
                        this.model.receivers().clear();
                        for (LibraryItem libraryItem : all) {
                            this.model.receivers().add((ReceiverModel)libraryItem);
                        }
                        break block28;
                    }
                    if (type != TransmitterModel.class) break block29;
                    this.model.transmitters().clear();
                    for (LibraryItem libraryItem : all) {
                        this.model.transmitters().add((TransmitterModel)libraryItem);
                    }
                    break block28;
                }
                if (type != JarConfigurationModel.class) break block30;
                HashSet<JarConfigurationModel> deleted = new HashSet<JarConfigurationModel>();
                for (JarConfigurationModel jarConfigurationModel : this.model.jars()) {
                    deleted.add(jarConfigurationModel);
                }
                this.model.jars().clear();
                for (LibraryItem libraryItem : all) {
                    JarConfigurationModel jar = (JarConfigurationModel)libraryItem;
                    JarFiles.addJarConfiguration(jar);
                    this.model.jars().add(jar);
                    this.ensureConfiguration(jar);
                    deleted.remove(jar);
                }
                if (deleted.isEmpty()) break block28;
                for (JarConfigurationModel jarConfigurationModel : deleted) {
                    List<Configuration> instances = this.getConfigurationsForJar(jarConfigurationModel);
                    for (Configuration instance : instances) {
                        this.model.pluginConfigurations().remove(instance);
                    }
                }
                break block28;
            }
            if (type == SystemListItem.class) {
                this.model.systems().clear();
                for (LibraryItem libraryItem : all) {
                    SystemListItem systemListItem = (SystemListItem)libraryItem;
                    this.model.systems().add(GenericTypeMarshaller.createConfiguration(systemListItem.getSystemPlugin()));
                }
            } else if (Configuration.class.isAssignableFrom(type)) {
                ArrayList<Configuration> removed = new ArrayList<Configuration>();
                for (Configuration configuration : this.model.pluginConfigurations()) {
                    if (!type.isAssignableFrom(configuration.getClass())) continue;
                    removed.add(configuration);
                }
                this.model.pluginConfigurations().removeAll(removed);
                for (LibraryItem libraryItem : all) {
                    this.model.pluginConfigurations().add((Configuration)libraryItem);
                }
            } else if (type == BlockingMask.class) {
                this.model.blockingMasks().clear();
                for (LibraryItem libraryItem : all) {
                    this.model.blockingMasks().add((BlockingMask)libraryItem);
                }
            } else if (type == EmissionMask.class) {
                this.model.emissionMasks().clear();
                for (LibraryItem libraryItem : all) {
                    this.model.emissionMasks().add((EmissionMask)libraryItem);
                }
            } else if (type == IntermodulationRejectionMask.class) {
                this.model.intermodRejectionMasks().clear();
                for (LibraryItem libraryItem : all) {
                    this.model.intermodRejectionMasks().add((IntermodulationRejectionMask)libraryItem);
                }
            } else if (type == BitRateMapping.class) {
                this.model.bitRateMappings().clear();
                for (LibraryItem libraryItem : all) {
                    this.model.bitRateMappings().add((BitRateMapping)libraryItem);
                }
            } else if (type == CDMALLD.class) {
                this.model.cdmalld().clear();
                for (LibraryItem libraryItem : all) {
                    this.model.cdmalld().add((CDMALLD)libraryItem);
                }
            }
        }
    }

    public void setAll(List<? extends LibraryItem> all) {
        if (all == null || all.size() == 0) {
            return;
        }
        List<? extends LibraryItem> current = Dispatcher.dispatch(this, all.get(0));
        if (current != null) {
            current.clear();
            for (LibraryItem libraryItem : all) {
                current.add(libraryItem);
            }
        }
    }

    public void replaceNamedSystem(SystemPluginConfiguration sys) {
        for (int i = 0; i < this.model.systems().size(); ++i) {
            SystemModel system = this.model.systems().get(i).configuration();
            if (!system.description().name().equals(sys.description().name())) continue;
            this.model.systems().remove(i);
            break;
        }
        this.model.systems().add(sys);
    }

    public void replacePluginInstance(Configuration configuration) {
        Configuration found = null;
        for (Configuration existing : this.model.pluginConfigurations()) {
            if (existing.getClass() != configuration.getClass() || !existing.description().name().equals(configuration.description().name())) continue;
            found = existing;
            break;
        }
        int index = this.model.pluginConfigurations().indexOf(found);
        this.model.pluginConfigurations().remove(found);
        this.model.pluginConfigurations().add(index, configuration);
    }

    private List<Configuration> getPluginConfigurations() {
        return this.model.pluginConfigurations();
    }

    public List<Configuration> getPluginConfigurations(Class<? extends Configuration> clazz) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (Configuration configuration : this.model.pluginConfigurations()) {
            if (clazz != configuration.getClass()) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    public boolean addSystem(SystemPluginConfiguration model) {
        for (SystemPluginConfiguration system : this.model.systems()) {
            if (!LibraryItemWrapper.toString(system).equals(LibraryItemWrapper.toString(model))) continue;
            return false;
        }
        this.model.systems().add(model);
        return true;
    }

    public boolean addJarFile(JarConfigurationModel jar) {
        for (JarConfigurationModel j : this.model.jars()) {
            if (!j.getName().equals(jar.getName())) continue;
            return false;
        }
        this.model.jars().add(jar);
        return true;
    }

    public boolean addPluginConfiguration(Configuration configuration) {
        for (Configuration conf : this.model.pluginConfigurations()) {
            if (configuration.getPluginClass() != conf.getPluginClass() || !conf.description().name().equals(configuration.description().name())) continue;
            return false;
        }
        this.addJarFile(configuration);
        this.model.pluginConfigurations().add(configuration);
        return true;
    }

    private void ensurePluginConfiguration(Configuration configuration) {
        boolean exists = false;
        for (Configuration existing : this.model.pluginConfigurations()) {
            if (existing.getPluginClass() != configuration.getPluginClass()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.addPluginConfiguration(configuration);
        }
    }

    private void removeJarAndDependencies(JarConfigurationModel jar) {
        for (PluginClass aClass : JarFiles.getJarConfiguration(jar.getHash()).getPluginClasses()) {
            ArrayList<Configuration> toBeRemoved = new ArrayList<Configuration>();
            for (Configuration configuration : this.model.pluginConfigurations()) {
                if (configuration.getPluginClass() != aClass.getPluginClass()) continue;
                toBeRemoved.add(configuration);
            }
            for (Configuration configuration : toBeRemoved) {
                this.model.pluginConfigurations().remove(configuration);
            }
        }
        this.model.jars().remove(jar);
    }

    public List<JarConfigurationModel> getInstalledJars() {
        return new ArrayList<JarConfigurationModel>(this.model.jars());
    }

    private <T extends LibraryItem> T findInObjects(T item, Iterable<T> items) {
        for (LibraryItem o : items) {
            if (!LibraryItemWrapper.toString(o).equals(LibraryItemWrapper.toString(item))) continue;
            return (T)o;
        }
        return null;
    }

    private <T extends LibraryItem> boolean addObject(T t, List<T> items) {
        if (this.findInObjects(t, items) == null) {
            items.add(t);
            return true;
        }
        return false;
    }

    private <T extends LibraryItem> void removeObject(T t, List<T> items) {
        T found = this.findInObjects(t, items);
        if (found != null) {
            items.remove(t);
        }
    }

    private <T extends LibraryItem> T find(LibraryItem item, Iterable<T> items) {
        for (LibraryItem t : items) {
            if (!t.description().name().equalsIgnoreCase(item.description().name())) continue;
            return (T)t;
        }
        return null;
    }

    private <T extends LibraryItem> boolean add(T t, List<T> items) {
        if (this.find(t, items) == null) {
            if (t instanceof BlockingMaskImpl) {
                BlockingMaskImpl bm = (BlockingMaskImpl)t;
                items.add(bm.copy());
            } else if (t instanceof EmissionMaskImpl) {
                EmissionMaskImpl em = (EmissionMaskImpl)t;
                items.add(em.copy());
            } else if (t instanceof IntermodulationRejectionMaskImpl) {
                IntermodulationRejectionMaskImpl irm = (IntermodulationRejectionMaskImpl)t;
                items.add(irm.copy());
            } else if (t instanceof BitRateMappingImpl) {
                BitRateMappingImpl brm = (BitRateMappingImpl)t;
                items.add(brm.copy());
            }
            return true;
        }
        return false;
    }

    private <T extends LibraryItem> void remove(LibraryItem item, List<T> items) {
        T found = this.find(item, items);
        if (found != null) {
            items.remove(found);
        }
    }

    public List<ReceiverModel> getReceivers() {
        return Collections.unmodifiableList(this.model.receivers());
    }

    public List<TransmitterModel> getTransmitters() {
        return Collections.unmodifiableList(this.model.transmitters());
    }

    public List<CDMALLD> getCDMALinkLevelData() {
        return Collections.unmodifiableList(this.model.cdmalld());
    }

    public boolean addReceiver(ReceiverModel receiver) {
        return this.addObject(receiver, this.model.receivers());
    }

    public boolean addTransmitter(TransmitterModel transmitter) {
        return this.addObject(transmitter, this.model.transmitters());
    }

    public boolean addCDMALinkLevelData(CDMALLD data) {
        return this.addObject(data, this.model.cdmalld());
    }

    public void removeCDMALinkLevelData(CDMALLD data) {
        this.removeObject(data, this.model.cdmalld());
    }

    @Override
    public List<? extends LibraryItem> visit(ReceiverModel receiver) {
        return this.model.receivers();
    }

    @Override
    public List<? extends LibraryItem> visit(SystemPluginConfiguration system) {
        return this.model.systems();
    }

    @Override
    public List<? extends LibraryItem> visit(JarConfigurationModel jar) {
        return this.model.jars();
    }

    @Override
    public List<? extends LibraryItem> visit(TransmitterModel transmitter) {
        return this.model.transmitters();
    }

    @Override
    public List<? extends LibraryItem> visit(CDMALLD lld) {
        return this.model.cdmalld();
    }

    @Override
    public List<? extends LibraryItem> visit(EmissionMask mask) {
        return this.model.emissionMasks();
    }

    @Override
    public List<? extends LibraryItem> visit(BlockingMask mask) {
        return this.model.blockingMasks();
    }

    @Override
    public List<? extends LibraryItem> visit(IntermodulationRejectionMask mask) {
        return this.model.intermodRejectionMasks();
    }

    @Override
    public List<? extends LibraryItem> visit(BitRateMapping bitRateMapping) {
        return this.model.bitRateMappings();
    }

    @Override
    public List<? extends LibraryItem> visit(Configuration plugin) {
        return this.model.pluginConfigurations();
    }

    public void addJarFile(Configuration configuration) {
        if (!JarFiles.isBuiltIn(configuration)) {
            JarConfigurationModel jar = JarFiles.getJar(configuration);
            if (!this.model.jars().contains(jar)) {
                this.model.jars().add(jar);
            }
        }
    }

    public <M extends LibraryItem> List<M> getGroup(Class<M> modelClass) {
        if (modelClass == ReceiverModel.class) {
            return this.model.receivers();
        }
        if (modelClass == TransmitterModel.class) {
            return this.model.transmitters();
        }
        if (modelClass == AntennaGain.class) {
            List<Configuration> confs = this.getPluginConfigurations(AntennaGainConfiguration.class);
            ArrayList<AntennaGainConfiguration> results = new ArrayList<AntennaGainConfiguration>();
            for (Configuration conf : confs) {
                results.add((AntennaGainConfiguration)conf);
            }
            return results;
        }
        if (modelClass == CoverageRadius.class) {
            List<Configuration> confs = this.getPluginConfigurations(CoverageRadiusConfiguration.class);
            ArrayList<CoverageRadiusConfiguration> results = new ArrayList<CoverageRadiusConfiguration>();
            for (Configuration conf : confs) {
                results.add((CoverageRadiusConfiguration)conf);
            }
            return results;
        }
        if (modelClass == EventProcessing.class) {
            List<Configuration> confs = this.getPluginConfigurations(EventProcessingConfiguration.class);
            ArrayList<EventProcessingConfiguration> results = new ArrayList<EventProcessingConfiguration>();
            for (Configuration conf : confs) {
                results.add((EventProcessingConfiguration)conf);
            }
            return results;
        }
        if (modelClass == PropagationModel.class) {
            List<Configuration> confs = this.getPluginConfigurations(PropagationModelConfiguration.class);
            ArrayList<PropagationModelConfiguration> results = new ArrayList<PropagationModelConfiguration>();
            for (Configuration conf : confs) {
                results.add((PropagationModelConfiguration)conf);
            }
            return results;
        }
        if (modelClass == EmissionMask.class) {
            return this.model.emissionMasks();
        }
        if (modelClass == BlockingMask.class) {
            return this.model.blockingMasks();
        }
        if (modelClass == IntermodulationRejectionMask.class) {
            return this.model.intermodRejectionMasks();
        }
        if (modelClass == BitRateMapping.class) {
            return this.model.bitRateMappings();
        }
        if (modelClass == JarConfigurationModel.class) {
            return new ArrayList<JarConfigurationModel>(this.model.jars());
        }
        if (modelClass == CDMALLD.class) {
            return this.model.cdmalld();
        }
        if (modelClass == SystemPluginConfiguration.class) {
            return this.model.systems();
        }
        if (modelClass == SystemListItem.class) {
            ArrayList<SystemListItem> items = new ArrayList<SystemListItem>();
            for (SystemPluginConfiguration configuration : this.model.systems()) {
                SystemPlugin instance = JarFiles.instance(configuration);
                items.add(new SystemListItem(instance));
            }
            return items;
        }
        throw new RuntimeException("unknown library item type: " + modelClass);
    }

    public static String typeName(Class<? extends LibraryItem> clazz) {
        if (ReceiverModel.class.isAssignableFrom(clazz)) {
            return "Receiver";
        }
        if (TransmitterModel.class.isAssignableFrom(clazz)) {
            return "Transmitter";
        }
        if (EmissionMaskImpl.class.isAssignableFrom(clazz)) {
            return "Spectrum Emission Mask";
        }
        if (BlockingMask.class.isAssignableFrom(clazz)) {
            return "Receiver Blocking Mask";
        }
        if (IntermodulationRejectionMask.class.isAssignableFrom(clazz)) {
            return "Intermodulation Rejection Mask";
        }
        if (BitRateMapping.class.isAssignableFrom(clazz)) {
            return "Bit Rate Mapping";
        }
        if (Configuration.class.isAssignableFrom(clazz)) {
            return Library.name(clazz);
        }
        if (JarConfigurationModel.class.isAssignableFrom(clazz)) {
            return "Jar file";
        }
        return "unknown";
    }

    public String typeName(LibraryItem instance) {
        if (instance instanceof ReceiverModel) {
            return "Receiver";
        }
        if (instance instanceof TransmitterModel) {
            return "Transmitter";
        }
        if (instance instanceof EmissionMaskImpl) {
            return "Spectrum Emission Mask";
        }
        if (instance instanceof BlockingMaskImpl) {
            return "Receiver Blocking Mask";
        }
        if (instance instanceof IntermodulationRejectionMask) {
            return "Intermodultaion Rejection Maks";
        }
        if (instance instanceof BitRateMapping) {
            return "Bit Rate Mapping";
        }
        if (instance instanceof Configuration) {
            return Library.name(((Configuration)instance).getClass());
        }
        if (instance instanceof JarConfigurationModel) {
            return "Jar file";
        }
        if (instance instanceof CDMALinkLevelData || instance instanceof CDMALLD) {
            return "CDMA Link level data";
        }
        if (instance instanceof SystemModel || instance instanceof SystemPluginConfiguration) {
            return "System";
        }
        return "unknown";
    }

    public static String name(Class<? extends Configuration> clazz) {
        if (clazz == PropagationModelConfiguration.class) {
            return "Propagation Model Plugin";
        }
        if (clazz == EventProcessingConfiguration.class) {
            return "Event Processing Plugin";
        }
        if (clazz == CoverageRadiusConfiguration.class) {
            return "Coverage Radius Plugin";
        }
        if (clazz == AntennaGainConfiguration.class) {
            return "Antenna Gain Plugin";
        }
        return "Unknown plugin type";
    }

    public <T extends LibraryItem> boolean add(Class<T> clazz, T instance) {
        return this.addObject(instance, this.getGroup(clazz));
    }

    public <T extends LibraryItem> void removeItem(Class<T> clazz, T item) {
        List<T> group = this.getGroup(clazz);
        T found = this.findInObjects(item, group);
        this.removeObject(found, group);
    }

    public void ensureConsistentLibrary() {
        SystemPluginConfiguration pDl;
        boolean bl;
        boolean bl2;
        ArrayList<Class<? extends Plugin>> builtIn = new ArrayList<Class<? extends Plugin>>(Model.getInstance().getBuiltInPlugins());
        List<Configuration> configs = this.getPluginConfigurations();
        for (Configuration configuration : configs) {
            builtIn.remove(configuration.getPluginClass());
        }
        for (Class clazz : builtIn) {
            if (EventProcessingPlugin.class.isAssignableFrom(clazz)) {
                this.addPluginConfiguration(Factory.eventProcessors().getByClass(clazz));
                continue;
            }
            if (PropagationModelPlugin.class.isAssignableFrom(clazz)) {
                this.addPluginConfiguration(Factory.propagationModelFactory().getByClass(clazz));
                continue;
            }
            if (CoverageRadiusPlugin.class.isAssignableFrom(clazz)) {
                this.addPluginConfiguration(Factory.coverageRadii().getByClass(clazz));
                continue;
            }
            if (!AntennaGainPlugin.class.isAssignableFrom(clazz)) continue;
            this.addPluginConfiguration(Factory.antennaGainFactory().getByClass(clazz));
        }
        ArrayList<JarConfigurationModel> toBeRemoved = new ArrayList<JarConfigurationModel>();
        for (JarConfigurationModel jarConfigurationModel : this.getInstalledJars()) {
            for (PluginClass pluginClass : jarConfigurationModel.getPluginClasses()) {
                try {
                    this.ensurePluginConfiguration(pluginClass.configuration());
                }
                catch (AbstractMethodError abstractMethodError) {
                    LOG.error("Error instantiating plugin. Removing JAR: " + jarConfigurationModel.getName());
                    toBeRemoved.add(jarConfigurationModel);
                }
            }
        }
        for (JarConfigurationModel jarConfigurationModel : toBeRemoved) {
            this.removeJarAndDependencies(jarConfigurationModel);
        }
        LinkedHashMap<Class<? extends SystemPlugin>, String> linkedHashMap = new LinkedHashMap<Class<? extends SystemPlugin>, String>();
        for (Class<? extends SystemPlugin> clazz : Model.getInstance().getBuiltInSystemPlugins()) {
            if (clazz == AggregateSystemPlugin.class) continue;
            linkedHashMap.put(clazz, "BUILT-IN");
        }
        for (JarConfigurationModel jarConfigurationModel : this.getInstalledJars()) {
            for (Class<? extends SystemPlugin> clazz : jarConfigurationModel.getSystemPlugins()) {
                linkedHashMap.put(clazz, jarConfigurationModel.getHash());
            }
        }
        for (SystemPluginConfiguration systemPluginConfiguration : this.getSystems()) {
            JarConfigurationModel jarConfigurationModel = JarFiles.getJarConfiguration(systemPluginConfiguration.location());
            Class<? extends SystemPlugin> clazz = jarConfigurationModel.getSystemPluginClass(systemPluginConfiguration.classname());
            linkedHashMap.remove(clazz);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            try {
                SystemPlugin systemPlugin = (SystemPlugin)((Class)entry.getKey()).newInstance();
                this.model.systems().add(this.conf(systemPlugin, (String)entry.getValue()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        for (SystemPluginConfiguration systemPluginConfiguration : this.model.systems()) {
            SystemModelAggregate aggregate;
            List<SystemPlugin> components;
            SystemModel model = systemPluginConfiguration.configuration();
            if (!(model instanceof SystemModelAggregate) || (components = (aggregate = (SystemModelAggregate)model).tab().components().components()) == null || components.size() != 2) continue;
            if (components.get(0) instanceof IMT2020DownLinkSystemPlugin && components.get(1) instanceof IMT2020DownLinkMicroSystemPlugin) {
                bl2 = true;
                continue;
            }
            if (!(components.get(0) instanceof IMT2020UpLinkSystemPlugin) || !(components.get(1) instanceof IMT2020UpLinkMicroSystemPlugin)) continue;
            bl = true;
        }
        if (!bl2) {
            AggregateSystemPlugin aggregateSystemPlugin = new AggregateSystemPlugin();
            aggregateSystemPlugin.setUI(ProxyHelper.newComposite(SystemModelAggregate.class, "IMT-2020 DownLink Hybrid (Macro + Micro)"));
            IMT2020DownLinkSystemPlugin iMT2020DownLinkSystemPlugin = new IMT2020DownLinkSystemPlugin();
            iMT2020DownLinkSystemPlugin.setUI(ProxyHelper.newComposite(SystemModelIMT2020DownLink.class));
            aggregateSystemPlugin.addComponent(iMT2020DownLinkSystemPlugin);
            IMT2020DownLinkMicroSystemPlugin dlMicro = new IMT2020DownLinkMicroSystemPlugin();
            dlMicro.setUI(ProxyHelper.newComposite(SystemModelIMT2020DownLinkMicro.class));
            aggregateSystemPlugin.addComponent(dlMicro);
            pDl = Factory.prototype(SystemPluginConfiguration.class);
            Factory.when(pDl.classname()).thenReturn(AggregateSystemPlugin.class.getName());
            Factory.when(pDl.location()).thenReturn("BUILT-IN");
            Factory.when(pDl.configuration()).thenReturn(aggregateSystemPlugin.getUI());
            this.model.systems().add(Factory.build(pDl));
        }
        if (!bl) {
            AggregateSystemPlugin aggregateSystemPlugin = new AggregateSystemPlugin();
            aggregateSystemPlugin.setUI(ProxyHelper.newComposite(SystemModelAggregate.class, "IMT-2020 UpLink Hybrid (Macro + Micro)"));
            IMT2020UpLinkSystemPlugin iMT2020UpLinkSystemPlugin = new IMT2020UpLinkSystemPlugin();
            iMT2020UpLinkSystemPlugin.setUI(ProxyHelper.newComposite(SystemModelIMT2020UpLink.class));
            aggregateSystemPlugin.addComponent(iMT2020UpLinkSystemPlugin);
            IMT2020UpLinkMicroSystemPlugin ulMicro = new IMT2020UpLinkMicroSystemPlugin();
            ulMicro.setUI(ProxyHelper.newComposite(SystemModelIMT2020UpLinkMicro.class));
            aggregateSystemPlugin.addComponent(ulMicro);
            pDl = Factory.prototype(SystemPluginConfiguration.class);
            Factory.when(pDl.classname()).thenReturn(AggregateSystemPlugin.class.getName());
            Factory.when(pDl.location()).thenReturn("BUILT-IN");
            Factory.when(pDl.configuration()).thenReturn(aggregateSystemPlugin.getUI());
            this.model.systems().add(Factory.build(pDl));
        }
    }

    private SystemPluginConfiguration conf(SystemPlugin plugin, String location) {
        Class<? extends SystemModel> pluginUIClass = GenericTypeMarshaller.getPluginUIClass(plugin);
        SystemPluginConfiguration conf = Factory.prototype(SystemPluginConfiguration.class);
        SystemModel value = ProxyHelper.newComposite(pluginUIClass);
        if (value.description().name() == null || value.description().name().isEmpty()) {
            SystemModel prototype = Factory.prototype(pluginUIClass, value);
            Factory.when(prototype.description()).thenReturn(new DescriptionImpl(plugin.getClass().getSimpleName(), value.description().description()));
            value = Factory.build(prototype);
        }
        Factory.when(conf.configuration()).thenReturn(value);
        Factory.when(conf.location()).thenReturn(location);
        Factory.when(conf.classname()).thenReturn(plugin.getClass().getName());
        return Factory.build(conf);
    }
}

