/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.engines.PartialSimulationResults;
import org.seamcat.model.engines.ScenarioResults;
import org.seamcat.model.engines.SeedFixer;
import org.seamcat.model.engines.SimulationPool;
import org.seamcat.model.engines.SingleEvent;
import org.seamcat.model.factory.Model;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.workspace.SimulationControl;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.presentation.simulationview.replay.SingleEventSimulationResult;
import org.seamcat.scenario.WorkspaceScenario;
import org.seamcat.simulation.Simulation;
import org.seamcat.simulation.hybrid.HybridCellularSimulation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;
import org.seamcat.simulation.result.SimulationResultImpl;

public class Workspace {
    private static final Logger LOG = Logger.getLogger(Workspace.class);
    private String name;
    private boolean hasBeenCalculated = false;
    private List<InterferenceLink> interferenceLinks = new ArrayList<InterferenceLink>();
    private SimulationResult simulationResult;
    private String victimSystemId;
    private List<SystemPlugin> systemPlugins;
    private List<InterferenceLinkElement> interferenceLinkUIs;
    private List<EventProcessingConfiguration> eventProcessingList;
    private SimulationControl simulationControl;
    private Distribution victimFrequency;
    private List<Distribution> interferingLinkFrequency = new ArrayList<Distribution>();
    private PartialSimulationResults partial;
    private WorkspaceScenario scenario;
    private List<MigrationIssue> migrationIssues;
    private File path;
    private EventResult last;
    public AbstractDmaSystem cellularVictimSimulation;
    public Map<Integer, AbstractDmaSystem> cellularInterferingSystemSimulation = new HashMap<Integer, AbstractDmaSystem>();

    public String getFileExtension() {
        if (this.isHasBeenCalculated() || this.partial != null) {
            return ".swr";
        }
        return ".sws";
    }

    public Workspace() {
        this.eventProcessingList = new ArrayList<EventProcessingConfiguration>();
        this.migrationIssues = new ArrayList<MigrationIssue>();
    }

    public List<InterferenceLink> getInterferenceLinks() {
        return this.interferenceLinks;
    }

    public SimulationResultImpl getSimulationResults() {
        return (SimulationResultImpl)this.simulationResult;
    }

    public void setSimulationResult(SimulationResult simulationResult) {
        this.simulationResult = simulationResult;
    }

    public boolean hasDMASubSystem() {
        if (this.getVictimSystem() instanceof HybridSystemPlugin) {
            return true;
        }
        for (InterferenceLinkElement ui : this.interferenceLinkUIs) {
            if (!(this.getSystemPlugin(ui.getInterferingSystemId()) instanceof HybridSystemPlugin)) continue;
            return true;
        }
        return false;
    }

    public boolean isHasBeenCalculated() {
        return this.hasBeenCalculated;
    }

    public void setHasBeenCalculated(boolean hasBeenCalculated) {
        this.hasBeenCalculated = hasBeenCalculated;
    }

    public File simulate(Simulation simulation, InterferenceSimulationEngine engine) {
        if (this.getSimulationControl().debugMode()) {
            SimulationPool pool = new SimulationPool(1);
            this.simulationResult = engine.simulateInterference(pool);
            pool.destroy();
        } else {
            this.simulationResult = engine.simulateInterference(Model.getSimulationPool());
        }
        if (this.simulationResult != null) {
            this.hasBeenCalculated = true;
            this.setWorkspacePostSimulationState(simulation);
            this.last = engine.getLastEventResult();
        }
        return simulation.getLogfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleEventSimulationResult simulateSingle(long simulationSeed, int eventNumber) {
        final SimulationResultImpl results = this.getSimulationResults();
        EventResult single = null;
        Simulation simulation = new Simulation(this, this.scenario){

            @Override
            public boolean lastEvent(EventResult eventResult) {
                return true;
            }
        };
        try {
            simulation.appendDebugLog();
            single = new SingleEvent(new SeedFixer(){

                @Override
                public void fixSeed(long simulationSeed, int eventNumber) {
                    RandomAccessor.fixSeed(InterferenceSimulationEngine.calculateEventSeed(simulationSeed, eventNumber));
                }
            }, simulationSeed, eventNumber, new ScenarioResults(){

                @Override
                public Results getResults(InterferenceLink link) {
                    return results.getResult(link);
                }

                @Override
                public Results getVictimResults() {
                    return results.getVictimResults();
                }
            }, simulation).single();
            this.setWorkspacePostSimulationState(simulation);
            if (single != null) {
                simulation.removeDebugLog();
                this.last = single;
            }
        }
        catch (RuntimeException e) {
            LOG.error("Error during simulation", e);
        }
        catch (Exception e) {
            LOG.error("Error during simulation", e);
        }
        finally {
            this.setSimulationResult(results);
        }
        File logfile = simulation.getLogfile();
        return new SingleEventSimulationResult(logfile, single, this.scenario, this);
    }

    public EventResult getLastEventResult() {
        return this.last;
    }

    private void setWorkspacePostSimulationState(Simulation simulation) {
        this.cellularVictimSimulation = null;
        List<SimulationInstance> sims = simulation.getLastEventSimulations();
        if (sims.get(0) instanceof HybridCellularSimulation) {
            this.cellularVictimSimulation = ((HybridCellularSimulation)sims.get(0)).getSystem();
        }
        for (int i = 1; i < sims.size(); ++i) {
            if (!(sims.get(i) instanceof HybridCellularSimulation)) continue;
            this.cellularInterferingSystemSimulation.put(i, ((HybridCellularSimulation)sims.get(i)).getSystem());
        }
    }

    public List<EventProcessingConfiguration> getEventProcessingList() {
        return this.eventProcessingList;
    }

    public void setEventProcessingList(List<EventProcessingConfiguration> eventProcessingList) {
        this.eventProcessingList = eventProcessingList;
    }

    public void setScenario(WorkspaceScenario scenario) {
        this.scenario = scenario;
    }

    public WorkspaceScenario getScenario() {
        return this.scenario;
    }

    public List<MigrationIssue> getMigrationIssues() {
        return this.migrationIssues;
    }

    public void setMigrationIssues(List<MigrationIssue> migrationIssues) {
        this.migrationIssues = migrationIssues;
    }

    public void addInterferenceLink(InterferenceLinkElement element, Distribution frequency) {
        this.interferenceLinkUIs.add(element);
        this.interferingLinkFrequency.add(frequency);
    }

    public List<InterferenceLinkElement> getInterferenceLinkUIs() {
        return this.interferenceLinkUIs;
    }

    public void setInterferenceLinkUIs(List<InterferenceLinkElement> interferenceLinkUIs) {
        this.interferenceLinkUIs = interferenceLinkUIs;
    }

    public String getVictimSystemId() {
        return this.victimSystemId;
    }

    public void setVictimSystemId(String victimSystemId) {
        this.victimSystemId = victimSystemId;
    }

    public List<SystemPlugin> getSystemPlugins() {
        return this.systemPlugins;
    }

    public List<SystemPlugin> getSystemPluginsRecursive() {
        ArrayList<SystemPlugin> accumulator = new ArrayList<SystemPlugin>();
        for (SystemPlugin plugin : this.systemPlugins) {
            accumulator.add(plugin);
            if (!(plugin instanceof AggregateSystemPlugin)) continue;
            for (SystemPlugin componentPlugin : ((AggregateSystemPlugin)plugin).getComponents()) {
                accumulator.add(componentPlugin);
            }
        }
        return accumulator;
    }

    public String getSystemPluginPathName(SystemPlugin plugin) {
        String targetId = plugin.getUI().id();
        for (SystemPlugin systemPlugin : this.systemPlugins) {
            if (systemPlugin.getUI().id().equals(targetId)) {
                return systemPlugin.getUI().description().name();
            }
            if (!(systemPlugin instanceof AggregateSystemPlugin)) continue;
            for (SystemPlugin componentPlugin : ((AggregateSystemPlugin)systemPlugin).getComponents()) {
                if (!componentPlugin.getUI().id().equals(targetId)) continue;
                return systemPlugin.getUI().description().name() + " / " + componentPlugin.getUI().description().name();
            }
        }
        throw new RuntimeException("System not found in workspace");
    }

    public void setSystemPlugins(List<SystemPlugin> systemPlugins) {
        this.systemPlugins = systemPlugins;
    }

    public SystemPlugin getSystemPlugin(String id) {
        for (SystemPlugin systemModel : this.getSystemPluginsRecursive()) {
            if (!systemModel.getUI().id().equals(id)) continue;
            return systemModel;
        }
        return null;
    }

    public SystemPlugin getVictimSystem() {
        return this.getSystemPlugin(this.victimSystemId);
    }

    public SimulationControl getSimulationControl() {
        return this.simulationControl;
    }

    public void setSimulationControl(SimulationControl simulationControl) {
        this.simulationControl = simulationControl;
    }

    public void prepareSimulate() {
        this.setSimulationResult(new SimulationResultImpl());
        for (EventProcessingConfiguration configuration : this.eventProcessingList) {
            if (configuration.getId() != null && !configuration.getId().isEmpty()) continue;
            configuration.setId(UUID.randomUUID().toString());
        }
    }

    public void createScenario() {
        this.scenario = new WorkspaceScenario(this);
    }

    public void prune() {
    }

    public void setPath(File path) {
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }

    public Distribution getVictimFrequency() {
        return this.victimFrequency;
    }

    public void setVictimFrequency(Distribution victimFrequency) {
        this.victimFrequency = victimFrequency;
    }

    public List<Distribution> getInterferingLinkFrequency() {
        return this.interferingLinkFrequency;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PartialSimulationResults getPartial() {
        return this.partial;
    }

    public void setPartial(PartialSimulationResults partial) {
        this.partial = partial;
    }
}

