/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model;

import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.seamcat.presentation.MainWindow;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlValidationHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getLogger(XmlValidationHandler.class);
    public SAXParseException saxParseException = null;
    private boolean silentMode = true;
    public boolean validationError = false;

    public XmlValidationHandler(boolean silent) {
        this.silentMode = silent;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.validationError = true;
        this.saxParseException = exception;
        LOG.error("Error parsing XML: " + exception.getMessage());
        if (!this.silentMode) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), exception.getMessage(), "Error parsing XML", 2);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.validationError = true;
        this.saxParseException = exception;
        JOptionPane.showMessageDialog(MainWindow.getInstance(), exception.getMessage(), "Fatal Error while parsing XML", 0);
        LOG.error("Fatal Error while parsing XML", exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (!this.silentMode) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), exception.getMessage(), "XML Parsing Warning", 2);
        }
    }
}

