/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import java.util.ArrayList;
import java.util.Collections;
import org.seamcat.model.antenna.APmanufacturerDataInput;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class AntennaManufacturerData
implements AntennaGainPlugin<APmanufacturerDataInput> {
    private Function horizontalPattern;
    private Function verticalPattern;

    @Override
    public double evaluate(LinkResult context, AntennaResult antennaResult, double peakGain, APmanufacturerDataInput input) {
        double phi;
        double theta;
        boolean compensationToConsider;
        double phiH = antennaResult.getAzimuth();
        double thetaH = antennaResult.getElevation();
        double beta = -antennaResult.getTilt();
        if (!this.checkAngleRange(input, "horizontal") || !this.checkAngleRange(input, "vertical")) {
            return -1000.0;
        }
        if (this.horizontalPattern == null || this.verticalPattern == null) {
            this.horizontalPattern = this.convertPattern(input, input.horizontalPattern());
            this.verticalPattern = this.convertPattern(input, input.verticalPattern());
        }
        double compensation = -antennaResult.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(antennaResult.getTilt(), 0.0, 1.0E-5) || compensationToConsider) {
            double tilt = beta;
            if (compensationToConsider) {
                tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
            }
            theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(beta) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            phi = antennaResult.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        } else {
            theta = thetaH;
            phi = phiH;
        }
        if (theta < 0.0) {
            theta += 360.0;
        }
        double horiGain = this.horizontalPattern.evaluate(phi);
        double vertiGain = this.verticalPattern.evaluate(theta);
        if (input.mounted() == APmanufacturerDataInput.AntennaMounted.Vertical) {
            horiGain = this.horizontalPattern.evaluate(theta);
            vertiGain = this.verticalPattern.evaluate(phi);
        }
        double offsetCorrection = 0.0;
        offsetCorrection = Math.max(offsetCorrection, this.horizontalPattern.evaluate(0.0));
        offsetCorrection = Math.max(offsetCorrection, this.verticalPattern.evaluate(0.0));
        return peakGain + horiGain + vertiGain - offsetCorrection;
    }

    private Function convertPattern(APmanufacturerDataInput input, Function pattern) {
        if (input.angleRange() == APmanufacturerDataInput.AngleRange.From0To360) {
            return Factory.functionFactory().discreteFunction(pattern.getPoints());
        }
        ArrayList<Point2D> convertedPattern = new ArrayList<Point2D>();
        for (Point2D p : pattern.getPoints()) {
            if (p.getX() >= 0.0 && !Mathematics.equals(p.getX(), 180.0, 1.0E-5)) {
                convertedPattern.add(p);
                continue;
            }
            if (!(p.getX() < 0.0)) continue;
            convertedPattern.add(new Point2D(360.0 + p.getX(), p.getY()));
        }
        Collections.sort(convertedPattern, Point2D.X_COMPARATOR);
        convertedPattern.add(new Point2D(360.0, ((Point2D)convertedPattern.get(0)).getY()));
        return Factory.functionFactory().discreteFunction(convertedPattern);
    }

    private double convertAngleToConfineToVerticalDefinedRange(double angle) {
        if (angle < -90.0) {
            return -(angle += 180.0);
        }
        if (angle > 90.0) {
            return -(angle -= 180.0);
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext consistencyCheckContext, APmanufacturerDataInput input, Validator validator) {
        String msg = "<HtMl><br/>Antenna pattern do not fit the " + input.angleRange().toString();
        if (!this.checkAngleRange(input, "horizontal")) {
            validator.error(msg + " (horizontal)");
        } else if (input.horizontalPattern().evaluateMax() > 0.0) {
            validator.error("<br/>Horizontal: The values of the antenna gain pattern must be relative  to peak gain (i.e. &le 0 dB).");
        }
        if (!this.checkAngleRange(input, "vertical")) {
            validator.error(msg + " (vertical");
        } else if (input.verticalPattern().evaluateMax() > 0.0) {
            validator.error("<br/>Vertical: The values of the antenna gain pattern must be relative  to peak gain (i.e. &le 0 dB).");
        }
    }

    private boolean checkAngleRange(APmanufacturerDataInput input, String plane) {
        Function pattern = plane.contains("vertical") ? input.verticalPattern() : input.horizontalPattern();
        Bounds bounds = input.angleRange() == APmanufacturerDataInput.AngleRange.From0To360 ? new Bounds(0.0, 360.0, true) : new Bounds(-180.0, 180.0, true);
        return pattern.getBounds().getMin() == bounds.getMin() && pattern.getBounds().getMax() == bounds.getMax();
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Translation of Antenna Manufacturer Data", "<HtMl><b>The plugin requires antenna pattern in the range of either 0 ... 360 degree or -180 ... 180 degree.</b>It converts these data to the SEAMCAT antenna pattern range.<br/>If the antenna is mounted vertically, it virtually turns the z-axis of the antenna by 90 degree.<br/><i style = 'color: red'>In case the consistency check fails, it returns a gain of -1000 dB.</i>");
    }
}

