/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import java.util.Locale;
import org.apache.log4j.Logger;
import org.seamcat.model.antenna.Complex;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.BeamFormingCompositeInput;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class BeamFormingComposite
implements AntennaGainPlugin<BeamFormingCompositeInput> {
    private static final Logger LOG = Logger.getLogger(BeamFormingComposite.class);
    public static final UniqueValueDef ELEMENT_GAIN = Factory.results().intermediateSingle("Element gain", "dBi");

    @Override
    public Description description() {
        return new DescriptionImpl("Beam Forming Composite Antenna", "");
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, BeamFormingCompositeInput input, Validator validator) {
        if (input.nh() < 1) {
            validator.error("Horizontal elements must be larger than 0");
        }
        if (input.nv() < 1) {
            validator.error("Vertical elements must be larger than 0");
        }
    }

    @Override
    public double evaluate(LinkResult context, AntennaResult antenna, double peakGain, BeamFormingCompositeInput input) {
        AntennaResult antennaBeamForming;
        AntennaResult antennaElementArray = Factory.results().antennaResult();
        AntennaResult systemLinkAntenna = Factory.results().antennaResult();
        Locale localeForInfo = Locale.US;
        String debugInfo = "";
        double elementGain = input.element().evaluate(context, this.mechanicalTiltCorrection(antenna));
        context.setValue(ELEMENT_GAIN, elementGain);
        if (context instanceof InterferenceLinkResult) {
            antennaElementArray = antenna;
            InterferenceLinkResult iLink = (InterferenceLinkResult)context;
            if (context.txAntenna() == antenna) {
                systemLinkAntenna = iLink.getInterferingSystemLink().txAntenna();
            } else if (context.rxAntenna() == antenna) {
                systemLinkAntenna = iLink.getVictimSystemLink().rxAntenna();
            }
            antennaBeamForming = systemLinkAntenna;
            if (!Mathematics.equals(systemLinkAntenna.getRandomPanelOffsetAzimuth(), 0.0, 0.001) || !Mathematics.equals(systemLinkAntenna.getRandomPanelOffsetElevation(), 0.0, 0.001)) {
                antennaBeamForming.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(systemLinkAntenna.getRandomPanelOffsetAzimuth() - systemLinkAntenna.getAzimuth()));
                antennaBeamForming.setTilt(systemLinkAntenna.getRandomPanelOffsetElevation());
                antennaElementArray.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(systemLinkAntenna.getRandomPanelOffsetAzimuth() - antenna.getAzimuth()));
                antennaElementArray.setTilt(systemLinkAntenna.getRandomPanelOffsetElevation());
            }
            antennaBeamForming = this.mechanicalTiltCorrection(antennaBeamForming);
            antennaElementArray = this.mechanicalTiltCorrection(antennaElementArray);
            elementGain = input.element().evaluate(context, antennaElementArray);
            context.setValue(ELEMENT_GAIN, elementGain);
        } else if (!Mathematics.equals(antenna.getRandomPanelOffsetAzimuth(), 0.0, 0.001) || !Mathematics.equals(antenna.getRandomPanelOffsetElevation(), 0.0, 0.001)) {
            systemLinkAntenna.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(antenna.getRandomPanelOffsetAzimuth() - antenna.getAzimuth()));
            systemLinkAntenna.setElevation(antenna.getElevation());
            systemLinkAntenna.setTilt(antenna.getRandomPanelOffsetElevation());
            antennaBeamForming = this.mechanicalTiltCorrection(systemLinkAntenna);
            antennaElementArray.setAzimuth(antenna.getRandomPanelOffsetAzimuth());
            antennaElementArray.setElevation(antenna.getElevation());
            antennaElementArray.setTilt(antenna.getRandomPanelOffsetElevation());
            antennaElementArray = this.mechanicalTiltCorrection(antennaElementArray);
        } else {
            antennaElementArray = antennaBeamForming = this.mechanicalTiltCorrection(antenna);
        }
        Complex compositeSum = new Complex();
        Complex w = new Complex();
        Complex v = new Complex();
        double w_weight = 1.0 / Math.sqrt(input.nh() * input.nv());
        for (int m = 0; m < input.nh(); ++m) {
            for (int n = 0; n < input.nv(); ++n) {
                this.v(n, m, input, antennaElementArray, v);
                this.w(n, m, antennaBeamForming, input, w).scale(w_weight);
                compositeSum.add(w.multiply(v));
            }
        }
        double sum = Math.pow(compositeSum.abs(), 2.0);
        double gain = input.element().evaluate(context, antennaElementArray) + 10.0 * Math.log10(sum);
        if (LOG.isDebugEnabled()) {
            debugInfo = debugInfo + String.format(localeForInfo, "composite gain: %2.1f dBi; antenna azimuth: %2.1f deg; antenna elevation: %2.1f deg; antenna tilt: %2.1f deg ", gain, antenna.getAzimuth(), antenna.getElevation(), antenna.getTilt());
            LOG.debug(debugInfo);
        }
        return gain;
    }

    private AntennaResult mechanicalTiltCorrection(AntennaResult antenna) {
        if (Mathematics.equals(antenna.getTilt(), 0.0, 0.001)) {
            return antenna;
        }
        AntennaResult res = Factory.results().antennaResult();
        double phiH = antenna.getAzimuth();
        double thetaH = -antenna.getElevation();
        double tilt = -antenna.getTilt();
        double theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antenna.getAzimuth()) * Mathematics.sinD(tilt));
        if (phiH > 180.0) {
            phiH = -360.0 + phiH;
        }
        double phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
        phi = antenna.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        res.setTilt(antenna.getTilt());
        res.setAzimuth(phi);
        res.setElevation(theta);
        res.setAzimuthCompensation(antenna.getAzimuthCompensation());
        res.setElevationCompensation(antenna.getElevationCompensation());
        return res;
    }

    private Complex w(int n, int m, AntennaResult antenna, BeamFormingCompositeInput input, Complex result) {
        double azimuth = antenna.getAzimuth() > 180.0 ? antenna.getAzimuth() - 360.0 : antenna.getAzimuth();
        double elevation = antenna.getElevation();
        double vert = (double)n * input.verticalSpacing() * Mathematics.sinD(elevation);
        double hor = (double)m * input.horizontalSpacing() * Mathematics.cosD(elevation) * Mathematics.sinD(azimuth);
        double theta = Math.PI * 2 * (vert - hor);
        result.setReal(Math.cos(theta));
        result.setImaginary(Math.sin(theta));
        return result;
    }

    private Complex v(int n, int m, BeamFormingCompositeInput input, AntennaResult antenna, Complex result) {
        double azimuthPointing = antenna.getAzimuth();
        double elevationPointing = 90.0 + antenna.getElevation();
        azimuthPointing = azimuthPointing > 180.0 ? azimuthPointing - 360.0 : azimuthPointing;
        double vert = (double)n * input.verticalSpacing() * Mathematics.cosD(elevationPointing);
        double hor = (double)m * input.horizontalSpacing() * Mathematics.sinD(elevationPointing) * Mathematics.sinD(azimuthPointing);
        double theta = Math.PI * 2 * (vert + hor);
        result.setReal(Math.cos(theta));
        result.setImaginary(Math.sin(theta));
        return result;
    }
}

